/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.registries;

import com.cyanogen.experienceobelisk.block.CognitiveAlloyBlock;
import com.cyanogen.experienceobelisk.block.CognitiveCrystalBlock;
import com.cyanogen.experienceobelisk.block.ExperienceFountainBlock;
import com.cyanogen.experienceobelisk.block.ExperienceObeliskBlock;
import com.cyanogen.experienceobelisk.block.PrecisionDispellerBlock;
import com.cyanogen.experienceobelisk.registries.RegisterCreativeTab;
import com.cyanogen.experienceobelisk.registries.RegisterFluids;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegisterBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"experienceobelisk");
    public static final RegistryObject<Block> EXPERIENCE_OBELISK = BLOCKS.register("experience_obelisk", ExperienceObeliskBlock::new);
    public static final RegistryObject<Block> EXPERIENCE_FOUNTAIN = BLOCKS.register("experience_fountain", ExperienceFountainBlock::new);
    public static final RegistryObject<Block> PRECISION_DISPELLER = BLOCKS.register("precision_dispeller", PrecisionDispellerBlock::new);
    public static final RegistryObject<Block> COGNITIVE_ALLOY_BLOCK = RegisterBlocks.registerBlock("cognitive_alloy_block", CognitiveAlloyBlock::new, RegisterCreativeTab.MOD_TAB);
    public static final RegistryObject<Block> COGNITIVE_CRYSTAL_BLOCK = RegisterBlocks.registerBlock("cognitive_crystal_block", CognitiveCrystalBlock::new, RegisterCreativeTab.MOD_TAB);
    public static final RegistryObject<LiquidBlock> COGNITIUM = BLOCKS.register("cognitium", () -> new LiquidBlock(RegisterFluids.COGNITIUM_FLOWING, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60953_(value -> 10).m_60991_((p_61036_, p_61037_, p_61038_) -> true)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        RegisterBlocks.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return RegisterItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

