/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat;

import com.mojang.logging.LogUtils;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.slf4j.Logger;
import xyz.iwolfking.wolfchat.config.OptionsHolder;
import xyz.iwolfking.wolfchat.data.ChatEmoji;
import xyz.iwolfking.wolfchat.discord.ListenerRegistration;
import xyz.iwolfking.wolfchat.events.DimensionChangedEvent;
import xyz.iwolfking.wolfchat.events.PlayerGameModeEvent;
import xyz.iwolfking.wolfchat.events.PlayerTabNameEvent;
import xyz.iwolfking.wolfchat.events.VaultLeaveEvent;
import xyz.iwolfking.wolfchat.events.WolfChatEvent;

@Mod(value="wolfchat")
public class Wolfchat {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static String CHAT_FORMAT;
    public static String TIMESTAMP_FORMAT;
    public static String TIMEZONE_ID;
    public static String TABLIST_FORMAT;
    public static final PermissionNode<String> stringPerm;

    public Wolfchat() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)OptionsHolder.COMMON_SPEC, "wolfchat-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(WolfChatEvent::onServerChat);
        MinecraftForge.EVENT_BUS.addListener(DimensionChangedEvent::onEnterVault);
        MinecraftForge.EVENT_BUS.addListener(DimensionChangedEvent::onDeathInVault);
        MinecraftForge.EVENT_BUS.addListener(PlayerTabNameEvent::onTabListNameFormat);
        MinecraftForge.EVENT_BUS.addListener(ListenerRegistration::onJDAInit);
        MinecraftForge.EVENT_BUS.addListener(PlayerGameModeEvent::onPlayerChangeGameMode);
        MinecraftForge.EVENT_BUS.addListener(VaultLeaveEvent::onLeaveVault);
        ChatEmoji.initializeEmojiMap();
    }

    private void setup(FMLCommonSetupEvent event) {
        CHAT_FORMAT = (String)OptionsHolder.COMMON.chatFormatting.get();
        TIMESTAMP_FORMAT = (String)OptionsHolder.COMMON.timestampFormat.get();
        TIMEZONE_ID = (String)OptionsHolder.COMMON.timeZoneId.get();
        TABLIST_FORMAT = (String)OptionsHolder.COMMON.tabListFormat.get();
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfigEvent.Loading configLoadEvent) {
        CHAT_FORMAT = (String)OptionsHolder.COMMON.chatFormatting.get();
        TIMESTAMP_FORMAT = (String)OptionsHolder.COMMON.timestampFormat.get();
        TIMEZONE_ID = (String)OptionsHolder.COMMON.timeZoneId.get();
        TABLIST_FORMAT = (String)OptionsHolder.COMMON.tabListFormat.get();
    }

    @SubscribeEvent
    public void onPermissionLoad(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{stringPerm});
    }

    static {
        stringPerm = new PermissionNode("wolfchat", "wolfchat.usernameColor", PermissionTypes.STRING, (player, playerUUID, context) -> "GOLD", new PermissionDynamicContextKey[0]);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

