/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xyz.iwolfking.wolfchat.integration.FTBEIntegration;
import xyz.iwolfking.wolfchat.util.MessageFunctions;

public class InVaultCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"invault").executes(InVaultCommand::inVault));
    }

    private static int inVault(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        TextComponent vaultMods;
        PlayerList list = ((CommandSourceStack)command.getSource()).m_81377_().m_6846_();
        List onlinePlayers = list.m_11314_();
        boolean sentMessage = false;
        HashMap<ServerPlayer, TextComponent> playerToVaultsMap = new HashMap<ServerPlayer, TextComponent>();
        HashMap vaultToPlayerMap = new HashMap();
        for (ServerPlayer player : onlinePlayers) {
            if (!ServerVaults.get((Level)player.f_19853_).isPresent()) continue;
            Optional vault = ServerVaults.get((Level)player.m_183503_());
            Vault vaultObj = null;
            if (vault.isPresent()) {
                vaultObj = (Vault)vault.get();
            }
            if (vaultObj == null) continue;
            vaultMods = InVaultCommand.getVaultModifiers((Modifiers)vaultObj.get(Vault.MODIFIERS));
            playerToVaultsMap.put(player, vaultMods);
            if (vaultToPlayerMap.get(vaultObj) == null) {
                ArrayList<ServerPlayer> playerList = new ArrayList<ServerPlayer>();
                playerList.add(player);
                vaultToPlayerMap.put(vaultObj, playerList);
                continue;
            }
            ((List)vaultToPlayerMap.get(vaultObj)).add(player);
        }
        for (List playerList : vaultToPlayerMap.values()) {
            TextComponent vaultMessage = new TextComponent("");
            Iterator iterator = playerList.iterator();
            vaultMods = new TextComponent("");
            while (iterator.hasNext()) {
                ServerPlayer player = (ServerPlayer)iterator.next();
                if (!iterator.hasNext()) {
                    if (playerList.size() != 1) {
                        vaultMessage.m_130946_("and ");
                    }
                    vaultMessage.m_7220_(FTBEIntegration.getPlayerNicknameFormatted(player));
                    vaultMods = (Component)playerToVaultsMap.get(player);
                    continue;
                }
                vaultMessage.m_7220_(FTBEIntegration.getPlayerNicknameFormatted(player));
                vaultMessage.m_130946_(", ");
            }
            if (playerList.size() == 1) {
                vaultMessage.m_130946_(" is in a ");
            } else {
                vaultMessage.m_130946_(" are in a ");
            }
            vaultMessage.m_7220_((Component)vaultMods);
            if (vaultMods.equals(new TextComponent(""))) {
                vaultMessage.m_130946_("vault.");
            } else {
                vaultMessage.m_130946_(" vault.");
            }
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81375_(), (MutableComponent)vaultMessage);
            sentMessage = true;
        }
        if (!sentMessage) {
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81375_(), (MutableComponent)new TextComponent("There are no players in a vault."));
        }
        return 1;
    }

    public static Component getVaultModifiers(Modifiers modifiers) {
        List mods = modifiers.getModifiers();
        TextComponent finalModifersString = new TextComponent("");
        Iterator iterator = mods.iterator();
        HashMap<VaultModifier, Integer> vaultModsCount = new HashMap<VaultModifier, Integer>();
        while (iterator.hasNext()) {
            VaultModifier mod = (VaultModifier)iterator.next();
            if (vaultModsCount.containsKey(mod)) {
                vaultModsCount.put(mod, (Integer)vaultModsCount.get(mod) + 1);
                continue;
            }
            vaultModsCount.put(mod, 1);
        }
        int i = 0;
        for (VaultModifier mod : vaultModsCount.keySet()) {
            Integer modCount = (Integer)vaultModsCount.get(mod);
            Component modText = mod.getNameComponentFormatted(modCount.intValue());
            String emojiStrippedModifierText = modText.getString().replaceAll(":.*: *", "");
            TextComponent newModText = new TextComponent(emojiStrippedModifierText);
            if (vaultModsCount.keySet().size() == i + 1) {
                finalModifersString.m_7220_((Component)new TextComponent(modCount.toString() + "x ").m_7220_((Component)newModText));
            } else {
                finalModifersString.m_7220_((Component)new TextComponent(modCount.toString() + "x ").m_7220_((Component)newModText));
                finalModifersString.m_130946_(", ");
            }
            ++i;
        }
        return finalModifersString;
    }
}

