/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.vault.stat.StatTotals;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.UsernameCache;
import xyz.iwolfking.wolfchat.util.MessageFunctions;

public class VaultStatsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vhstats").then(Commands.m_82129_((String)"name", (ArgumentType)MessageArgument.m_96832_()).executes(VaultStatsCommand::vaultStatsCommand)));
    }

    private static int vaultStatsCommand(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        String username = MessageArgument.m_96835_(command, (String)"name").getString();
        if (UsernameCache.getMap().containsValue(username) && ((CommandSourceStack)command.getSource()).m_81377_().m_129927_().m_10996_(username).isPresent()) {
            UUID uuid = ((GameProfile)((CommandSourceStack)command.getSource()).m_81377_().m_129927_().m_10996_(username).get()).getId();
            PlayerVaultStats playerStats = PlayerVaultStatsData.get((ServerLevel)((CommandSourceStack)command.getSource()).m_81372_()).getVaultStats(uuid);
            StatTotals vaultStats = StatTotals.of((UUID)uuid);
            String totalVaults = String.valueOf(vaultStats.getTotalVaults());
            String completedVaults = String.valueOf(vaultStats.getCompleted());
            String bailedVaults = String.valueOf(vaultStats.getBailed());
            String failedVaults = String.valueOf(vaultStats.getFailed());
            String treasureRoomsOpened = String.valueOf(vaultStats.getTreasureRoomsOpened());
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), (MutableComponent)new TextComponent(ChatFormatting.GREEN + username + "'s Vault Stats"));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), new TextComponent("\u56de Total Vaults: " + totalVaults).m_130940_(ChatFormatting.GOLD));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), new TextComponent("\u2605 Vaults Completed: " + completedVaults).m_130940_(ChatFormatting.GOLD));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), new TextComponent("\u263a Vaults Survived: " + bailedVaults).m_130940_(ChatFormatting.GOLD));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), new TextComponent("\u2620 Vaults Failed: " + failedVaults).m_130940_(ChatFormatting.GOLD));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), new TextComponent("\u265a Treasure Rooms Opened: " + treasureRoomsOpened).m_130940_(ChatFormatting.GOLD));
            MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), (MutableComponent)new TextComponent(ChatFormatting.GREEN + username + ChatFormatting.YELLOW + " is currently Vault Level " + ChatFormatting.GREEN + playerStats.getVaultLevel() + ChatFormatting.YELLOW + "!"));
            return 1;
        }
        MessageFunctions.sendMessage((Player)((CommandSourceStack)command.getSource()).m_81373_(), (MutableComponent)new TextComponent("Could not find a player with that username."));
        return 1;
    }
}

