/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.config;

import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class OptionsHolder {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static String getConfigString(String categoryName, String keyName) {
        ForgeConfigSpec.ConfigValue value = (ForgeConfigSpec.ConfigValue)COMMON_SPEC.getValues().get(Arrays.asList(categoryName, keyName));
        return (String)value.get();
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
    }

    public static class Common {
        private static final String defaultChatFormatting = "<%groupcolor%%prefix% %usercolor%%username%%reset%> %message%";
        private static final String defaultTimeZoneId = "system";
        private static final String defaultTimestampFormat = "h:mm a";
        public final ForgeConfigSpec.ConfigValue<String> chatFormatting;
        public final ForgeConfigSpec.ConfigValue<String> timeZoneId;
        public final ForgeConfigSpec.ConfigValue<String> timestampFormat;
        public final ForgeConfigSpec.ConfigValue<String> tabListFormat;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Message Format");
            this.chatFormatting = builder.comment("Chat Formatting").define("format", (Object)defaultChatFormatting);
            this.timeZoneId = builder.comment("You can change the time zone used if your server is in a different time zone than you using an ID such as America/Chicago. Otherwise, leave this as default to use your machine's TZ.").define("timezoneID", (Object)defaultTimeZoneId);
            this.timestampFormat = builder.comment("Adjust how the timestamp is displayed.").define("timestampFormat", (Object)defaultTimestampFormat);
            this.tabListFormat = builder.comment("Adjust how the tab list is displayed.").define("tabListFormat", (Object)"%gray%[%groupcolor%%prefix%%gray%] %usercolor%%username%");
            builder.pop();
        }
    }
}

