/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.data;

import java.util.HashMap;
import java.util.Map;

public enum ChatEmoji {
    SAD("frown", "\u2639"),
    HAPPY("happy", "\u263b"),
    SMILE("smile", "\u263a"),
    SLANT("slant", "\u30c4"),
    POINT_LEFT("point_left", "\u261a"),
    POINT_RIGHT("point_right", "\u261b"),
    HEART("heart", "\u2665"),
    SKULL("skull", "\u2620"),
    UMBRELLA("umbrella", "\u2602"),
    VERY_UNHAPPY("unhappy", "^\ufe35^"),
    FUNKY_HAPPY("funky", "-\u203f-"),
    SNOWMAN("snowman", "\u2603"),
    SHRUG("shrug", "\u00af\\_(\u30c4)_/\u00af"),
    WRITE("write", "\u270d"),
    PENCIL("pencil", "\u270e"),
    CROWN("crown", "\u2654"),
    STAR("star", "\u2605"),
    POG("pog", "\u2749"),
    PHONE("phone", "\u260e"),
    MUSIC("music", "\u266b"),
    MAIL("mail", "\u2709"),
    X("x", "\u2716"),
    POINT_DOWN("point_down", "\u261f"),
    POINT_UP("point_up", "\u261d"),
    RADIOACTIVE("radioactive", "\u2623"),
    SCISSORS("scissors", "\u2702");

    private final String name;
    private final String emoji;
    public static final Map<String, String> chatEmojisMap;

    private ChatEmoji(String name, String emoji) {
        this.name = name;
        this.emoji = emoji;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getName() {
        return this.name;
    }

    public static void initializeEmojiMap() {
        for (ChatEmoji emoji : ChatEmoji.values()) {
            chatEmojisMap.put("[" + emoji.getName() + "]", emoji.getEmoji());
        }
    }

    static {
        chatEmojisMap = new HashMap<String, String>();
    }
}

