/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.events;

import io.github.lightman314.lightmansdiscord.api.jda.JDAUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import xyz.iwolfking.wolfchat.Wolfchat;
import xyz.iwolfking.wolfchat.data.ChatEmoji;
import xyz.iwolfking.wolfchat.discord.ListenerRegistration;
import xyz.iwolfking.wolfchat.integration.LuckPermsIntegration;
import xyz.iwolfking.wolfchat.integration.VaultHuntersIntegration;
import xyz.iwolfking.wolfchat.util.ColorUtil;
import xyz.iwolfking.wolfchat.util.ForgeMessageUtils;
import xyz.iwolfking.wolfchat.util.MessageFunctions;

@Mod.EventBusSubscriber
public class WolfChatEvent {
    public static final Boolean isLuckPermsLoaded = ModList.get().isLoaded("luckperms");
    public static final Boolean isFTBELoaded = ModList.get().isLoaded("ftbessentials");
    public static final Boolean isVaultHuntersLoaded = ModList.get().isLoaded("the_vault");

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent e) {
        TextChannel channel;
        String id;
        JDA jda;
        boolean isQuarkItemSharing = e.getComponent().toString().contains("show_item") && !e.getMessage().contains("[item]");
        String formatting = Wolfchat.CHAT_FORMAT;
        String timezoneID = Wolfchat.TIMEZONE_ID;
        String timestampFormat = Wolfchat.TIMESTAMP_FORMAT;
        boolean calculateTimestamp = formatting.contains("%timestamp%");
        String timestamp = "";
        SimpleDateFormat timestampFormatter = new SimpleDateFormat(timestampFormat);
        ServerPlayer serverPlayer = e.getPlayer();
        Component component = Component.m_130674_((String)e.getMessage());
        String message = component.getString();
        Object user = isFTBELoaded != false ? serverPlayer.m_5446_() : new TextComponent(e.getUsername());
        UUID uuid = serverPlayer.m_142081_();
        if (calculateTimestamp && timezoneID.equalsIgnoreCase("system")) {
            timestamp = new SimpleDateFormat(timestampFormat).format(new Date());
        } else if (calculateTimestamp) {
            TimeZone timezone = TimeZone.getTimeZone(timezoneID);
            timestampFormatter.setTimeZone(timezone);
            timestamp = timestampFormatter.format(new Date());
        }
        ChatFormatting color = ChatFormatting.RESET;
        Style hoverStyle = Style.f_131099_;
        HoverEvent hoverEvent = null;
        TextComponent chatOutput = new TextComponent("");
        for (String word : formatting.split("%")) {
            TextComponent newMessage = new TextComponent(word);
            if (calculateTimestamp && word.equalsIgnoreCase("timestamp")) {
                newMessage = new TextComponent(timestamp);
            } else if (word.equalsIgnoreCase("username")) {
                newMessage = (MutableComponent)user;
            } else if (word.equalsIgnoreCase("vault_level")) {
                newMessage = isVaultHuntersLoaded.booleanValue() ? new TextComponent(VaultHuntersIntegration.getVaultLevel(e.getPlayer().m_183503_(), uuid)) : new TextComponent("");
            } else if (word.equalsIgnoreCase("message")) {
                if (isQuarkItemSharing) {
                    Component component2 = e.getComponent();
                    if (component2 instanceof TranslatableComponent) {
                        TranslatableComponent tcomp = (TranslatableComponent)component2;
                        Component targ2 = (Component)tcomp.m_131329_()[1];
                        newMessage = (MutableComponent)targ2;
                    } else {
                        newMessage = new TextComponent(e.getMessage());
                    }
                } else {
                    for (TranslatableComponent eachWord : message.split(" ")) {
                        if (!ChatEmoji.chatEmojisMap.containsKey(eachWord)) continue;
                        message = message.replace((CharSequence)eachWord, ChatEmoji.chatEmojisMap.get(eachWord));
                    }
                    if (message.contains("[item]")) {
                        TextComponent outputMessage = new TextComponent("");
                        boolean firstMetaStringFound = false;
                        for (String messageWord : message.split("\\[|\\]")) {
                            if (messageWord.equalsIgnoreCase("item") && !firstMetaStringFound) {
                                firstMetaStringFound = true;
                                ItemStack heldItem = serverPlayer.m_21120_(InteractionHand.MAIN_HAND);
                                hoverEvent = new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(heldItem));
                                hoverStyle = hoverStyle.m_131144_(hoverEvent);
                                MutableComponent messageComponent = new TextComponent(heldItem.m_41611_().getString()).m_130948_(hoverStyle).m_130948_(heldItem.m_41611_().m_7383_());
                                outputMessage.m_7220_((Component)messageComponent);
                                continue;
                            }
                            outputMessage.m_130946_(messageWord);
                        }
                        newMessage = outputMessage;
                    } else {
                        newMessage = new TextComponent(message);
                    }
                }
            } else if (word.equalsIgnoreCase("prefix")) {
                newMessage = isLuckPermsLoaded.booleanValue() ? new TextComponent(LuckPermsIntegration.getChatPrefix(uuid)) : new TextComponent("");
            } else if (word.equalsIgnoreCase("suffix")) {
                newMessage = isLuckPermsLoaded.booleanValue() ? new TextComponent(LuckPermsIntegration.getChatSuffix(serverPlayer.m_142081_())) : new TextComponent("");
            } else if (word.equalsIgnoreCase("usercolor")) {
                if (isLuckPermsLoaded.booleanValue()) {
                    color = LuckPermsIntegration.getChatColor(serverPlayer);
                }
                newMessage = new TextComponent("");
            } else if (word.equalsIgnoreCase("groupcolor")) {
                if (isLuckPermsLoaded.booleanValue()) {
                    color = LuckPermsIntegration.getGroupColor(serverPlayer.m_142081_());
                }
                newMessage = new TextComponent("");
            } else if (!word.isBlank() && (color = ColorUtil.getFormatColorFromStringNullable(word)) != null) {
                newMessage = new TextComponent("");
            }
            if (color != null) {
                newMessage.m_130940_(color);
            }
            chatOutput.m_7220_((Component)newMessage);
        }
        e.setComponent((Component)chatOutput);
        MessageEmbed embed = ForgeMessageUtils.genItemStackEmbedIfAvailable(e.getComponent());
        if (embed != null && (jda = JDAUtil.getJDA()) != null && (id = ListenerRegistration.vml.getChannel().getID()) != null && (channel = jda.getTextChannelById(id)) != null) {
            channel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue();
            serverPlayer.f_8924_.execute(() -> MessageFunctions.broadcastMessage(serverPlayer.f_19853_, (MutableComponent)chatOutput));
            e.setCanceled(true);
            return;
        }
        if (isQuarkItemSharing) {
            serverPlayer.f_8924_.execute(() -> MessageFunctions.broadcastMessage(serverPlayer.f_19853_, (MutableComponent)chatOutput));
            e.setCanceled(true);
        }
    }
}

