/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import xyz.iwolfking.wolfchat.util.ColorUtil;

public class LuckPermsIntegration {
    public static final LuckPerms api = LuckPermsProvider.get();
    private static final Set<String> VALID_TEAM_NAMES = new HashSet<String>(Arrays.asList("Idona", "Velara", "Wendarr", "Wold", "Tenos"));

    public static ChatFormatting getChatColor(ServerPlayer player) {
        if (player.m_36329_().m_83491_().isEmpty()) {
            return LuckPermsIntegration.getChatColor(player.m_142081_());
        }
        for (PlayerTeam team : player.m_36329_().m_83491_()) {
            if (!VALID_TEAM_NAMES.contains(team.m_5758_())) continue;
            return team.m_7414_();
        }
        return LuckPermsIntegration.getChatColor(player.m_142081_());
    }

    public static ChatFormatting getChatColor(UUID who) {
        User user = api.getUserManager().getUser(who);
        if (user == null) {
            return ChatFormatting.RESET;
        }
        String retrievedMeta = user.getCachedData().getMetaData().getMetaValue("wolfchat-usercolor");
        String colorMeta = retrievedMeta != null ? retrievedMeta : "reset";
        return ColorUtil.getFormatColorFromString(colorMeta);
    }

    public static ChatFormatting getGroupColor(UUID who) {
        User user = api.getUserManager().getUser(who);
        if (user == null) {
            return ChatFormatting.RESET;
        }
        String retrievedMeta = user.getCachedData().getMetaData().getMetaValue("wolfchat-groupcolor");
        String colorMeta = retrievedMeta != null ? retrievedMeta : "reset";
        return ColorUtil.getFormatColorFromString(colorMeta);
    }

    public static String getChatPrefix(UUID who) {
        User user = api.getUserManager().getUser(who);
        String prefix = "";
        if (user == null) {
            return prefix;
        }
        String userPrefix = user.getCachedData().getMetaData().getPrefix();
        prefix = userPrefix != null ? userPrefix : "";
        return prefix;
    }

    public static String getChatSuffix(UUID who) {
        User user = api.getUserManager().getUser(who);
        String suffix = "";
        if (user == null) {
            return suffix;
        }
        String userSuffix = user.getCachedData().getMetaData().getSuffix();
        suffix = userSuffix != null ? userSuffix : "";
        return suffix;
    }
}

