/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.mixin;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.iwolfking.wolfchat.Wolfchat;
import xyz.iwolfking.wolfchat.events.WolfChatEvent;
import xyz.iwolfking.wolfchat.integration.LuckPermsIntegration;
import xyz.iwolfking.wolfchat.util.ColorUtil;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerListMixin
extends Player {
    private Map<UUID, MutableComponent> tabListMap = new HashMap<UUID, MutableComponent>();

    public ServerPlayerListMixin(Level p_36114_, BlockPos p_36115_, float p_36116_, GameProfile p_36117_) {
        super(p_36114_, p_36115_, p_36116_, p_36117_);
    }

    @Inject(method={"getTabListDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetTabListDisplayName(CallbackInfoReturnable<TextComponent> cir) {
        UUID uuid = this.m_142081_();
        TextComponent user = (TextComponent)this.m_5446_();
        ChatFormatting color = ChatFormatting.RESET;
        if (this.tabListMap.get(uuid) != null) {
            cir.setReturnValue((Object)((TextComponent)this.tabListMap.get(uuid)));
        }
        if (this.m_21224_()) {
            return;
        }
        try {
            String tabListFormat = Wolfchat.TABLIST_FORMAT;
            TextComponent tabListOutput = new TextComponent("");
            for (String word : tabListFormat.split("%")) {
                TextComponent newMessage = new TextComponent(word);
                if (word.equalsIgnoreCase("username")) {
                    newMessage = user;
                } else if (word.equalsIgnoreCase("prefix")) {
                    newMessage = WolfChatEvent.isLuckPermsLoaded.booleanValue() ? new TextComponent(LuckPermsIntegration.getChatPrefix(uuid)) : new TextComponent("");
                } else if (word.equalsIgnoreCase("suffix")) {
                    newMessage = WolfChatEvent.isLuckPermsLoaded.booleanValue() ? new TextComponent(LuckPermsIntegration.getChatSuffix(uuid)) : new TextComponent("");
                } else if (word.equalsIgnoreCase("usercolor")) {
                    if (WolfChatEvent.isLuckPermsLoaded.booleanValue()) {
                        color = LuckPermsIntegration.getChatColor(uuid);
                    }
                    newMessage = new TextComponent("");
                } else if (word.equalsIgnoreCase("groupcolor")) {
                    if (WolfChatEvent.isLuckPermsLoaded.booleanValue()) {
                        color = LuckPermsIntegration.getGroupColor(uuid);
                    }
                    newMessage = new TextComponent("");
                } else if (!word.isBlank() && (color = ColorUtil.getFormatColorFromStringNullable(word)) != null) {
                    newMessage = new TextComponent("");
                }
                if (color != null) {
                    newMessage.m_130940_(color);
                }
                tabListOutput.m_7220_((Component)newMessage);
            }
            this.tabListMap.put(uuid, (MutableComponent)tabListOutput);
            cir.setReturnValue((Object)tabListOutput);
        }
        catch (Exception e) {
            return;
        }
    }
}

