/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Objects;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.iwolfking.wolfchat.util.VaultItemsHandler;

public class ForgeMessageUtils {
    private static final IForgeRegistry<Item> itemreg = ForgeRegistries.ITEMS;

    public static MessageEmbed genItemStackEmbedIfAvailable(Component component) {
        JsonObject json = JsonParser.parseString((String)Component.Serializer.m_130703_((Component)component)).getAsJsonObject();
        if (json.has("with") && json.get("with").isJsonArray()) {
            return ForgeMessageUtils.searchAndParseArray(json.getAsJsonArray("with"));
        }
        if (json.has("extra") && json.get("extra").isJsonArray()) {
            return ForgeMessageUtils.searchAndParseArray(json.getAsJsonArray("extra"));
        }
        return null;
    }

    private static MessageEmbed searchAndParseArray(JsonArray array) {
        for (JsonElement object : array) {
            JsonObject hoverEvent;
            JsonObject singleElement;
            if (!(object instanceof JsonObject) || !(singleElement = (JsonObject)object).has("hoverEvent") || !(hoverEvent = singleElement.getAsJsonObject("hoverEvent")).has("action") || !hoverEvent.get("action").getAsString().equals("show_item") || !hoverEvent.has("contents") || !hoverEvent.getAsJsonObject("contents").has("tag")) continue;
            return ForgeMessageUtils.parseJsonArgs(hoverEvent.getAsJsonObject("contents").getAsJsonObject());
        }
        return null;
    }

    private static MessageEmbed parseJsonArgs(JsonObject itemJson) {
        try {
            ItemStack itemStack = new ItemStack((ItemLike)itemreg.getValue(new ResourceLocation(itemJson.get("id").getAsString())));
            if (itemJson.has("tag")) {
                CompoundTag tag = (CompoundTag)NbtTagArgument.m_100659_().parse(new StringReader(itemJson.get("tag").getAsString()));
                itemStack.m_41751_(tag);
            }
            CompoundTag itemTag = itemStack.m_41784_();
            if (itemJson.get("id").getAsString().startsWith("the_vault")) {
                return ForgeMessageUtils.craftVaultHuntersItemMessage(itemJson, itemStack, itemTag);
            }
            EmbedBuilder embedBuilder = new EmbedBuilder();
            String title = itemStack.m_41788_() ? itemStack.m_41611_().m_6111_() : new TranslatableComponent(itemStack.m_41720_().m_5524_()).m_6111_();
            ResourceLocation registryName = Objects.requireNonNull(itemStack.m_41720_().getRegistryName());
            if (title.isEmpty()) {
                title = registryName.toString();
            } else {
                embedBuilder.setFooter(registryName.toString());
            }
            embedBuilder.setTitle(title);
            StringBuilder tooltip = new StringBuilder();
            boolean[] flags = new boolean[6];
            Arrays.fill(flags, false);
            if (itemTag.m_128441_("HideFlags")) {
                int input = itemTag.m_128451_("HideFlags");
                for (int i = 0; i < flags.length; ++i) {
                    flags[i] = (input & 1 << i) != 0;
                }
            }
            if (!flags[0]) {
                for (int i = 0; i < itemStack.m_41785_().size(); ++i) {
                    CompoundTag compoundTag = itemStack.m_41785_().m_128728_(i);
                    Registry.f_122825_.m_6612_(ResourceLocation.m_135820_((String)compoundTag.m_128461_("id"))).ifPresent(enchantment -> {
                        if (compoundTag.m_128423_("lvl") != null) {
                            int level = compoundTag.m_128423_("lvl") instanceof StringTag ? Integer.parseInt(compoundTag.m_128461_("lvl").replace("s", "")) : (compoundTag.m_128451_("lvl") == 0 ? compoundTag.m_128448_("lvl") : compoundTag.m_128451_("lvl"));
                            tooltip.append(ChatFormatting.m_126649_((String)enchantment.m_44700_(level).getString())).append("\n");
                        }
                    });
                }
            }
            ListTag list = itemTag.m_128469_("display").m_128437_("Lore", 8);
            list.forEach(nbt -> {
                try {
                    if (nbt instanceof StringTag) {
                        TextComponent comp = (TextComponent)ComponentArgument.m_87114_().parse(new StringReader(nbt.m_7916_()));
                        tooltip.append("_").append(comp.m_6111_()).append("_\n");
                    }
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            });
            if (!flags[2] && itemTag.m_128441_("Unbreakable") && itemTag.m_128471_("Unbreakable")) {
                tooltip.append("Unbreakable\n");
            }
            embedBuilder.setDescription((CharSequence)tooltip.toString());
            return embedBuilder.build();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    private static MessageEmbed craftVaultHuntersItemMessage(JsonObject itemJson, ItemStack itemStack, CompoundTag itemTag) {
        try {
            EmbedBuilder messageBuilder = new EmbedBuilder();
            messageBuilder.setTitle(itemStack.m_41786_().getString());
            String description = VaultItemsHandler.generateVaultHuntersItemTooltips(itemJson, itemStack, itemTag);
            if (description != null && !description.isBlank()) {
                messageBuilder.appendDescription((CharSequence)description);
                return messageBuilder.build();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

