/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.wolfchat.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.config.gear.VaultGearTypeConfig;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModRelics;
import iskallia.vault.item.AugmentItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.RelicFragmentItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.ArchitectCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.layout.NullCrystalLayout;
import iskallia.vault.item.crystal.modifiers.CrystalModifiers;
import iskallia.vault.item.crystal.objective.BingoCrystalObjective;
import iskallia.vault.item.crystal.objective.BossCrystalObjective;
import iskallia.vault.item.crystal.objective.CakeCrystalObjective;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.objective.ElixirCrystalObjective;
import iskallia.vault.item.crystal.objective.EmptyCrystalObjective;
import iskallia.vault.item.crystal.objective.MonolithCrystalObjective;
import iskallia.vault.item.crystal.objective.NullCrystalObjective;
import iskallia.vault.item.crystal.objective.RaidCrystalObjective;
import iskallia.vault.item.crystal.objective.ScavengerCrystalObjective;
import iskallia.vault.item.crystal.objective.SpeedrunCrystalObjective;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import iskallia.vault.item.crystal.theme.NullCrystalTheme;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.item.crystal.time.CrystalTime;
import iskallia.vault.item.crystal.time.NullCrystalTime;
import iskallia.vault.item.crystal.time.PoolCrystalTime;
import iskallia.vault.item.crystal.time.ValueCrystalTime;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.tool.PaxelItem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.woldsvaults.objectives.BallisticBingoCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.BrutalBossesCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.CorruptedCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.EnchantedElixirCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.HauntedBraziersCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.UnhingedScavengerCrystalObjective;
import xyz.iwolfking.woldsvaults.objectives.ZealotCrystalObjective;

public class VaultItemsHandler {
    private static final String EMPTY_CIRCLE = "\u25cb";
    private static final String FULL_CIRCLE = "\u25cf";
    private static final String STAR = "\u2726";
    private static final String SQUARE = "\u25a0";
    private static final String CURSE = "\u2620";
    private static final String DOT = "\u2022";
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    public static String generateVaultHuntersItemTooltips(JsonObject itemJson, ItemStack itemStack, CompoundTag itemTag) {
        try {
            StringBuilder builder = new StringBuilder();
            if (itemStack.m_41720_() instanceof BottleItem) {
                VaultItemsHandler.handleBottleTooltip(builder, itemStack);
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof VaultGearItem) {
                VaultItemsHandler.handleGearTooltip(builder, itemStack);
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof VaultDollItem) {
                VaultItemsHandler.handleDollTooltip(builder, itemTag);
                return builder.toString();
            }
            Item item = itemStack.m_41720_();
            if (item instanceof PaxelItem) {
                PaxelItem paxelItem = (PaxelItem)item;
                VaultItemsHandler.handlePaxelTooltip(builder, itemStack, paxelItem);
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof InscriptionItem) {
                VaultItemsHandler.handleInscriptionTooltip(builder, itemStack);
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof VaultCrystalItem) {
                VaultItemsHandler.handleVaultCrystalTooltip(builder, CrystalData.read((ItemStack)itemStack));
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof TrinketItem) {
                VaultItemsHandler.handleTrinketTooltip(builder, itemStack, itemTag);
                return builder.toString();
            }
            item = itemStack.m_41720_();
            if (item instanceof RelicFragmentItem) {
                RelicFragmentItem relic = (RelicFragmentItem)item;
                VaultItemsHandler.handleRelicFragmentTooltip(builder, itemStack, relic);
                return builder.toString();
            }
            if (itemStack.m_41720_() instanceof AugmentItem) {
                VaultItemsHandler.handleAugmentTooltip(builder, itemStack);
                return builder.toString();
            }
            if (ModBlocks.VAULT_ARTIFACT.getRegistryName().equals((Object)itemStack.m_41720_().getRegistryName())) {
                return builder.toString();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static void handleGearTooltip(StringBuilder builder, ItemStack itemStack) {
        VaultGearData data = VaultGearData.read((ItemStack)itemStack);
        VaultGearState state = data.getState();
        builder.append("**Level:** ").append(data.getItemLevel()).append("\n");
        data.getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> builder.append("**Crafted by:** ").append((String)crafter).append("\n"));
        switch (state) {
            case UNIDENTIFIED: {
                Objects.requireNonNull(ModConfigs.VAULT_GEAR_TYPE_CONFIG);
                data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(arg_0 -> ((VaultGearTypeConfig)ModConfigs.VAULT_GEAR_TYPE_CONFIG).getRollPool(arg_0)).ifPresent(pool -> builder.append("**Roll:** ").append(pool.getName()).append("\n"));
                break;
            }
            case IDENTIFIED: {
                builder.append("**Roll:** ").append(data.getRarity().getDisplayName().getString()).append("\n");
            }
        }
        if (state == VaultGearState.IDENTIFIED) {
            data.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ModDynamicModels.REGISTRIES.getModel(itemStack.m_41720_(), modelId)).ifPresent(gearModel -> {
                Item pattern = itemStack.m_41720_();
                if (pattern instanceof VaultGearItem) {
                    String name = gearModel.getDisplayName();
                    if (gearModel instanceof ArmorPieceModel) {
                        ArmorPieceModel modelPiece = (ArmorPieceModel)gearModel;
                        name = modelPiece.getArmorModel().getDisplayName();
                    }
                    builder.append("**Model:** ").append(name).append("\n");
                }
            });
            int usedRepairs = data.getUsedRepairSlots();
            int totalRepairs = data.getRepairSlots();
            builder.append(VaultItemsHandler.createRepairText(usedRepairs, totalRepairs)).append("\n");
            List implicits = data.getModifiers(VaultGearModifier.AffixType.IMPLICIT);
            if (!implicits.isEmpty()) {
                VaultItemsHandler.addAffixList(builder, data, VaultGearModifier.AffixType.IMPLICIT, itemStack);
                builder.append("\n");
            }
            int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
            List prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX);
            if (maxPrefixes > 0 || !prefixes.isEmpty()) {
                VaultItemsHandler.addAffixList(builder, data, VaultGearModifier.AffixType.PREFIX, itemStack);
                builder.append("\n");
            }
            int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
            List suffixes = data.getModifiers(VaultGearModifier.AffixType.SUFFIX);
            if (maxSuffixes > 0 || !suffixes.isEmpty()) {
                VaultItemsHandler.addAffixList(builder, data, VaultGearModifier.AffixType.SUFFIX, itemStack);
            }
        }
    }

    public static void handleBottleTooltip(StringBuilder builder, ItemStack itemStack) {
        if (ModConfigs.POTION == null) {
            return;
        }
        BottleItem.getType((ItemStack)itemStack).ifPresent(type -> {
            builder.append(itemStack.m_41611_().getString()).append("\n");
            BottleItem.getRecharge((ItemStack)itemStack).ifPresent(recharge -> {
                switch (recharge) {
                    case TIME: {
                        builder.append("Passively restores charges while inside a vault").append("\n");
                        break;
                    }
                    case MOBS: {
                        builder.append("Kill vault mobs to restore charges").append("\n");
                        break;
                    }
                    case CHESTS: {
                        builder.append("Loot vault chests to restore charges").append("\n");
                    }
                }
            });
            builder.append("Consume a charge to").append("\n").append(" ").append(DOT).append(" Heal ").append(ModConfigs.POTION.getPotion(type).getHealing()).append(" Hit Points").append("\n");
            BottleItem.getEffect((ItemStack)itemStack).ifPresent(effect -> builder.append(" ").append(DOT).append(" ").append(effect.getTooltip().getString()).append("\n"));
        });
    }

    public static void handleDollTooltip(StringBuilder builder, CompoundTag itemTag) {
        String owner = itemTag.m_128469_("playerProfile").m_128461_("Name");
        builder.append("**Owner:**").append(" ").append(owner).append("\n");
        int lootPercent = (int)(itemTag.m_128457_("lootPercent") * 100.0f);
        builder.append("**Loot Efficiency:**").append(" ").append(String.format("%d", lootPercent)).append("%").append("\n");
        int xpPercent = (int)(itemTag.m_128457_("xpPercent") * 100.0f);
        builder.append("**Experience Efficiency:**").append(" ").append(String.format("%d", xpPercent)).append("%").append("\n");
        if (itemTag.m_128441_("vaultUUID")) {
            builder.append("**Ready to be released!**");
        } else {
            builder.append("**Ready for a vault!**");
        }
    }

    public static void handlePaxelTooltip(StringBuilder builder, ItemStack itemStack, PaxelItem paxelItem) {
        int durability = paxelItem.getMaxDamage(itemStack);
        float miningSpeed = PaxelItem.getUsableStat((ItemStack)itemStack, (PaxelItem.Stat)PaxelItem.Stat.MINING_SPEED);
        float reach = PaxelItem.getUsableStat((ItemStack)itemStack, (PaxelItem.Stat)PaxelItem.Stat.REACH);
        float copiously = PaxelItem.getUsableStat((ItemStack)itemStack, (PaxelItem.Stat)PaxelItem.Stat.COPIOUSLY);
        builder.append("**D:** ").append(FORMAT.format(durability));
        if (reach > 0.0f) {
            builder.append(" **R:** ").append(FORMAT.format(reach));
        }
        builder.append(" **S:** ").append(FORMAT.format(miningSpeed));
        if (copiously > 0.0f) {
            builder.append(" **C:** ").append(FORMAT.format(copiously)).append("%");
        }
        builder.append("\n");
        List perks = PaxelItem.getPerks((ItemStack)itemStack);
        if (perks.size() > 0) {
            builder.append("**Perks:**");
            perks.forEach(perk -> {
                builder.append("\n");
                builder.append("  ").append(perk.m_7912_());
            });
            builder.append("\n");
        }
        int level = PaxelItem.getPaxelLevel((ItemStack)itemStack);
        builder.append("**Level:** ").append(level).append("\n");
        builder.append(VaultItemsHandler.createRepairText(PaxelItem.getUsedRepairSlots((ItemStack)itemStack), PaxelItem.getMaxRepairSlots((ItemStack)itemStack))).append("\n");
        int sockets = PaxelItem.getSockets((ItemStack)itemStack);
        if (sockets != 0) {
            builder.append("**Sockets:** ").append(VaultItemsHandler.createDots(sockets, EMPTY_CIRCLE)).append("\n");
        }
        builder.append("\n");
        PaxelItem.Stat[] stats = PaxelItem.Stat.values();
        for (int index = 0; index < stats.length; ++index) {
            PaxelItem.Stat stat = stats[index];
            float value = PaxelItem.getStatUpgrade((ItemStack)itemStack, (PaxelItem.Stat)stat);
            if (value == 0.0f) continue;
            builder.append("**").append(stat.getReadableName()).append("**");
            builder.append(value > 0.0f ? " +" : " ");
            builder.append(ModConfigs.PAXEL_CONFIGS.getUpgrade(stat).formatValue(value));
            builder.append("\n");
        }
    }

    public static void handleInscriptionTooltip(StringBuilder builder, ItemStack itemStack) {
        InscriptionData data = InscriptionData.from((ItemStack)itemStack);
        CompoundTag compoundTag = data.serializeNBT();
        builder.append("**Completion:** ").append(Math.round(compoundTag.m_128457_("completion") * 100.0f)).append("%").append("\n");
        builder.append("**Time:** ").append(VaultItemsHandler.formatTimeString(compoundTag.m_128451_("time"))).append("\n");
        builder.append("**Instability:** ").append(Math.round((float)compoundTag.m_128451_("instability") * 100.0f)).append("%").append("\n");
        for (InscriptionData.Entry entry : data.getEntries()) {
            String roomStr = entry.count > 1 ? "Rooms" : "Room";
            builder.append(" ").append(DOT).append(" ").append(entry.count).append(" ").append(entry.toRoomEntry().has(ArchitectRoomEntry.TYPE) ? ((ArchitectRoomEntry.Type)entry.toRoomEntry().get(ArchitectRoomEntry.TYPE)).getName() : "Unknown").append(" ").append(roomStr).append("\n");
        }
    }

    public static void handleVaultCrystalTooltip(StringBuilder builder, CrystalData crystalData) {
        Integer level = crystalData.getProperties().getLevel().orElse(0);
        builder.append("**Level:** ").append(level).append("\n");
        builder.append("**Objective:** ").append(VaultItemsHandler.parseObjectiveName(crystalData.getObjective()));
        builder.append("\n");
        builder.append("**Theme:** ").append(VaultItemsHandler.parseThemeName(crystalData.getTheme()));
        builder.append("\n");
        builder.append("**Layout:** ").append(VaultItemsHandler.parseLayoutName(crystalData.getLayout()));
        builder.append("\n");
        String time = VaultItemsHandler.parseTime(crystalData.getTime());
        if (!time.isBlank()) {
            builder.append(time);
            builder.append("\n");
        }
        if (crystalData.getProperties().isUnmodifiable()) {
            builder.append("**Unmodifiable**").append("\n");
        }
        VaultItemsHandler.parseModifiers(builder, crystalData.getModifiers());
    }

    public static void handleTrinketTooltip(StringBuilder builder, ItemStack itemStack, CompoundTag itemTag) {
        AttributeGearData data = AttributeGearData.read((ItemStack)itemStack);
        if (data.getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED) {
            int totalUses = itemTag.m_128451_("vaultUses");
            int used = itemTag.m_128437_("usedVaults", 10).size();
            int remaining = Math.max(totalUses - used, 0);
            builder.append("**Uses:** ").append(String.valueOf(remaining)).append("\n");
            data.getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> builder.append("**Crafted by:** ").append((String)crafter).append("\n"));
            data.getFirstValue(ModGearAttributes.TRINKET_EFFECT).ifPresent(effect -> {
                TrinketConfig.Trinket trinket = effect.getTrinketConfig();
                builder.append(trinket.getEffectText()).append("\n");
            });
            data.getFirstValue(ModGearAttributes.TRINKET_EFFECT).map(TrinketEffect::getConfig).filter(TrinketEffect.Config::hasCuriosSlot).map(TrinketEffect.Config::getCuriosSlot).ifPresent(slot -> {
                MutableComponent slotTranslation = new TranslatableComponent("curios.slot").m_130946_(": ");
                TranslatableComponent slotType = new TranslatableComponent("curios.identifier." + slot);
                builder.append("\n").append(slotTranslation.getString()).append(slotType.getString());
            });
        }
    }

    public static void handleRelicFragmentTooltip(StringBuilder builder, ItemStack itemStack, RelicFragmentItem relic) {
        Optional<ResourceLocation> resourceLocation = relic.getDynamicModelId(itemStack);
        DynamicModelRegistry fragmentRegistry = ModDynamicModels.Relics.FRAGMENT_REGISTRY;
        resourceLocation = resourceLocation.flatMap(arg_0 -> ((DynamicModelRegistry)fragmentRegistry).get(arg_0)).map(DynamicModel::getId).flatMap(ModRelics::getRelicOfFragment).map(ModRelics.RelicRecipe::getResultingRelic);
        fragmentRegistry = ModDynamicModels.Relics.RELIC_REGISTRY;
        resourceLocation.flatMap(arg_0 -> ((DynamicModelRegistry)fragmentRegistry).get(arg_0)).ifPresent(relicModel -> builder.append("**Assembles:** ").append(relicModel.getDisplayName()));
    }

    public static void handleVaultArtifactTooltip(StringBuilder builder, CompoundTag itemTag) {
        int customModelData = Math.max(itemTag.m_128451_("CustomModelData"), 1);
        String name = "vault_artifact_" + customModelData + ".png";
        builder.append("https://bonne.id.lv/assets/img/").append(name);
    }

    public static void handleAugmentTooltip(StringBuilder builder, ItemStack itemStack) {
        builder.append("**Theme:** ");
        AugmentItem.getTheme((ItemStack)itemStack).ifPresentOrElse(key -> builder.append(key.getName()), () -> builder.append("???"));
    }

    private static void addAffixList(StringBuilder builder, VaultGearData data, VaultGearModifier.AffixType type, ItemStack itemStack) {
        List affixes = data.getModifiers(type);
        VaultGearAttribute affixAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
        int emptyAffixes = data.getFirstValue(affixAttribute).orElse(0);
        builder.append("**").append(affixes.size() != 1 ? type.getPlural() : type.getSingular()).append(":** ");
        builder.append("\n");
        affixes.forEach(modifier -> VaultItemsHandler.addAffix(builder, modifier, data, type, itemStack));
        if (type != VaultGearModifier.AffixType.IMPLICIT) {
            for (int i = 0; i < emptyAffixes - affixes.size(); ++i) {
                builder.append(VaultItemsHandler.createEmptyAffix(type));
                builder.append("\n");
            }
        }
    }

    private static void addAffix(StringBuilder builder, VaultGearModifier modifier, VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack) {
        Optional.ofNullable(modifier.getAttribute().getReader().getDisplay((VaultGearAttributeInstance)modifier, data, type, stack)).map(text -> {
            if (!modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
                return text.getString();
            }
            return "\u2726 " + text.getString();
        }).ifPresent(text -> {
            MutableComponent tierDisplay = VaultGearTierConfig.getConfig((ItemStack)stack).map(tierConfig -> {
                Object config = tierConfig.getTierConfig(modifier);
                if (config != null) {
                    return modifier.getAttribute().getGenerator().getConfigDisplay(modifier.getAttribute().getReader(), config);
                }
                return null;
            }).orElse(null);
            builder.append((String)text);
            if (tierDisplay != null) {
                String legendaryInfo;
                String string = legendaryInfo = modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY) ? "**Legendary** " : "";
                if (tierDisplay.getString().isEmpty()) {
                    builder.append(" (%sT%s)".formatted(legendaryInfo, modifier.getRolledTier() + 1));
                } else {
                    builder.append(" (%sT%s: ".formatted(legendaryInfo, modifier.getRolledTier() + 1));
                    builder.append(tierDisplay.getString());
                    builder.append(")");
                }
            }
            builder.append("\n");
        });
    }

    private static String createEmptyAffix(VaultGearModifier.AffixType type) {
        return "\u25a0 empty %s".formatted(type.name().toLowerCase(Locale.ROOT));
    }

    private static String createRepairText(int usedRepairs, int totalRepairs) {
        int remaining = totalRepairs - usedRepairs;
        return "**Repairs:** " + VaultItemsHandler.createDots(usedRepairs, FULL_CIRCLE) + VaultItemsHandler.createDots(remaining, EMPTY_CIRCLE);
    }

    private static String createDots(int amount, String symbol) {
        return (symbol + " ").repeat(Math.max(0, amount));
    }

    private static void populateCatalystInformation(StringBuilder builder, List<VaultModifierStack> data, String header, Predicate<VaultModifierStack> filter) {
        List<VaultModifierStack> modifierList = data.stream().filter(filter).toList();
        if (!modifierList.isEmpty()) {
            builder.append(header).append("\n");
            for (VaultModifierStack modifierStack : modifierList) {
                VaultModifier vaultModifier = modifierStack.getModifier();
                String formattedName = vaultModifier.getDisplayNameFormatted(modifierStack.getSize());
                builder.append("  ").append("%dx".formatted(modifierStack.getSize())).append(formattedName).append("\n");
            }
        }
    }

    private static String parseObjectiveName(CrystalObjective objective) {
        if (objective instanceof RaidCrystalObjective) {
            return "Raid";
        }
        if (objective instanceof CorruptedCrystalObjective) {
            return "Corrupted";
        }
        if (objective instanceof ZealotCrystalObjective) {
            return "Zealot";
        }
        if (objective instanceof UnhingedScavengerCrystalObjective) {
            return "Unhinged Scavenger Hunt";
        }
        if (objective instanceof HauntedBraziersCrystalObjective) {
            return "Haunted Braziers";
        }
        if (objective instanceof BingoCrystalObjective) {
            return "Bingo";
        }
        if (objective instanceof BrutalBossesCrystalObjective) {
            return "Brutal Bosses";
        }
        if (objective instanceof EnchantedElixirCrystalObjective) {
            return "Enchanted Elixir";
        }
        if (objective instanceof BallisticBingoCrystalObjective) {
            return "Ballistic Bingo";
        }
        if (objective instanceof BossCrystalObjective) {
            return "Hunt the Guardians";
        }
        if (objective instanceof CakeCrystalObjective) {
            return "Cake Hunt";
        }
        if (objective instanceof ElixirCrystalObjective) {
            return "Elixir Rush";
        }
        if (objective instanceof EmptyCrystalObjective) {
            return "None";
        }
        if (objective instanceof MonolithCrystalObjective) {
            return "Light the Monoliths";
        }
        if (objective instanceof NullCrystalObjective) {
            return "???";
        }
        if (objective instanceof ScavengerCrystalObjective) {
            return "Scavenger Hunt";
        }
        if (objective instanceof SpeedrunCrystalObjective) {
            return "Speedrun";
        }
        return "???";
    }

    private static String parseThemeName(CrystalTheme theme) {
        if (theme instanceof PoolCrystalTheme) {
            return "???";
        }
        if (theme instanceof ValueCrystalTheme) {
            ThemeKey themeKey = (ThemeKey)VaultRegistry.THEME.getKey(((CompoundTag)theme.serializeNBT()).m_128461_("id"));
            if (themeKey == null) {
                return "Unknown";
            }
            return themeKey.getName();
        }
        if (theme instanceof NullCrystalTheme) {
            return "???";
        }
        return "???";
    }

    private static String parseLayoutName(CrystalLayout layout) {
        if (layout instanceof ArchitectCrystalLayout) {
            StringBuilder builder = new StringBuilder();
            builder.append("Architect");
            Optional jsonObject = layout.writeJson();
            jsonObject.ifPresent(json -> {
                JsonPrimitive completionObject;
                if (json.has("completion") && (completionObject = json.getAsJsonPrimitive("completion")).isNumber()) {
                    float completion = json.getAsJsonPrimitive("completion").getAsFloat();
                    builder.append(" | ").append(Math.min(100.0f, (float)Math.round(completion * 100.0f))).append("%");
                }
                builder.append("\n");
                if (json.has("entries") && json.get("entries").isJsonArray()) {
                    JsonArray entries = json.getAsJsonArray("entries");
                    entries.forEach(entry -> {
                        ArchitectRoomEntry architectRoomEntry = ArchitectRoomEntry.fromJson((JsonObject)((JsonObject)entry));
                        Component roomName = architectRoomEntry.getName();
                        if (roomName != null) {
                            int count = (Integer)architectRoomEntry.get(ArchitectRoomEntry.COUNT);
                            builder.append("-Has ").append(count).append(" *").append(roomName.getString()).append("* ").append(count > 1 ? "Rooms" : "Room").append("\n");
                        }
                    });
                }
            });
            return builder.toString();
        }
        if (layout instanceof ClassicCircleCrystalLayout) {
            return "Circle";
        }
        if (layout instanceof ClassicPolygonCrystalLayout) {
            return "Polygon";
        }
        if (layout instanceof ClassicSpiralCrystalLayout) {
            return "Spiral";
        }
        if (layout instanceof ClassicInfiniteCrystalLayout) {
            return "Infinite";
        }
        if (layout instanceof NullCrystalLayout) {
            return "???";
        }
        return "???";
    }

    private static String parseTime(CrystalTime time) {
        if (time instanceof PoolCrystalTime) {
            return "";
        }
        if (time instanceof ValueCrystalTime) {
            ValueCrystalTime vaultTime = (ValueCrystalTime)time;
            int min = vaultTime.getRoll().getMin();
            int max = vaultTime.getRoll().getMax();
            Object text = VaultItemsHandler.formatTimeString(min);
            if (min != max) {
                text = (String)text + " - " + VaultItemsHandler.formatTimeString(max);
            }
            return "**Time:** " + (String)text;
        }
        if (time instanceof NullCrystalTime) {
            return "";
        }
        return "";
    }

    private static void parseModifiers(StringBuilder builder, CrystalModifiers modifiers) {
        if (modifiers.hasClarity()) {
            builder.append("*Clarity*\n");
        }
        ArrayList<VaultModifierStack> modifierList = new ArrayList<VaultModifierStack>();
        for (VaultModifierStack modifier : modifiers) {
            modifierList.add(modifier);
        }
        int curseCount = modifiers.getCurseCount();
        if (curseCount > 0) {
            if (modifiers.hasClarity()) {
                VaultItemsHandler.populateCatalystInformation(builder, modifierList, "**Cursed:**", catalyst -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(catalyst.getModifierId()));
            } else {
                builder.append("**Cursed** ").append(CURSE.repeat(curseCount)).append("\n");
            }
        }
        VaultItemsHandler.populateCatalystInformation(builder, modifierList, "**Positive Modifiers:**", catalyst -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(catalyst.getModifierId()));
        VaultItemsHandler.populateCatalystInformation(builder, modifierList, "**Negative Modifiers:**", catalyst -> ModConfigs.VAULT_CRYSTAL_CATALYST.isBad(catalyst.getModifierId()));
        VaultItemsHandler.populateCatalystInformation(builder, modifierList, "**Other Modifiers:**", catalyst -> ModConfigs.VAULT_CRYSTAL_CATALYST.isUnlisted(catalyst.getModifierId()));
    }

    private static String formatTimeString(int remainingTicks) {
        long seconds = remainingTicks / 20 % 60;
        long minutes = remainingTicks / 20 / 60 % 60;
        long hours = remainingTicks / 20 / 60 / 60;
        return hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }
}

