/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import cofh.lib.util.helpers.MathHelper;
import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BasalzModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation BASALZ_LAYER = new ModelLayerLocation(new ResourceLocation("thermal:basalz"), "main");
    private static final int PILLARS = 4;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart core;
    private final ModelPart[] pillars;

    public BasalzModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.core = root.m_171324_("core");
        this.pillars = new ModelPart[4];
        Arrays.setAll(this.pillars, num -> root.m_171324_("pillar_" + num));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, -5.0f, -6.0f, 12.0f, 10.0f, 12.0f), PartPose.f_171404_);
        partdefinition.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-4.0f, 10.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        for (int i = 0; i < 4; ++i) {
            int odd = i & 1;
            partdefinition.m_171599_("pillar_" + i, CubeListBuilder.m_171558_().m_171514_(odd * 20, 38).m_171506_((float)(((i + 1 & 2) >> 1) * 17 - 11), 6.0f + (float)i, (float)(odd * 17 - 11), 5.0f, 13.0f, 5.0f, (i & 2) > 0), PartPose.f_171404_);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.core.f_104201_ = MathHelper.sin((float)(ageInTicks * 0.1f));
        float partialTicks = ageInTicks - (float)((LivingEntity)entityIn).f_19797_;
        for (ModelPart pillar : this.pillars) {
            pillar.f_104204_ = (ageInTicks * 6.0f - Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entityIn).f_20884_, (float)((LivingEntity)entityIn).f_20883_)) * (float)Math.PI / 180.0f;
        }
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

