/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.crt.machine;

import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.RefineryRecipe;
import cofh.thermal.lib.compat.crt.RecipePrintingUtil;
import cofh.thermal.lib.compat.crt.actions.ActionRemoveThermalRecipeByOutput;
import cofh.thermal.lib.compat.crt.base.CRTHelper;
import cofh.thermal.lib.compat.crt.base.CRTRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.thermal.Refinery")
@IRecipeHandler.For(value=RefineryRecipe.class)
public class CRTRefineryManager
implements IRecipeManager,
IRecipeHandler<RefineryRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, Percentaged<IItemStack> itemOutput, IFluidStack[] fluidsOutput, CTFluidIngredient inputFluid, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CRTRecipe crtRecipe = new CRTRecipe(resourceLocation).energy(energy).input(inputFluid).output(fluidsOutput).output(itemOutput);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)crtRecipe.recipe(RefineryRecipe::new)));
    }

    public RecipeType<RefineryRecipe> getRecipeType() {
        return TCoreRecipeTypes.RECIPE_REFINERY;
    }

    public void remove(IIngredient output) {
        this.removeRecipe(new IIngredient[]{output}, new IFluidStack[0]);
    }

    @ZenCodeType.Method
    public void removeRecipe(IIngredient[] itemOutputs, IFluidStack[] fluidOutputs) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveThermalRecipeByOutput(this, itemOutputs, fluidOutputs));
    }

    public String dumpToCommandString(IRecipeManager manager, RefineryRecipe recipe) {
        return String.format("<recipetype:%s>.addRecipe(\"%s\", %s, [%s], %s, %s);", recipe.m_6671_(), recipe.m_6423_(), recipe.getOutputItems().isEmpty() ? ((MCItemStack)MCItemStack.EMPTY.get()).getCommandString() : RecipePrintingUtil.stringifyWeightedStacks(recipe.getOutputItems(), recipe.getOutputItemChances(), " | "), RecipePrintingUtil.stringifyFluidStacks(recipe.getOutputFluids(), ", "), CRTHelper.stringifyFluidIngredients(recipe.getInputFluids()), recipe.getEnergy());
    }

    public Optional<Function<ResourceLocation, RefineryRecipe>> replaceIngredients(IRecipeManager manager, RefineryRecipe recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

