/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.thermal.core.util.recipes.machine.CrafterRecipe;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IManager;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import java.util.IdentityHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class CrafterRecipeManager
extends AbstractManager
implements IManager {
    private static final CrafterRecipeManager INSTANCE = new CrafterRecipeManager();
    protected static final int DEFAULT_ENERGY = 400;
    protected IdentityHashMap<Recipe<?>, CrafterRecipe> recipeMap = new IdentityHashMap();

    public static CrafterRecipeManager instance() {
        return INSTANCE;
    }

    private CrafterRecipeManager() {
        super(400);
    }

    public boolean validItem(ItemStack item, IMachineRecipe recipe) {
        CrafterRecipe crafterRecipe;
        return recipe instanceof CrafterRecipe && (crafterRecipe = (CrafterRecipe)recipe).validItem(item);
    }

    public boolean validFluid(FluidStack fluid, IMachineRecipe recipe) {
        CrafterRecipe crafterRecipe;
        return recipe instanceof CrafterRecipe && (crafterRecipe = (CrafterRecipe)recipe).validFluid(fluid);
    }

    public CrafterRecipe getRecipe(Recipe<?> recipe) {
        if (recipe == null || recipe.m_5598_() || recipe.m_8043_().m_41619_()) {
            return null;
        }
        if (!this.recipeMap.containsKey(recipe)) {
            this.recipeMap.put(recipe, new CrafterRecipe(400, recipe));
        }
        return this.recipeMap.get(recipe);
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.recipeMap.clear();
    }
}

