/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.item;

import cofh.core.item.FluidContainerItem;
import cofh.core.item.IAugmentableItem;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.ContainerType;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainerItemAugmentable
extends FluidContainerItem
implements IAugmentableItem {
    protected IntSupplier numSlots = () -> 0;
    protected BiPredicate<ItemStack, List<ItemStack>> augValidator = (e, f) -> true;

    public FluidContainerItemAugmentable(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
    }

    public FluidContainerItemAugmentable(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity);
    }

    public FluidContainerItemAugmentable setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public FluidContainerItemAugmentable setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)super.getItemEnchantability(stack) * this.getBaseMod(stack));
    }

    protected float getBaseMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FluidCre");
    }

    protected int getEffectAmplifier(MobEffectInstance effect, ItemStack stack) {
        int baseAmp = effect.m_19564_();
        if (baseAmp > 3) {
            return baseAmp;
        }
        return Math.min(3, Math.round((float)baseAmp + this.getPotionAmplifierMod(stack)));
    }

    protected int getEffectDuration(MobEffectInstance effect, ItemStack stack) {
        return Math.min(72000, Math.round((float)effect.m_19557_() * this.getPotionDurationMod(stack)));
    }

    protected float getPotionAmplifierMod(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"PotionAmp", (float)0.0f);
    }

    protected float getPotionDurationMod(ItemStack stack) {
        return 1.0f + AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"PotionDur", (float)0.0f);
    }

    public int getCapacity(ItemStack container) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"FluidMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)this.fluidCapacity * mod * base));
    }

    public int getAugmentSlots(ItemStack augmentable) {
        return this.numSlots.getAsInt();
    }

    public boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return this.augValidator.test(augment, augments);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        FluidStack fluid = this.getFluid(container);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (!fluid.isEmpty()) {
                this.fill(container, new FluidStack(fluid, this.getSpace(container)), IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            int fluidExcess = this.getFluidAmount(container) - this.getCapacity(container);
            if (fluidExcess > 0) {
                this.drain(container, fluidExcess, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

