/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBlock;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockModuleForge {
    public static final List<ExtraBlockData> EXTRA_BLOCKS = new ArrayList<ExtraBlockData>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, BlockModuleForge::registerBlocks);
    }

    private static void registerBlocks(RegistryEvent.Register<Block> event) {
        AutoRegistrationManager.BLOCKS.stream().filter(data -> !data.processed()).forEach(data -> BlockModuleForge.registerBlock(data, (IForgeRegistry<Block>)event.getRegistry()));
    }

    private static void registerBlock(AutoRegisterField data, IForgeRegistry<Block> registry) {
        ResourceLocation name;
        AutoRegisterBlock autoRegisterBlock = (AutoRegisterBlock)data.object();
        Block block = (Block)autoRegisterBlock.get();
        block.setRegistryName(data.name());
        registry.register((IForgeRegistryEntry)block);
        String namespace = data.name().m_135827_();
        String path = data.name().m_135815_();
        if (autoRegisterBlock.hasStairs()) {
            StairBlock stairBlock = new StairBlock(() -> ((Block)block).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_stairs");
            stairBlock.setRegistryName(name);
            registry.register((IForgeRegistryEntry)stairBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)stairBlock, autoRegisterBlock.getItemProperties()));
            }
        }
        if (autoRegisterBlock.hasSlab()) {
            SlabBlock slabBlock = new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_slab");
            slabBlock.setRegistryName(name);
            registry.register((IForgeRegistryEntry)slabBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)slabBlock, autoRegisterBlock.getItemProperties()));
            }
        }
        if (autoRegisterBlock.hasFence()) {
            FenceBlock fenceBlock = new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_fence");
            fenceBlock.setRegistryName(name);
            registry.register((IForgeRegistryEntry)fenceBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)fenceBlock, autoRegisterBlock.getItemProperties()));
            }
        }
        if (autoRegisterBlock.hasFenceGate()) {
            FenceGateBlock fenceGateBlock = new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_fence_gate");
            fenceGateBlock.setRegistryName(name);
            registry.register((IForgeRegistryEntry)fenceGateBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)fenceGateBlock, autoRegisterBlock.getItemProperties()));
            }
        }
        if (autoRegisterBlock.hasWall()) {
            WallBlock wallBlock = new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_wall");
            wallBlock.setRegistryName(name);
            registry.register((IForgeRegistryEntry)wallBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)wallBlock, autoRegisterBlock.getItemProperties()));
            }
        }
    }

    public record ExtraBlockData(Block block, Supplier<Item.Properties> itemProperties) {
    }
}

