/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.condition;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AllOfCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AltitudeCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AlwaysTrueCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.AnyOfCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.DepthCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.ModLoadedCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.ModLoaderCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.NotCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.PieceInHorizontalDirectionCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.PieceInRangeCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.RandomChanceCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.RotationCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public interface StructureConditionType<C extends StructureCondition> {
    public static final Map<ResourceLocation, StructureConditionType<?>> CONDITION_TYPES_BY_NAME = new HashMap();
    public static final Map<StructureConditionType<?>, ResourceLocation> NAME_BY_CONDITION_TYPES = new HashMap();
    public static final Codec<StructureConditionType<?>> CONDITION_TYPE_CODEC = ResourceLocation.f_135803_.flatXmap(resourceLocation -> Optional.ofNullable(CONDITION_TYPES_BY_NAME.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown condition type: " + resourceLocation))), conditionType -> Optional.of(NAME_BY_CONDITION_TYPES.get(conditionType)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("No ID found for condition type " + conditionType + ". Is it registered?"))));
    public static final Codec<StructureCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch("type", StructureCondition::type, StructureConditionType::codec);
    public static final StructureConditionType<AlwaysTrueCondition> ALWAYS_TRUE = StructureConditionType.register("always_true", AlwaysTrueCondition.CODEC);
    public static final StructureConditionType<AnyOfCondition> ANY_OF = StructureConditionType.register("any_of", AnyOfCondition.CODEC);
    public static final StructureConditionType<AllOfCondition> ALL_OF = StructureConditionType.register("all_of", AllOfCondition.CODEC);
    public static final StructureConditionType<NotCondition> NOT = StructureConditionType.register("not", NotCondition.CODEC);
    public static final StructureConditionType<AltitudeCondition> ALTITUDE = StructureConditionType.register("altitude", AltitudeCondition.CODEC);
    public static final StructureConditionType<DepthCondition> DEPTH = StructureConditionType.register("depth", DepthCondition.CODEC);
    public static final StructureConditionType<RandomChanceCondition> RANDOM_CHANCE = StructureConditionType.register("random_chance", RandomChanceCondition.CODEC);
    public static final StructureConditionType<PieceInRangeCondition> PIECE_IN_RANGE = StructureConditionType.register("piece_in_range", PieceInRangeCondition.CODEC);
    public static final StructureConditionType<ModLoaderCondition> MOD_LOADER = StructureConditionType.register("mod_loader", ModLoaderCondition.CODEC);
    public static final StructureConditionType<ModLoadedCondition> MOD_LOADED = StructureConditionType.register("mod_loaded", ModLoadedCondition.CODEC);
    public static final StructureConditionType<PieceInHorizontalDirectionCondition> PIECE_IN_HORIZONTAL_DIRECTION = StructureConditionType.register("piece_in_horizontal_direction", PieceInHorizontalDirectionCondition.CODEC);
    public static final StructureConditionType<RotationCondition> ROTATION = StructureConditionType.register("rotation", RotationCondition.CODEC);

    public static <C extends StructureCondition> StructureConditionType<C> register(ResourceLocation resourceLocation, Codec<C> codec) {
        StructureConditionType<C> conditionType = () -> codec;
        CONDITION_TYPES_BY_NAME.put(resourceLocation, conditionType);
        NAME_BY_CONDITION_TYPES.put(conditionType, resourceLocation);
        return conditionType;
    }

    private static <C extends StructureCondition> StructureConditionType<C> register(String id, Codec<C> codec) {
        return StructureConditionType.register(new ResourceLocation("yungsapi", id), codec);
    }

    public Codec<C> codec();
}

