/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw;

import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawConfig;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.util.Util;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.assembler.JigsawStructureAssembler;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawSinglePoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;

public class JigsawManager {
    public static Optional<PieceGenerator<YungJigsawConfig>> assembleJigsawStructure(PieceGeneratorSupplier.Context<YungJigsawConfig> ctx, JigsawPlacement.PieceFactory pieceFactory, BlockPos startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int maxDistanceFromCenter) {
        int bbCenterY;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(ctx.f_197354_(), ctx.f_197355_().f_45578_, ctx.f_197355_().f_45579_);
        ChunkGenerator chunkGenerator = ctx.f_197352_();
        StructureManager structureManager = ctx.f_197359_();
        LevelHeightAccessor levelHeightAccessor = ctx.f_197357_();
        Predicate validBiomePredicate = ctx.f_197358_();
        Registry registry = ctx.f_197360_().m_175515_(Registry.f_122884_);
        YungJigsawConfig config = (YungJigsawConfig)ctx.f_197356_();
        StructureFeature.m_67096_();
        StructureTemplatePool startPool = (StructureTemplatePool)registry.m_7745_(config.getStartPool());
        Optional<PoolElementStructurePiece> startPieceOptional = JigsawManager.getStartPiece(startPool, startPos, structureManager, pieceFactory, (Random)random);
        if (startPieceOptional.isEmpty()) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = startPieceOptional.get();
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int bbCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int bbCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int n = bbCenterY = useHeightmap ? startPos.m_123342_() + chunkGenerator.m_156174_(bbCenterX, bbCenterZ, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor) : startPos.m_123342_();
        if (!validBiomePredicate.test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)bbCenterX), QuartPos.m_175400_((int)bbCenterY), QuartPos.m_175400_((int)bbCenterZ)))) {
            return Optional.empty();
        }
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, bbCenterY - yAdjustment, 0);
        AABB aABB = new AABB((double)(bbCenterX - maxDistanceFromCenter), (double)(bbCenterY - maxDistanceFromCenter), (double)(bbCenterZ - maxDistanceFromCenter), (double)(bbCenterX + maxDistanceFromCenter + 1), (double)(bbCenterY + maxDistanceFromCenter + 1), (double)(bbCenterZ + maxDistanceFromCenter + 1));
        BoxOctree maxStructureBounds = new BoxOctree(aABB);
        maxStructureBounds.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
        return Optional.of((structurePiecesBuilder, context) -> {
            if (config.getMaxDepth() <= 0) {
                return;
            }
            JigsawStructureAssembler assembler = new JigsawStructureAssembler(new JigsawStructureAssembler.Settings().poolRegistry((Registry<StructureTemplatePool>)registry).maxDepth(config.getMaxDepth()).chunkGenerator(chunkGenerator).structureManager(structureManager).rand((Random)random).maxY(config.getMaxY()).minY(config.getMinY()).useExpansionHack(doBoundaryAdjustments).levelHeightAccessor(levelHeightAccessor).pieceFactory(pieceFactory));
            assembler.assembleStructure(startPiece, maxStructureBounds);
            assembler.addAllPiecesToStructureBuilder(structurePiecesBuilder);
        });
    }

    private static Optional<PoolElementStructurePiece> getStartPiece(StructureTemplatePool startPool, BlockPos locatePos, StructureManager structureManager, JigsawPlacement.PieceFactory pieceFactory, Random rand) {
        int chosenPieceWeight;
        ObjectArrayList candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)startPool).getRawTemplates());
        Util.shuffle(candidatePoolElements, rand);
        Rotation rotation = Rotation.m_55956_((Random)rand);
        for (int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum); candidatePoolElements.size() > 0 && totalWeightSum > 0; totalWeightSum -= chosenPieceWeight) {
            StructureContext ctx;
            YungJigsawSinglePoolElement yungSingleElement;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                YungJigsawSinglePoolElement yungSingleElement2;
                StructurePoolElement candidatePiece = (StructurePoolElement)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof YungJigsawSinglePoolElement) || !(yungSingleElement2 = (YungJigsawSinglePoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = rand.nextInt(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            StructurePoolElement chosenPoolElement = (StructurePoolElement)chosenPoolElementPair.getFirst();
            chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == EmptyPoolElement.f_210175_) {
                return Optional.empty();
            }
            if (chosenPoolElement instanceof YungJigsawSinglePoolElement && !(yungSingleElement = (YungJigsawSinglePoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureManager(structureManager).pos(locatePos).rotation(rotation).depth(0).random(rand).build())) {
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            return Optional.of(pieceFactory.m_210300_(structureManager, chosenPoolElement, locatePos, chosenPoolElement.m_210540_(), rotation, chosenPoolElement.m_207470_(structureManager, locatePos, rotation)));
        }
        return Optional.empty();
    }
}

