/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.modifier.StructureModifier;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class YungJigsawSinglePoolElement
extends SinglePoolElement {
    public static final Codec<YungJigsawSinglePoolElement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)YungJigsawSinglePoolElement.m_210465_(), (App)YungJigsawSinglePoolElement.m_210462_(), (App)YungJigsawSinglePoolElement.m_210538_(), (App)Codec.STRING.optionalFieldOf("name").forGetter(element -> element.name), (App)ExtraCodecs.f_144628_.optionalFieldOf("max_count").forGetter(element -> element.maxCount), (App)ExtraCodecs.f_144628_.optionalFieldOf("min_required_depth").forGetter(element -> element.minRequiredDepth), (App)ExtraCodecs.f_144628_.optionalFieldOf("max_possible_depth").forGetter(element -> element.maxPossibleDepth), (App)Codec.BOOL.optionalFieldOf("is_priority", (Object)false).forGetter(element -> element.isPriority), (App)Codec.BOOL.optionalFieldOf("ignore_bounds", (Object)false).forGetter(element -> element.ignoreBounds), (App)StructureConditionType.CONDITION_CODEC.optionalFieldOf("condition", (Object)StructureCondition.ALWAYS_TRUE).forGetter(element -> element.condition), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation").forGetter(element -> element.enhancedTerrainAdaptation), (App)ResourceLocation.f_135803_.optionalFieldOf("deadend_pool").forGetter(element -> element.deadendPool), (App)StructureModifier.CODEC.listOf().optionalFieldOf("modifiers", new ArrayList()).forGetter(element -> element.modifiers)).apply((Applicative)builder, YungJigsawSinglePoolElement::new));
    public final Optional<String> name;
    public final Optional<Integer> maxCount;
    @Deprecated
    public final Optional<Integer> minRequiredDepth;
    @Deprecated
    public final Optional<Integer> maxPossibleDepth;
    public final boolean isPriority;
    public final boolean ignoreBounds;
    public final StructureCondition condition;
    public final Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation;
    public final Optional<ResourceLocation> deadendPool;
    public final List<StructureModifier> modifiers;

    public YungJigsawSinglePoolElement(Either<ResourceLocation, StructureTemplate> resourceLocation, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, StructureCondition condition, Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation, Optional<ResourceLocation> deadendPool, List<StructureModifier> modifiers) {
        super(resourceLocation, processors, projection);
        this.maxCount = maxCount;
        this.name = name;
        this.minRequiredDepth = minRequiredDepth;
        this.maxPossibleDepth = maxPossibleDepth;
        this.isPriority = isPriority;
        this.ignoreBounds = ignoreBounds;
        this.condition = condition;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
        this.deadendPool = deadendPool;
        this.modifiers = modifiers;
    }

    public StructurePoolElementType<?> m_207234_() {
        return StructurePoolElementTypeModule.YUNG_SINGLE_ELEMENT;
    }

    public boolean isPriorityPiece() {
        return this.isPriority;
    }

    public boolean ignoresBounds() {
        return this.ignoreBounds;
    }

    public boolean isAtValidDepth(int depth) {
        boolean isAtMinRequiredDepth = this.minRequiredDepth.isEmpty() || this.minRequiredDepth.get() <= depth;
        boolean isAtMaxAllowableDepth = this.maxPossibleDepth.isEmpty() || this.maxPossibleDepth.get() >= depth;
        return isAtMinRequiredDepth && isAtMaxAllowableDepth;
    }

    public boolean passesConditions(StructureContext ctx) {
        return this.condition.passes(ctx);
    }

    public String toString() {
        return String.format("YungJigsawSingle[%s][%s][%s][%s][%s][%s]", this.name, this.f_210411_, this.maxCount.isPresent() ? this.maxCount.get() : "N/A", this.minRequiredDepth.isPresent() ? "" + this.minRequiredDepth.get() : "N/A", this.maxPossibleDepth.isPresent() ? "" + this.maxPossibleDepth.get() : "N/A", this.isPriority);
    }

    public EnhancedTerrainAdaptation getEnhancedTerrainAdaptation() {
        return this.enhancedTerrainAdaptation.get();
    }

    public boolean hasEnhancedTerrainAdaptation() {
        return this.enhancedTerrainAdaptation.isPresent();
    }

    public ResourceLocation getDeadendPool() {
        return this.deadendPool.get();
    }

    public boolean hasDeadendPool() {
        return this.deadendPool.isPresent();
    }

    public boolean hasModifiers() {
        return this.modifiers.size() > 0;
    }
}

