/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.ae2.mixin;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.Repo;
import appeng.menu.me.common.GridInventoryEntry;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import java.util.Comparator;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.CustomVaultGearData;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Repo.class})
public abstract class MixinRepo {
    @Inject(method={"getComparator"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public final void comparator(SortOrder sortOrder, SortDir sortDir, CallbackInfoReturnable<Comparator<GridInventoryEntry>> cir) {
        if (Screen.m_96638_()) {
            return;
        }
        boolean ascending = sortDir == SortDir.ASCENDING;
        cir.setReturnValue(((Comparator)cir.getReturnValue()).thenComparing((left, right) -> {
            AEItemKey itemKey;
            AEItemKey rightWhat;
            AEItemKey itemKey2;
            AEKey aEKey = left.getWhat();
            AEItemKey leftWhat = aEKey instanceof AEItemKey ? (itemKey2 = (AEItemKey)aEKey) : null;
            AEKey aEKey2 = right.getWhat();
            AEItemKey aEItemKey = rightWhat = aEKey2 instanceof AEItemKey ? (itemKey = (AEItemKey)aEKey2) : null;
            if (leftWhat == null || rightWhat == null) {
                return leftWhat == null ? 1 : -1;
            }
            String leftName = leftWhat.getDisplayName().getString();
            String rightName = rightWhat.getDisplayName().getString();
            if (!leftWhat.getModId().equals(rightWhat.getModId())) {
                return String.CASE_INSENSITIVE_ORDER.compare(leftWhat.getModId(), rightWhat.getModId());
            }
            ResourceLocation leftId = leftWhat.getId();
            int registryOrder = SortingHelper.compareRegistryNames(leftId, rightWhat.getId(), ascending);
            if (registryOrder != 0 || !SortingHelper.isSortable(leftId)) {
                return registryOrder;
            }
            if (leftId == ModItems.JEWEL.getRegistryName()) {
                CompoundTag leftTag = leftWhat.getTag();
                CompoundTag rightTag = rightWhat.getTag();
                if (!(leftTag.m_128441_("clientCache") && leftTag.m_128469_("clientCache").m_128441_("extra_attribute_index") && leftTag.m_128469_("clientCache").m_128441_("extra_attribute_value") && leftTag.m_128469_("clientCache").m_128441_("extra_gear_level") && leftTag.m_128469_("clientCache").m_128441_("extra_jewel_size") && leftTag.m_128469_("clientCache").m_128441_("extra_cache_version") && leftTag.m_128469_("clientCache").m_128461_("extra_cache_version").equals(VaultJewelSorting.VAULT_MOD_VERSION) && rightTag.m_128441_("clientCache") && rightTag.m_128469_("clientCache").m_128441_("extra_attribute_index") && rightTag.m_128469_("clientCache").m_128441_("extra_attribute_value") && rightTag.m_128469_("clientCache").m_128441_("extra_gear_level") && rightTag.m_128469_("clientCache").m_128441_("extra_jewel_size") && rightTag.m_128469_("clientCache").m_128441_("extra_cache_version") && rightTag.m_128469_("clientCache").m_128461_("extra_cache_version").equals(VaultJewelSorting.VAULT_MOD_VERSION))) {
                    VaultGearData leftData = CustomVaultGearData.read(leftTag);
                    VaultGearData rightData = CustomVaultGearData.read(rightTag);
                    return switch (sortOrder) {
                        default -> throw new IncompatibleClassChangeError();
                        case SortOrder.NAME -> SortingHelper.compareJewels(leftName, leftData, leftTag.m_128451_("freeCuts"), rightName, rightData, rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), ascending);
                        case SortOrder.AMOUNT -> SortingHelper.compareJewels(leftName, leftData, leftTag.m_128451_("freeCuts"), rightName, rightData, rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), ascending);
                        case SortOrder.MOD -> SortingHelper.compareJewels(leftName, leftData, leftTag.m_128451_("freeCuts"), rightName, rightData, rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), ascending);
                    };
                }
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), leftTag.m_128451_("freeCuts"), rightName, rightTag.m_128469_("clientCache"), rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), leftTag.m_128451_("freeCuts"), rightName, rightTag.m_128469_("clientCache"), rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareJewels(leftName, leftTag.m_128469_("clientCache"), leftTag.m_128451_("freeCuts"), rightName, rightTag.m_128469_("clientCache"), rightTag.m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.INSCRIPTION.getRegistryName()) {
                InscriptionData leftData = InscriptionData.empty();
                leftData.deserializeNBT(leftWhat.getTag().m_128469_("data"));
                InscriptionData rightData = InscriptionData.empty();
                rightData.deserializeNBT(rightWhat.getTag().m_128469_("data"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.VAULT_CRYSTAL.getRegistryName()) {
                CrystalData leftData = CrystalData.empty();
                leftData.readNbt(leftWhat.getTag().m_128469_("CrystalData"));
                CrystalData rightData = CrystalData.empty();
                rightData.readNbt(rightWhat.getTag().m_128469_("CrystalData"));
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.TRINKET.getRegistryName()) {
                VaultGearData leftData = CustomVaultGearData.read(leftWhat.getTag());
                VaultGearData rightData = CustomVaultGearData.read(rightWhat.getTag());
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareTrinkets(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByMod(), ascending);
                };
            }
            if (SortingHelper.VAULT_CHARMS.contains(leftId)) {
                VaultGearData leftData = CustomVaultGearData.read(leftWhat.getTag());
                VaultGearData rightData = CustomVaultGearData.read(rightWhat.getTag());
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCharmSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareCharms(leftName, (AttributeGearData)leftData, leftWhat.getTag(), rightName, (AttributeGearData)rightData, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCharmSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.VAULT_CATALYST_INFUSED.getRegistryName()) {
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareCatalysts(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareCatalysts(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareCatalysts(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.VAULT_DOLL.getRegistryName()) {
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareVaultDolls(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareVaultDolls(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getDollSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareVaultDolls(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getDollSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.RELIC_FRAGMENT.getRegistryName()) {
                return SortingHelper.compareRelicFragments(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.RESPEC_FLASK.getRegistryName()) {
                return SortingHelper.compareRespecFlasks(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.FACETED_FOCUS.getRegistryName()) {
                return SortingHelper.compareFacedFocus(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.AUGMENT.getRegistryName()) {
                return SortingHelper.compareAugments(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.CARD.getRegistryName()) {
                return switch (sortOrder) {
                    default -> throw new IncompatibleClassChangeError();
                    case SortOrder.NAME -> SortingHelper.compareCards(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCardSortingByName(), ascending);
                    case SortOrder.AMOUNT -> SortingHelper.compareCards(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCardSortingByAmount(), ascending);
                    case SortOrder.MOD -> SortingHelper.compareCards(leftName, leftWhat.getTag(), rightName, rightWhat.getTag(), VaultJewelSorting.CONFIGURATION.getCardSortingByMod(), ascending);
                };
            }
            if (leftId == ModItems.CARD_DECK.getRegistryName()) {
                return SortingHelper.compareDecks(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.BOOSTER_PACK.getRegistryName()) {
                return SortingHelper.compareBoosterPacks(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.ANTIQUE.getRegistryName()) {
                return SortingHelper.compareAntique(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.JEWEL_POUCH.getRegistryName()) {
                return SortingHelper.comparePouches(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.COMPANION_RELIC.getRegistryName()) {
                return SortingHelper.compareCompanionRelics(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.COMPANION_PARTICLE_TRAIL.getRegistryName()) {
                return SortingHelper.compareCompanionParticleTrails(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            if (leftId == ModItems.TEMPORAL_SHARD.getRegistryName()) {
                return SortingHelper.compareTemporalShards(leftWhat.getTag(), rightWhat.getTag(), ascending);
            }
            VaultGearData leftData = CustomVaultGearData.read(leftWhat.getTag());
            VaultGearData rightData = CustomVaultGearData.read(rightWhat.getTag());
            return switch (sortOrder) {
                default -> throw new IncompatibleClassChangeError();
                case SortOrder.NAME -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByName(), ascending);
                case SortOrder.AMOUNT -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByAmount(), ascending);
                case SortOrder.MOD -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByMod(), ascending);
            };
        }));
    }
}

