/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.config;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> jewelSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> jewelSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> jewelSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> gearSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> gearSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> gearSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> rarityOrder;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> inscriptionSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> inscriptionSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> inscriptionSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> vaultCrystalSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> vaultCrystalSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> vaultCrystalSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> trinketSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> trinketSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> trinketSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dollSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dollSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> dollSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> charmSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> charmSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> charmSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> catalystSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> catalystSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> catalystSortingByMod;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> cardSortingByName;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> cardSortingByAmount;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> cardSortingByMod;
    public static ForgeConfigSpec GENERAL_SPEC;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("This category holds options how Jewels are sorted");
        builder.push("Jewel Sorting");
        this.jewelSortingByName = builder.comment("The order of Jewels if they are sorted by the name.").comment("Supported Values: NAME, ATTRIBUTE, ATTRIBUTE_VALUE, SIZE, LEVEL, ATTRIBUTE_WEIGHT, CUTS").defineList("jewel_sorting_by_name", Arrays.asList(SortingHelper.JewelOptions.NAME.name(), SortingHelper.JewelOptions.ATTRIBUTE.name(), SortingHelper.JewelOptions.ATTRIBUTE_VALUE.name(), SortingHelper.JewelOptions.SIZE.name(), SortingHelper.JewelOptions.LEVEL.name(), SortingHelper.JewelOptions.CUTS.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.JewelOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.jewelSortingByAmount = builder.comment("The order of Jewels if they are sorted by the amount/size.").comment("Supported Values: NAME, ATTRIBUTE, ATTRIBUTE_VALUE, SIZE, LEVEL, ATTRIBUTE_WEIGHT, CUTS").defineList("jewel_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.JewelOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.jewelSortingByMod = builder.comment("The order of Jewels if they are sorted by the mod.").comment("Supported Values: NAME, ATTRIBUTE, ATTRIBUTE_VALUE, SIZE, LEVEL, ATTRIBUTE_WEIGHT, CUTS").defineList("jewel_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.JewelOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Gear are sorted");
        builder.push("Gear Sorting");
        this.gearSortingByName = builder.comment("The order of Gear if they are sorted by the name.").comment("Supported Values: NAME, STATE, RARITY, LEVEL, MODEL").defineList("gear_sorting_by_name", Arrays.asList(SortingHelper.GearOptions.NAME.name(), SortingHelper.GearOptions.STATE.name(), SortingHelper.GearOptions.RARITY.name(), SortingHelper.GearOptions.LEVEL.name(), SortingHelper.GearOptions.MODEL.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.GearOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.gearSortingByAmount = builder.comment("The order of Gear if they are sorted by the amount/size.").comment("Supported Values: NAME, STATE, RARITY, LEVEL, MODEL").defineList("gear_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.GearOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.gearSortingByMod = builder.comment("The order of Gear if they are sorted by the mod.").comment("Supported Values: NAME, STATE, RARITY, LEVEL, MODEL").defineList("gear_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.GearOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.rarityOrder = builder.comment("The order of Rarities Pools in the sorting for unidentified gear.").defineList("rarity_order", Arrays.asList("Scrappy", "Scrappy+", "Common", "Common+", "Rare", "Rare+", "Epic", "Epic+", "Omega", "Beginner", "Novice", "Maker", "Apprentice", "Smith", "Artisan", "Master Artisan", "Gladiator"), entry -> true);
        builder.pop();
        builder.comment("This category holds options how Inscriptions are sorted");
        builder.push("Inscription Sorting");
        this.inscriptionSortingByName = builder.comment("The order of Inscriptions if they are sorted by the name.").comment("Supported Values: NAME, INSTABILITY, TIME, COMPLETION, ROOMS").defineList("inscription_sorting_by_name", Arrays.asList(SortingHelper.InscriptionOptions.NAME.name(), SortingHelper.InscriptionOptions.ROOMS.name(), SortingHelper.InscriptionOptions.TIME.name(), SortingHelper.InscriptionOptions.COMPLETION.name(), SortingHelper.InscriptionOptions.INSTABILITY.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.InscriptionOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.inscriptionSortingByAmount = builder.comment("The order of Inscriptions if they are sorted by the amount/size.").comment("Supported Values: NAME, INSTABILITY, TIME, COMPLETION, ROOMS").defineList("inscription_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.InscriptionOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.inscriptionSortingByMod = builder.comment("The order of Inscriptions if they are sorted by the mod.").comment("Supported Values: NAME, INSTABILITY, TIME, COMPLETION, ROOMS").defineList("inscription_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.InscriptionOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Vault Crystals are sorted");
        builder.push("Vault Crystal Sorting");
        this.vaultCrystalSortingByName = builder.comment("The order of Vault Crystal if they are sorted by the name.").comment("Supported Values: NAME, LEVEL, TYPE").defineList("crystal_sorting_by_name", Arrays.asList(SortingHelper.CrystalOptions.NAME.name(), SortingHelper.CrystalOptions.TYPE.name(), SortingHelper.CrystalOptions.LEVEL.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CrystalOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.vaultCrystalSortingByAmount = builder.comment("The order of Vault Crystal if they are sorted by the amount/size.").comment("Supported Values: NAME, LEVEL, TYPE").defineList("crystal_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CrystalOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.vaultCrystalSortingByMod = builder.comment("The order of Vault Crystal if they are sorted by the mod.").comment("Supported Values: NAME, LEVEL, TYPE").defineList("crystal_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CrystalOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Trinkets are sorted");
        builder.push("Trinkets Sorting");
        this.trinketSortingByName = builder.comment("The order of Trinkets if they are sorted by the name.").comment("Supported Values: NAME, SLOT, TYPE, USES").defineList("trinket_sorting_by_name", Arrays.asList(SortingHelper.TrinketOptions.NAME.name(), SortingHelper.TrinketOptions.SLOT.name(), SortingHelper.TrinketOptions.TYPE.name(), SortingHelper.TrinketOptions.USES.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.TrinketOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.trinketSortingByAmount = builder.comment("The order of Trinkets if they are sorted by the amount/size.").comment("Supported Values: NAME, SLOT, TYPE, USES").defineList("trinket_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.TrinketOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.trinketSortingByMod = builder.comment("The order of Trinkets if they are sorted by the mod.").comment("Supported Values: NAME, SLOT, TYPE, USES").defineList("trinket_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.TrinketOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Vault Dolls are sorted");
        builder.push("Vault Doll Sorting");
        this.dollSortingByName = builder.comment("The order of dolls if they are sorted by the name.").comment("Supported Values: NAME, OWNER, COMPLETED, XP, LOOT").defineList("vault_doll_sorting_by_name", Arrays.asList(SortingHelper.DollOptions.NAME.name(), SortingHelper.DollOptions.COMPLETED.name(), SortingHelper.DollOptions.OWNER.name(), SortingHelper.DollOptions.LOOT.name(), SortingHelper.DollOptions.XP.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.DollOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.dollSortingByAmount = builder.comment("The order of dolls if they are sorted by the amount/size.").comment("Supported Values: NAME, OWNER, COMPLETED, XP, LOOT").defineList("vault_doll_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.DollOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.dollSortingByMod = builder.comment("The order of dolls if they are sorted by the mod.").comment("Supported Values: NAME, OWNER, COMPLETED, XP, LOOT").defineList("vault_doll_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.DollOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Vault Charms are sorted");
        builder.push("Vault Charm Sorting");
        this.charmSortingByName = builder.comment("The order of charms if they are sorted by the name.").comment("Supported Values: NAME, USES, VALUE").defineList("charm_sorting_by_name", Arrays.asList(SortingHelper.CharmOptions.NAME.name(), SortingHelper.CharmOptions.USES.name(), SortingHelper.CharmOptions.VALUE.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CharmOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.charmSortingByAmount = builder.comment("The order of charms if they are sorted by the amount/size.").comment("Supported Values: NAME, USES, VALUE").defineList("charm_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CharmOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.charmSortingByMod = builder.comment("The order of charms if they are sorted by the mod.").comment("Supported Values: NAME, USES, VALUE").defineList("charm_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CharmOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Infused Catalysts are sorted");
        builder.push("Infused Catalysts Sorting");
        this.catalystSortingByName = builder.comment("The order of Infused Catalysts if they are sorted by the name.").comment("Supported Values: NAME, SIZE, MODIFIER").defineList("catalyst_sorting_by_name", Arrays.asList(SortingHelper.CatalystOptions.NAME.name(), SortingHelper.CatalystOptions.MODIFIER.name(), SortingHelper.CatalystOptions.SIZE.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CatalystOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.catalystSortingByAmount = builder.comment("The order of Infused Catalysts if they are sorted by the amount/size.").comment("Supported Values: NAME, SIZE, MODIFIER").defineList("catalyst_sorting_by_amount", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CatalystOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.catalystSortingByMod = builder.comment("The order of Infused Catalysts if they are sorted by the mod.").comment("Supported Values: NAME, SIZE, MODIFIER").defineList("catalyst_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CatalystOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        builder.comment("This category holds options how Cards are sorted");
        builder.push("Cards Sorting");
        this.cardSortingByName = builder.comment("The order of Cards if they are sorted by the name.").comment("Supported Values: NAME, TIER, TYPE, COLOR, GROUPS, MODEL").defineList("card_sorting_by_name", Arrays.asList(SortingHelper.CardOptions.TYPE.name(), SortingHelper.CardOptions.COLOR.name(), SortingHelper.CardOptions.TIER.name(), SortingHelper.CardOptions.NAME.name(), SortingHelper.CardOptions.GROUPS.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CardOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.cardSortingByAmount = builder.comment("The order of Cards if they are sorted by the amount/size.").comment("Supported Values: NAME, TIER, TYPE, COLOR, GROUPS, MODEL").defineList("card_sorting_by_amount", Arrays.asList(SortingHelper.CardOptions.TYPE.name(), SortingHelper.CardOptions.COLOR.name(), SortingHelper.CardOptions.TIER.name(), SortingHelper.CardOptions.NAME.name(), SortingHelper.CardOptions.GROUPS.name()), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CardOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        this.cardSortingByMod = builder.comment("The order of Cards if they are sorted by the mod.").comment("Supported Values: NAME, TIER, TYPE, COLOR, GROUPS, MODEL").defineList("card_sorting_by_mod", Collections.emptyList(), entry -> {
            String value;
            return entry instanceof String && Enums.getIfPresent(SortingHelper.CardOptions.class, (String)(value = (String)entry).toUpperCase()).isPresent();
        });
        builder.pop();
        GENERAL_SPEC = builder.build();
    }

    public List<SortingHelper.JewelOptions> getJewelSortingByName() {
        return this.convertStringToJewelEnum((List)this.jewelSortingByName.get());
    }

    public List<SortingHelper.JewelOptions> getJewelSortingByAmount() {
        return this.convertStringToJewelEnum((List)this.jewelSortingByAmount.get());
    }

    public List<SortingHelper.JewelOptions> getJewelSortingByMod() {
        return this.convertStringToJewelEnum((List)this.jewelSortingByMod.get());
    }

    public List<SortingHelper.GearOptions> getGearSortingByName() {
        return this.convertStringToGearEnum((List)this.gearSortingByName.get());
    }

    public List<SortingHelper.GearOptions> getGearSortingByAmount() {
        return this.convertStringToGearEnum((List)this.gearSortingByAmount.get());
    }

    public List<SortingHelper.GearOptions> getGearSortingByMod() {
        return this.convertStringToGearEnum((List)this.gearSortingByMod.get());
    }

    public List<? extends String> getRarityOrder() {
        return (List)this.rarityOrder.get();
    }

    public List<SortingHelper.InscriptionOptions> getInscriptionSortingByName() {
        return this.convertStringToInscriptionEnum((List)this.inscriptionSortingByName.get());
    }

    public List<SortingHelper.InscriptionOptions> getInscriptionSortingByAmount() {
        return this.convertStringToInscriptionEnum((List)this.inscriptionSortingByAmount.get());
    }

    public List<SortingHelper.InscriptionOptions> getInscriptionSortingByMod() {
        return this.convertStringToInscriptionEnum((List)this.inscriptionSortingByMod.get());
    }

    public List<SortingHelper.CrystalOptions> getVaultCrystalSortingByName() {
        return this.convertStringToCrystalEnum((List)this.vaultCrystalSortingByName.get());
    }

    public List<SortingHelper.CrystalOptions> getVaultCrystalSortingByAmount() {
        return this.convertStringToCrystalEnum((List)this.vaultCrystalSortingByAmount.get());
    }

    public List<SortingHelper.CrystalOptions> getVaultCrystalSortingByMod() {
        return this.convertStringToCrystalEnum((List)this.vaultCrystalSortingByMod.get());
    }

    public List<SortingHelper.TrinketOptions> getTrinketSortingByName() {
        return this.convertStringToTrinketEnum((List)this.trinketSortingByName.get());
    }

    public List<SortingHelper.TrinketOptions> getTrinketSortingByAmount() {
        return this.convertStringToTrinketEnum((List)this.trinketSortingByAmount.get());
    }

    public List<SortingHelper.TrinketOptions> getTrinketSortingByMod() {
        return this.convertStringToTrinketEnum((List)this.trinketSortingByMod.get());
    }

    public List<SortingHelper.DollOptions> getDollSortingByName() {
        return this.convertStringToDollEnum((List)this.dollSortingByName.get());
    }

    public List<SortingHelper.DollOptions> getDollSortingByAmount() {
        return this.convertStringToDollEnum((List)this.dollSortingByAmount.get());
    }

    public List<SortingHelper.DollOptions> getDollSortingByMod() {
        return this.convertStringToDollEnum((List)this.dollSortingByMod.get());
    }

    public List<SortingHelper.CharmOptions> getCharmSortingByName() {
        return this.convertStringToCharmEnum((List)this.charmSortingByName.get());
    }

    public List<SortingHelper.CharmOptions> getCharmSortingByAmount() {
        return this.convertStringToCharmEnum((List)this.charmSortingByAmount.get());
    }

    public List<SortingHelper.CharmOptions> getCharmSortingByMod() {
        return this.convertStringToCharmEnum((List)this.charmSortingByMod.get());
    }

    public List<SortingHelper.CatalystOptions> getCatalystSortingByName() {
        return this.convertStringToCatalystEnum((List)this.catalystSortingByName.get());
    }

    public List<SortingHelper.CatalystOptions> getCatalystSortingByAmount() {
        return this.convertStringToCatalystEnum((List)this.catalystSortingByAmount.get());
    }

    public List<SortingHelper.CatalystOptions> getCatalystSortingByMod() {
        return this.convertStringToCatalystEnum((List)this.catalystSortingByMod.get());
    }

    public List<SortingHelper.CardOptions> getCardSortingByName() {
        return this.convertStringToCardEnum((List)this.cardSortingByName.get());
    }

    public List<SortingHelper.CardOptions> getCardSortingByAmount() {
        return this.convertStringToCardEnum((List)this.cardSortingByAmount.get());
    }

    public List<SortingHelper.CardOptions> getCardSortingByMod() {
        return this.convertStringToCardEnum((List)this.cardSortingByMod.get());
    }

    private List<SortingHelper.JewelOptions> convertStringToJewelEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.JewelOptions.class, (String)upperCase).isPresent()).map(SortingHelper.JewelOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.GearOptions> convertStringToGearEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.GearOptions.class, (String)upperCase).isPresent()).map(SortingHelper.GearOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.InscriptionOptions> convertStringToInscriptionEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.InscriptionOptions.class, (String)upperCase).isPresent()).map(SortingHelper.InscriptionOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.CrystalOptions> convertStringToCrystalEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.CrystalOptions.class, (String)upperCase).isPresent()).map(SortingHelper.CrystalOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.TrinketOptions> convertStringToTrinketEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.TrinketOptions.class, (String)upperCase).isPresent()).map(SortingHelper.TrinketOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.DollOptions> convertStringToDollEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.DollOptions.class, (String)upperCase).isPresent()).map(SortingHelper.DollOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.CharmOptions> convertStringToCharmEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.CharmOptions.class, (String)upperCase).isPresent()).map(SortingHelper.CharmOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.CatalystOptions> convertStringToCatalystEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.CatalystOptions.class, (String)upperCase).isPresent()).map(SortingHelper.CatalystOptions::valueOf).distinct().toList();
    }

    private List<SortingHelper.CardOptions> convertStringToCardEnum(List<? extends String> value) {
        return value.stream().map(String::toUpperCase).filter(upperCase -> Enums.getIfPresent(SortingHelper.CardOptions.class, (String)upperCase).isPresent()).map(SortingHelper.CardOptions::valueOf).distinct().toList();
    }
}

