/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.qio.mixin;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import java.util.Comparator;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.IExtraGearDataCache;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import mekanism.common.inventory.ISlotClickHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={QIOItemViewerContainer.ListSortType.class}, remap=false)
public class MixinQIOItemViewerContainerListSortType {
    @Shadow
    @Final
    private Comparator<ISlotClickHandler.IScrollableSlot> ascendingComparator;
    @Shadow
    @Final
    private Comparator<ISlotClickHandler.IScrollableSlot> descendingComparator;

    @Redirect(method={"sort"}, at=@At(value="FIELD", target="Lmekanism/common/inventory/container/QIOItemViewerContainer$ListSortType;ascendingComparator:Ljava/util/Comparator;", opcode=180))
    private Comparator<ISlotClickHandler.IScrollableSlot> redirectAscending(QIOItemViewerContainer.ListSortType instance) {
        return this.ascendingComparator.thenComparing((stack1, stack2) -> {
            if (Screen.m_96638_()) {
                return 0;
            }
            ItemStack firstItem = stack1.getItem().getStack();
            ItemStack secondItem = stack2.getItem().getStack();
            if (!stack1.getModID().equals(stack2.getModID())) {
                return String.CASE_INSENSITIVE_ORDER.compare(stack1.getModID(), stack2.getModID());
            }
            int registryOrder = SortingHelper.compareRegistryNames(firstItem.m_41720_().getRegistryName(), secondItem.m_41720_().getRegistryName(), true);
            if (registryOrder != 0 || !SortingHelper.isSortable(firstItem.m_41720_().getRegistryName())) {
                return registryOrder;
            }
            return MixinQIOItemViewerContainerListSortType.compareItems(firstItem, secondItem, instance, true);
        });
    }

    @Redirect(method={"sort"}, at=@At(value="FIELD", target="Lmekanism/common/inventory/container/QIOItemViewerContainer$ListSortType;descendingComparator:Ljava/util/Comparator;", opcode=180))
    private Comparator<ISlotClickHandler.IScrollableSlot> redirectDescending(QIOItemViewerContainer.ListSortType instance) {
        return this.descendingComparator.thenComparing((stack1, stack2) -> {
            if (Screen.m_96638_()) {
                return 0;
            }
            ItemStack firstItem = stack1.getItem().getStack();
            ItemStack secondItem = stack2.getItem().getStack();
            if (!stack1.getModID().equals(stack2.getModID())) {
                return String.CASE_INSENSITIVE_ORDER.compare(stack2.getModID(), stack1.getModID());
            }
            int registryOrder = SortingHelper.compareRegistryNames(firstItem.m_41720_().getRegistryName(), secondItem.m_41720_().getRegistryName(), false);
            if (registryOrder != 0 || !SortingHelper.isSortable(firstItem.m_41720_().getRegistryName())) {
                return registryOrder;
            }
            return MixinQIOItemViewerContainerListSortType.compareItems(firstItem, secondItem, instance, false);
        });
    }

    @Unique
    private static int compareItems(ItemStack firstItem, ItemStack secondItem, QIOItemViewerContainer.ListSortType instance, boolean ascending) {
        if (firstItem.m_41720_() == ModItems.JEWEL) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            GearDataCache leftData = GearDataCache.of((ItemStack)firstItem);
            GearDataCache rightData = GearDataCache.of((ItemStack)secondItem);
            if (((IExtraGearDataCache)leftData).isInvalidCache()) {
                GearDataCache.removeCache((ItemStack)firstItem);
                GearDataCache.createCache((ItemStack)firstItem);
                leftData = GearDataCache.of((ItemStack)firstItem);
            }
            if (((IExtraGearDataCache)rightData).isInvalidCache()) {
                GearDataCache.removeCache((ItemStack)secondItem);
                GearDataCache.createCache((ItemStack)secondItem);
                rightData = GearDataCache.of((ItemStack)secondItem);
            }
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareJewels(leftName, leftData, firstItem.m_41784_().m_128451_("freeCuts"), rightName, rightData, secondItem.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareJewels(leftName, leftData, firstItem.m_41784_().m_128451_("freeCuts"), rightName, rightData, secondItem.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareJewels(leftName, leftData, firstItem.m_41784_().m_128451_("freeCuts"), rightName, rightData, secondItem.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.TOOL) {
            return 0;
        }
        if (SortingHelper.VAULT_GEAR_SET.contains(firstItem.m_41720_().getRegistryName())) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            VaultGearData leftData = VaultGearData.read((ItemStack)firstItem);
            VaultGearData rightData = VaultGearData.read((ItemStack)secondItem);
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.INSCRIPTION) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            InscriptionData leftData = InscriptionData.from((ItemStack)firstItem);
            InscriptionData rightData = InscriptionData.from((ItemStack)secondItem);
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.VAULT_CRYSTAL) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            CrystalData leftData = CrystalData.read((ItemStack)firstItem);
            CrystalData rightData = CrystalData.read((ItemStack)secondItem);
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.TRINKET) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            AttributeGearData leftData = AttributeGearData.read((ItemStack)firstItem);
            AttributeGearData rightData = AttributeGearData.read((ItemStack)secondItem);
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareTrinkets(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareTrinkets(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareTrinkets(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByMod(), ascending);
            };
        }
        if (SortingHelper.VAULT_CHARMS.contains(firstItem.m_41720_().getRegistryName())) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            AttributeGearData leftData = AttributeGearData.read((ItemStack)firstItem);
            AttributeGearData rightData = AttributeGearData.read((ItemStack)secondItem);
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareCharms(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareCharms(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareCharms(leftName, leftData, firstItem.m_41783_(), rightName, rightData, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.VAULT_CATALYST_INFUSED) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareCatalysts(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareCatalysts(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareCatalysts(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.VAULT_DOLL) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareVaultDolls(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareVaultDolls(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareVaultDolls(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.RELIC_FRAGMENT) {
            return SortingHelper.compareRelicFragments(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.RESPEC_FLASK) {
            return SortingHelper.compareRespecFlasks(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.FACETED_FOCUS) {
            return SortingHelper.compareFacedFocus(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.AUGMENT) {
            return SortingHelper.compareAugments(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.CARD) {
            String leftName = firstItem.m_41611_().getString();
            String rightName = secondItem.m_41611_().getString();
            return switch (instance) {
                default -> throw new IncompatibleClassChangeError();
                case QIOItemViewerContainer.ListSortType.NAME -> SortingHelper.compareCards(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByName(), ascending);
                case QIOItemViewerContainer.ListSortType.SIZE -> SortingHelper.compareCards(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByAmount(), ascending);
                case QIOItemViewerContainer.ListSortType.MOD -> SortingHelper.compareCards(leftName, firstItem.m_41783_(), rightName, secondItem.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByMod(), ascending);
            };
        }
        if (firstItem.m_41720_() == ModItems.CARD_DECK) {
            return SortingHelper.compareDecks(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.BOOSTER_PACK) {
            return SortingHelper.compareBoosterPacks(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.ANTIQUE) {
            return SortingHelper.compareAntique(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.JEWEL_POUCH) {
            return SortingHelper.comparePouches(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.COMPANION_RELIC) {
            return SortingHelper.compareCompanionRelics(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.COMPANION_PARTICLE_TRAIL) {
            return SortingHelper.compareCompanionParticleTrails(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        if (firstItem.m_41720_() == ModItems.TEMPORAL_SHARD) {
            return SortingHelper.compareTemporalShards(firstItem.m_41783_(), secondItem.m_41783_(), ascending);
        }
        return 0;
    }
}

