/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.quark.mixin;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.quark.base.handler.SortingHandler;

@Mixin(value={SortingHandler.class})
public class MixinSortingHandler {
    @Inject(method={"stackCompare(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void stackCompare(ItemStack stack1, ItemStack stack2, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        if (stack1 == stack2 || !stack1.m_41720_().equals(stack2.m_41720_()) || !SortingHelper.isSortable(stack1.m_41720_().getRegistryName())) {
            return;
        }
        if (stack1.m_41720_() == ModItems.JEWEL) {
            if (!VaultJewelSorting.CONFIGURATION.getJewelSortingByName().isEmpty()) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareJewels(stack1.m_41611_().getString(), VaultGearData.read((ItemStack)stack1), stack1.m_41784_().m_128451_("freeCuts"), stack2.m_41611_().getString(), VaultGearData.read((ItemStack)stack2), stack2.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), true));
                callbackInfoReturnable.cancel();
            }
        } else if (stack1.m_41720_() != ModItems.TOOL) {
            if (SortingHelper.VAULT_GEAR_SET.contains(stack1.m_41720_().getRegistryName())) {
                if (!VaultJewelSorting.CONFIGURATION.getGearSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultGear(stack1.m_41611_().getString(), VaultGearData.read((ItemStack)stack1), stack2.m_41611_().getString(), VaultGearData.read((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getGearSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.INSCRIPTION) {
                if (!VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareInscriptions(stack1.m_41611_().getString(), InscriptionData.from((ItemStack)stack1), stack2.m_41611_().getString(), InscriptionData.from((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.VAULT_CATALYST_INFUSED) {
                if (!VaultJewelSorting.CONFIGURATION.getCatalystSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCatalysts(stack1.m_41611_().getString(), stack1.m_41783_(), stack2.m_41611_().getString(), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.VAULT_CRYSTAL) {
                if (!VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultCrystals(stack1.m_41611_().getString(), CrystalData.read((ItemStack)stack1), stack2.m_41611_().getString(), CrystalData.read((ItemStack)stack2), VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.TRINKET) {
                if (!VaultJewelSorting.CONFIGURATION.getTrinketSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareTrinkets(stack1.m_41611_().getString(), AttributeGearData.read((ItemStack)stack1), stack1.m_41783_(), stack2.m_41611_().getString(), AttributeGearData.read((ItemStack)stack2), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (SortingHelper.VAULT_CHARMS.contains(stack1.m_41720_().getRegistryName())) {
                if (!VaultJewelSorting.CONFIGURATION.getCharmSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCharms(stack1.m_41611_().getString(), AttributeGearData.read((ItemStack)stack1), stack1.m_41783_(), stack2.m_41611_().getString(), AttributeGearData.read((ItemStack)stack2), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.VAULT_DOLL) {
                if (!VaultJewelSorting.CONFIGURATION.getDollSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultDolls(stack1.m_41611_().getString(), stack1.m_41783_(), stack2.m_41611_().getString(), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), true));
                    callbackInfoReturnable.cancel();
                }
            } else if (stack1.m_41720_() == ModItems.RELIC_FRAGMENT) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareRelicFragments(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.RESPEC_FLASK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareRespecFlasks(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.FACETED_FOCUS) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareFacedFocus(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.AUGMENT) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareAugments(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.BOOSTER_PACK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareBoosterPacks(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.CARD_DECK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareDecks(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.CARD) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCards(stack1.m_41611_().getString(), stack1.m_41783_(), stack2.m_41611_().getString(), stack2.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByName(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.ANTIQUE) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareAntique(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.JEWEL_POUCH) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.comparePouches(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.COMPANION_RELIC) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCompanionRelics(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.COMPANION_PARTICLE_TRAIL) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCompanionParticleTrails(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            } else if (stack1.m_41720_() == ModItems.TEMPORAL_SHARD) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareTemporalShards(stack1.m_41783_(), stack2.m_41783_(), true));
                callbackInfoReturnable.cancel();
            }
        }
    }
}

