/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.storagenetwork.mixin;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import java.util.Comparator;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={NetworkWidget.class}, remap=false)
public class MixinNetworkWidget {
    @Shadow
    @Final
    private IGuiNetwork gui;

    @ModifyArg(method={"sortStackWrappers"}, at=@At(value="INVOKE", target="Ljava/util/Collections;sort(Ljava/util/List;Ljava/util/Comparator;)V"), index=1)
    private Comparator<ItemStack> sortStackWrappersJewelCompare(Comparator<ItemStack> original) {
        return original.thenComparing((first, second) -> {
            if (Screen.m_96638_()) {
                return 0;
            }
            int registryOrder = SortingHelper.compareRegistryNames(first.m_41720_().getRegistryName(), second.m_41720_().getRegistryName(), this.gui.getDownwards());
            if (registryOrder != 0 || !SortingHelper.isSortable(first.m_41720_().getRegistryName())) {
                return registryOrder;
            }
            if (first.m_41720_() == ModItems.JEWEL) {
                String leftName = first.m_41611_().getString();
                String rightName = second.m_41611_().getString();
                VaultGearData leftData = VaultGearData.read((ItemStack)first);
                VaultGearData rightData = VaultGearData.read((ItemStack)second);
                return switch (this.gui.getSort()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EnumSortType.NAME -> SortingHelper.compareJewels(leftName, leftData, first.m_41784_().m_128451_("freeCuts"), rightName, rightData, second.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), this.gui.getDownwards());
                    case EnumSortType.AMOUNT -> SortingHelper.compareJewels(leftName, leftData, first.m_41784_().m_128451_("freeCuts"), rightName, rightData, second.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByAmount(), this.gui.getDownwards());
                    case EnumSortType.MOD -> SortingHelper.compareJewels(leftName, leftData, first.m_41784_().m_128451_("freeCuts"), rightName, rightData, second.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByMod(), this.gui.getDownwards());
                };
            }
            if (first.m_41720_() != ModItems.TOOL) {
                if (SortingHelper.VAULT_GEAR_SET.contains(first.m_41720_().getRegistryName())) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    VaultGearData leftData = VaultGearData.read((ItemStack)first);
                    VaultGearData rightData = VaultGearData.read((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByName(), this.gui.getDownwards());
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByAmount(), this.gui.getDownwards());
                        case EnumSortType.MOD -> SortingHelper.compareVaultGear(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getGearSortingByMod(), this.gui.getDownwards());
                    };
                }
                if (first.m_41720_() == ModItems.INSCRIPTION) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    InscriptionData leftData = InscriptionData.from((ItemStack)first);
                    InscriptionData rightData = InscriptionData.from((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareInscriptions(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getInscriptionSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.VAULT_CRYSTAL) {
                    String leftName = first.m_41611_().getString();
                    String rightName = second.m_41611_().getString();
                    CrystalData leftData = CrystalData.read((ItemStack)first);
                    CrystalData rightData = CrystalData.read((ItemStack)second);
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareVaultCrystals(leftName, leftData, rightName, rightData, VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.TRINKET) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareTrinkets(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByMod(), true);
                    };
                }
                if (SortingHelper.VAULT_CHARMS.contains(first.m_41720_().getRegistryName())) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareCharms(first.m_41611_().getString(), AttributeGearData.read((ItemStack)first), first.m_41783_(), second.m_41611_().getString(), AttributeGearData.read((ItemStack)second), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.VAULT_CATALYST_INFUSED) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareCatalysts(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareCatalysts(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareCatalysts(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.VAULT_DOLL) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareVaultDolls(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.RELIC_FRAGMENT) {
                    return SortingHelper.compareRelicFragments(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.RESPEC_FLASK) {
                    return SortingHelper.compareRespecFlasks(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.FACETED_FOCUS) {
                    return SortingHelper.compareFacedFocus(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.AUGMENT) {
                    return SortingHelper.compareAugments(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.CARD) {
                    return switch (this.gui.getSort()) {
                        default -> throw new IncompatibleClassChangeError();
                        case EnumSortType.NAME -> SortingHelper.compareCards(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByName(), true);
                        case EnumSortType.AMOUNT -> SortingHelper.compareCards(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByAmount(), true);
                        case EnumSortType.MOD -> SortingHelper.compareCards(first.m_41611_().getString(), first.m_41783_(), second.m_41611_().getString(), second.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByMod(), true);
                    };
                }
                if (first.m_41720_() == ModItems.CARD_DECK) {
                    return SortingHelper.compareDecks(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.BOOSTER_PACK) {
                    return SortingHelper.compareBoosterPacks(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.ANTIQUE) {
                    return SortingHelper.compareAntique(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.JEWEL_POUCH) {
                    return SortingHelper.comparePouches(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.COMPANION_RELIC) {
                    return SortingHelper.compareCompanionRelics(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.COMPANION_PARTICLE_TRAIL) {
                    return SortingHelper.compareCompanionParticleTrails(first.m_41783_(), second.m_41783_(), true);
                }
                if (first.m_41720_() == ModItems.TEMPORAL_SHARD) {
                    return SortingHelper.compareTemporalShards(first.m_41783_(), second.m_41783_(), true);
                }
            }
            return 0;
        });
    }
}

