/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.tomsstorage.mixin;

import com.tom.storagemod.StoredItemStack;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.data.InscriptionData;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.IExtraGearDataCache;
import lv.id.bonne.vaulthunters.jewelsorting.utils.SortingHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StoredItemStack.ComparatorName.class}, remap=false)
public class MixinStoredItemStackComparatorName {
    @Shadow
    public boolean reversed;

    @Inject(method={"compare(Lcom/tom/storagemod/StoredItemStack;Lcom/tom/storagemod/StoredItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void sortStackWrappersJewelCompare(StoredItemStack left, StoredItemStack right, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        if (Screen.m_96638_() || (Integer)callbackInfoReturnable.getReturnValue() != 0) {
            return;
        }
        ItemStack leftStack = left.getStack();
        ItemStack rightStack = right.getStack();
        int registryOrder = SortingHelper.compareRegistryNames(leftStack.m_41720_().getRegistryName(), rightStack.m_41720_().getRegistryName(), !this.reversed);
        if (registryOrder != 0 || !SortingHelper.isSortable(leftStack.m_41720_().getRegistryName())) {
            callbackInfoReturnable.setReturnValue((Object)registryOrder);
        } else if (leftStack.m_41720_() == ModItems.JEWEL) {
            if (!VaultJewelSorting.CONFIGURATION.getJewelSortingByName().isEmpty()) {
                GearDataCache leftData = GearDataCache.of((ItemStack)leftStack);
                GearDataCache rightData = GearDataCache.of((ItemStack)rightStack);
                if (((IExtraGearDataCache)leftData).isInvalidCache()) {
                    GearDataCache.removeCache((ItemStack)leftStack);
                    GearDataCache.createCache((ItemStack)leftStack);
                }
                if (((IExtraGearDataCache)rightData).isInvalidCache()) {
                    GearDataCache.removeCache((ItemStack)rightStack);
                    GearDataCache.createCache((ItemStack)rightStack);
                }
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareJewels(left.getDisplayName(), GearDataCache.of((ItemStack)leftStack), leftStack.m_41784_().m_128451_("freeCuts"), right.getDisplayName(), GearDataCache.of((ItemStack)rightStack), rightStack.m_41784_().m_128451_("freeCuts"), VaultJewelSorting.CONFIGURATION.getJewelSortingByName(), !this.reversed));
            }
        } else if (leftStack.m_41720_() != ModItems.TOOL) {
            if (SortingHelper.VAULT_GEAR_SET.contains(leftStack.m_41720_().getRegistryName())) {
                if (!VaultJewelSorting.CONFIGURATION.getGearSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultGear(left.getDisplayName(), VaultGearData.read((ItemStack)leftStack), right.getDisplayName(), VaultGearData.read((ItemStack)rightStack), VaultJewelSorting.CONFIGURATION.getGearSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.INSCRIPTION) {
                if (!VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareInscriptions(left.getDisplayName(), InscriptionData.from((ItemStack)leftStack), right.getDisplayName(), InscriptionData.from((ItemStack)rightStack), VaultJewelSorting.CONFIGURATION.getInscriptionSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.VAULT_CRYSTAL) {
                if (!VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultCrystals(leftStack.m_41611_().getString(), CrystalData.read((ItemStack)leftStack), rightStack.m_41611_().getString(), CrystalData.read((ItemStack)rightStack), VaultJewelSorting.CONFIGURATION.getVaultCrystalSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.TRINKET) {
                if (!VaultJewelSorting.CONFIGURATION.getTrinketSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareTrinkets(leftStack.m_41611_().getString(), AttributeGearData.read((ItemStack)leftStack), leftStack.m_41783_(), rightStack.m_41611_().getString(), AttributeGearData.read((ItemStack)rightStack), rightStack.m_41783_(), VaultJewelSorting.CONFIGURATION.getTrinketSortingByName(), !this.reversed));
                }
            } else if (SortingHelper.VAULT_CHARMS.contains(leftStack.m_41720_().getRegistryName())) {
                if (!VaultJewelSorting.CONFIGURATION.getCharmSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCharms(leftStack.m_41611_().getString(), AttributeGearData.read((ItemStack)leftStack), leftStack.m_41783_(), rightStack.m_41611_().getString(), AttributeGearData.read((ItemStack)rightStack), rightStack.m_41783_(), VaultJewelSorting.CONFIGURATION.getCharmSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.VAULT_CATALYST_INFUSED) {
                if (!VaultJewelSorting.CONFIGURATION.getCatalystSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCatalysts(leftStack.m_41611_().getString(), leftStack.m_41783_(), rightStack.m_41611_().getString(), rightStack.m_41783_(), VaultJewelSorting.CONFIGURATION.getCatalystSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.VAULT_DOLL) {
                if (!VaultJewelSorting.CONFIGURATION.getDollSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareVaultDolls(leftStack.m_41611_().getString(), leftStack.m_41783_(), rightStack.m_41611_().getString(), rightStack.m_41783_(), VaultJewelSorting.CONFIGURATION.getDollSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.RELIC_FRAGMENT) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareRelicFragments(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.RESPEC_FLASK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareRespecFlasks(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.FACETED_FOCUS) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareFacedFocus(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.AUGMENT) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareAugments(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.CARD) {
                if (!VaultJewelSorting.CONFIGURATION.getCardSortingByName().isEmpty()) {
                    callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareCards(leftStack.m_41611_().getString(), leftStack.m_41783_(), rightStack.m_41611_().getString(), rightStack.m_41783_(), VaultJewelSorting.CONFIGURATION.getCardSortingByName(), !this.reversed));
                }
            } else if (leftStack.m_41720_() == ModItems.CARD_DECK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareDecks(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.BOOSTER_PACK) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareBoosterPacks(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.ANTIQUE) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.compareAntique(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            } else if (leftStack.m_41720_() == ModItems.JEWEL_POUCH) {
                callbackInfoReturnable.setReturnValue((Object)SortingHelper.comparePouches(leftStack.m_41783_(), rightStack.m_41783_(), !this.reversed));
            }
        }
    }
}

