/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.utils;

import iskallia.vault.gear.attribute.VaultGearAttribute;
import java.util.ArrayList;
import java.util.List;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import net.minecraftforge.event.RegistryEvent;

public class AttributeHelper {
    private static final List<VaultGearAttribute<?>> MOD_GEAR_ATTRIBUTE = new ArrayList();

    public static void registerAttributes(RegistryEvent.Register<VaultGearAttribute<?>> event) {
        event.getRegistry().getValues().forEach(attribute -> {
            if (!MOD_GEAR_ATTRIBUTE.contains(attribute)) {
                MOD_GEAR_ATTRIBUTE.add((VaultGearAttribute<?>)attribute);
            }
        });
    }

    public static boolean isFloatAttribute(VaultGearAttribute<?> attribute) {
        try {
            return attribute != null && attribute.getType().cast((Object)0) instanceof Float;
        }
        catch (ClassCastException ignore) {
            return false;
        }
    }

    public static boolean isIntegerAttribute(VaultGearAttribute<?> attribute) {
        try {
            return attribute != null && attribute.getType().cast((Object)0) instanceof Integer && attribute.getType().cast((Object)0.0) instanceof Integer;
        }
        catch (ClassCastException ignore) {
            return false;
        }
    }

    public static boolean isDoubleAttribute(VaultGearAttribute<?> attribute) {
        try {
            return attribute != null && attribute.getType().cast((Object)0) instanceof Double;
        }
        catch (ClassCastException ignore) {
            return false;
        }
    }

    public static int getAttributeIndex(VaultGearAttribute<?> attribute) {
        return attribute == null ? -1 : MOD_GEAR_ATTRIBUTE.indexOf(attribute);
    }

    public static int getRollIndex(String name) {
        return VaultJewelSorting.CONFIGURATION.getRarityOrder().indexOf(name);
    }
}

