/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.jewelsorting.vaulthunters.mixin;

import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.JewelItem;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import lv.id.bonne.vaulthunters.jewelsorting.VaultJewelSorting;
import lv.id.bonne.vaulthunters.jewelsorting.utils.AttributeHelper;
import lv.id.bonne.vaulthunters.jewelsorting.utils.IExtraGearDataCache;
import lv.id.bonne.vaulthunters.jewelsorting.vaulthunters.mixin.InvokerGearDataCache;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GearDataCache.class}, remap=false)
public class MixinGearDataCache
implements IExtraGearDataCache {
    @Inject(method={"createCache"}, at={@At(value="INVOKE", target="Liskallia/vault/gear/data/GearDataCache;getJewelColorComponents()Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void extraCreateCache(ItemStack stack, CallbackInfo ci, GearDataCache cache) {
        if (stack.m_41720_() instanceof JewelItem) {
            MixinGearDataCache.populateJewelCache(cache, stack);
        }
    }

    private static void populateJewelCache(GearDataCache cache, ItemStack itemStack) {
        VaultGearData data = VaultGearData.read((ItemStack)itemStack);
        ArrayList affixes = new ArrayList();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        ((InvokerGearDataCache)cache).callQueryIntCache("extra_attribute_index", -1, stack -> {
            if (affixes.size() == 1) {
                return AttributeHelper.getAttributeIndex(((VaultGearModifier)affixes.get(0)).getAttribute());
            }
            return -1;
        });
        ((InvokerGearDataCache)cache).callQueryCache("extra_attribute_value", tag -> ((DoubleTag)tag).m_7061_(), DoubleTag::m_128500_, null, Function.identity(), stack -> {
            if (affixes.size() == 1) {
                VaultGearAttribute attribute = ((VaultGearModifier)affixes.get(0)).getAttribute();
                if (AttributeHelper.isDoubleAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.orElse(null);
                }
                if (AttributeHelper.isFloatAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.map(Double::valueOf).orElse(null);
                }
                if (AttributeHelper.isIntegerAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.map(Double::valueOf).orElse(null);
                }
                return null;
            }
            return null;
        });
        ((InvokerGearDataCache)cache).callQueryIntCache("extra_jewel_size", 0, stack -> {
            if (stack.m_41720_() instanceof JewelItem) {
                return data.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(null);
            }
            return null;
        });
        ((InvokerGearDataCache)cache).callQueryIntCache("extra_gear_level", 0, stack -> data.getItemLevel());
        ((InvokerGearDataCache)cache).callQueryCache("extra_cache_version", Tag::m_7916_, StringTag::m_129297_, null, Function.identity(), stack -> VaultJewelSorting.VAULT_MOD_VERSION);
    }

    @Override
    @Unique
    public Integer getExtraFirstAttributeIndex() {
        return ((InvokerGearDataCache)((Object)this)).callQueryIntCache("extra_attribute_index", -1, stack -> {
            VaultGearData data = VaultGearData.read((ItemStack)stack);
            ArrayList affixes = new ArrayList();
            affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
            affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
            if (affixes.size() == 1) {
                return AttributeHelper.getAttributeIndex(((VaultGearModifier)affixes.get(0)).getAttribute());
            }
            return -1;
        });
    }

    @Override
    @Unique
    public Double getExtraFirstAttributeValue() {
        return ((InvokerGearDataCache)((Object)this)).callQueryCache("extra_attribute_value", tag -> ((DoubleTag)tag).m_7061_(), DoubleTag::m_128500_, null, Function.identity(), stack -> {
            VaultGearData data = VaultGearData.read((ItemStack)stack);
            ArrayList affixes = new ArrayList();
            affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
            affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
            if (affixes.size() == 1) {
                VaultGearAttribute attribute = ((VaultGearModifier)affixes.get(0)).getAttribute();
                if (AttributeHelper.isDoubleAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.orElse(null);
                }
                if (AttributeHelper.isFloatAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.map(Double::valueOf).orElse(null);
                }
                if (AttributeHelper.isIntegerAttribute(attribute)) {
                    Optional value = data.getFirstValue(attribute);
                    return value.map(Double::valueOf).orElse(null);
                }
                return null;
            }
            return null;
        });
    }

    @Override
    @Unique
    public Integer getExtraJewelSize() {
        return ((InvokerGearDataCache)((Object)this)).callQueryIntCache("extra_jewel_size", 0, stack -> {
            if (stack.m_41720_() instanceof JewelItem) {
                VaultGearData data = VaultGearData.read((ItemStack)stack);
                return data.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(null);
            }
            return null;
        });
    }

    @Override
    @Unique
    public int getExtraGearLevel() {
        return ((InvokerGearDataCache)((Object)this)).callQueryIntCache("extra_gear_level", 0, stack -> {
            VaultGearData data = VaultGearData.read((ItemStack)stack);
            return data.getItemLevel();
        });
    }

    @Override
    @Unique
    public <T> T getCachedValue(String key, Function<Tag, T> nbtRead) {
        byte tagType = ((InvokerGearDataCache)((Object)this)).callCacheTag().m_128435_(key);
        if (tagType == 0) {
            return null;
        }
        return nbtRead.apply(((InvokerGearDataCache)((Object)this)).callCacheTag().m_128423_(key));
    }
}

