/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

public class Mode {
    private static final HashMap<String, Mode> MODES = new HashMap();
    public boolean aliasColumnName;
    public boolean convertInsertNullToZero;
    public boolean convertOnlyToSmallerScale;
    public boolean indexDefinitionInCreateTable;
    public boolean lowerCaseIdentifiers;
    public boolean nullConcatIsNull;
    public boolean squareBracketQuotedNames;
    public boolean systemColumns;
    public UniqueIndexNullsHandling uniqueIndexNullsHandling = UniqueIndexNullsHandling.ALLOW_DUPLICATES_WITH_ANY_NULL;
    public boolean treatEmptyStringsAsNull;
    public boolean sysDummy1;
    public boolean allowPlusForStringConcat;
    public boolean logIsLogBase10;
    public boolean regexpReplaceBackslashReferences;
    public boolean serialColumnIsNotPK;
    public boolean swapConvertFunctionParameters;
    public boolean isolationLevelInSelectOrInsertStatement;
    public boolean onDuplicateKeyUpdate;
    public Pattern supportedClientInfoPropertiesRegEx;
    public boolean supportPoundSymbolForColumnNames;
    public boolean prohibitEmptyInPredicate;
    public boolean allowAffinityKey;
    public boolean padFixedLengthStrings;
    public boolean allowDB2TimestampFormat;
    public boolean discardWithTableHints;
    public boolean useIdentityAsAutoIncrement;
    public boolean charToBinaryInUtf8;
    public boolean dateTimeValueWithinTransaction;
    public Set<String> disallowedTypes = Collections.emptySet();
    public HashMap<String, DataType> typeByNameMap = new HashMap();
    private final String name;
    private final ModeEnum modeEnum;

    private Mode(ModeEnum modeEnum) {
        this.name = modeEnum.name();
        this.modeEnum = modeEnum;
    }

    private static void add(Mode mode) {
        MODES.put(StringUtils.toUpperEnglish(mode.name), mode);
    }

    public static Mode getInstance(String string) {
        return MODES.get(StringUtils.toUpperEnglish(string));
    }

    public static Mode getRegular() {
        return Mode.getInstance(ModeEnum.REGULAR.name());
    }

    public String getName() {
        return this.name;
    }

    public ModeEnum getEnum() {
        return this.modeEnum;
    }

    public String toString() {
        return this.name;
    }

    static {
        Mode mode = new Mode(ModeEnum.REGULAR);
        mode.nullConcatIsNull = true;
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.DB2);
        mode.aliasColumnName = true;
        mode.sysDummy1 = true;
        mode.isolationLevelInSelectOrInsertStatement = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile("ApplicationName|ClientAccountingInformation|ClientUser|ClientCorrelationToken");
        mode.prohibitEmptyInPredicate = true;
        mode.allowDB2TimestampFormat = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Derby);
        mode.aliasColumnName = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.sysDummy1 = true;
        mode.isolationLevelInSelectOrInsertStatement = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        Mode.add(mode);
        mode = new Mode(ModeEnum.HSQLDB);
        mode.aliasColumnName = true;
        mode.convertOnlyToSmallerScale = true;
        mode.nullConcatIsNull = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.allowPlusForStringConcat = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        Mode.add(mode);
        mode = new Mode(ModeEnum.MSSQLServer);
        mode.aliasColumnName = true;
        mode.squareBracketQuotedNames = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.allowPlusForStringConcat = true;
        mode.swapConvertFunctionParameters = true;
        mode.supportPoundSymbolForColumnNames = true;
        mode.discardWithTableHints = true;
        mode.useIdentityAsAutoIncrement = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        DataType dataType = DataType.createNumeric(19, 4, false);
        dataType.type = 6;
        dataType.sqlType = 2;
        dataType.name = "MONEY";
        mode.typeByNameMap.put("MONEY", dataType);
        dataType = DataType.createNumeric(10, 4, false);
        dataType.type = 6;
        dataType.sqlType = 2;
        dataType.name = "SMALLMONEY";
        mode.typeByNameMap.put("SMALLMONEY", dataType);
        Mode.add(mode);
        mode = new Mode(ModeEnum.MySQL);
        mode.convertInsertNullToZero = true;
        mode.indexDefinitionInCreateTable = true;
        mode.lowerCaseIdentifiers = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.onDuplicateKeyUpdate = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile(".*");
        mode.prohibitEmptyInPredicate = true;
        mode.charToBinaryInUtf8 = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Oracle);
        mode.aliasColumnName = true;
        mode.convertOnlyToSmallerScale = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.ALLOW_DUPLICATES_WITH_ALL_NULLS;
        mode.treatEmptyStringsAsNull = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.supportPoundSymbolForColumnNames = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile(".*\\..*");
        mode.prohibitEmptyInPredicate = true;
        dataType = DataType.createDate(19, 19, "DATE", false, 0, 0);
        dataType.type = 11;
        dataType.sqlType = 93;
        dataType.name = "DATE";
        mode.typeByNameMap.put("DATE", dataType);
        Mode.add(mode);
        mode = new Mode(ModeEnum.PostgreSQL);
        mode.aliasColumnName = true;
        mode.nullConcatIsNull = true;
        mode.systemColumns = true;
        mode.logIsLogBase10 = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.serialColumnIsNotPK = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile("ApplicationName");
        mode.prohibitEmptyInPredicate = true;
        mode.padFixedLengthStrings = true;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("NUMBER");
        hashSet.add("IDENTITY");
        hashSet.add("TINYINT");
        hashSet.add("BLOB");
        mode.disallowedTypes = hashSet;
        dataType = DataType.createNumeric(19, 2, false);
        dataType.type = 6;
        dataType.sqlType = 2;
        dataType.name = "MONEY";
        mode.typeByNameMap.put("MONEY", dataType);
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Ignite);
        mode.nullConcatIsNull = true;
        mode.allowAffinityKey = true;
        mode.indexDefinitionInCreateTable = true;
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
    }

    public static enum UniqueIndexNullsHandling {
        ALLOW_DUPLICATES_WITH_ANY_NULL,
        ALLOW_DUPLICATES_WITH_ALL_NULLS,
        FORBID_ANY_DUPLICATES;

    }

    public static enum ModeEnum {
        REGULAR,
        DB2,
        Derby,
        MSSQLServer,
        HSQLDB,
        MySQL,
        Oracle,
        PostgreSQL,
        Ignite;

    }
}

