/*
 * Decompiled with CFR 0.152.
 */
package ca.edtoaster.littlecontraptions.setup;

import ca.edtoaster.littlecontraptions.setup.LCBlockEntityTypes;
import ca.edtoaster.littlecontraptions.setup.LCBlocks;
import ca.edtoaster.littlecontraptions.setup.LCEntityTypes;
import ca.edtoaster.littlecontraptions.setup.LCItems;
import ca.edtoaster.littlecontraptions.setup.LCPonder;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    private CreativeModeTab currentTab = CreativeModeTab.f_40753_;
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<EntityType<?>> ENTITIES = Registration.create(ForgeRegistries.ENTITIES);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = Registration.create(ForgeRegistries.BLOCK_ENTITIES);

    public <T extends Item> ItemBuilder<T> item(String id, ItemBuilder.ItemConstructor<T> constructor) {
        return new ItemBuilder<T>(id, constructor);
    }

    public <T extends Block> BlockBuilder<T> block(String id, BlockBuilder.BlockConstructor<T> constructor) {
        return new BlockBuilder<T>(id, constructor);
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"littlecontraptions");
    }

    public static void register() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILE_ENTITIES.register(eventBus);
        ENTITIES.register(eventBus);
        LCItems.register();
        LCBlocks.register();
        LCBlockEntityTypes.register();
        LCEntityTypes.register();
        OneTimeEventReceiver.addListener((IEventBus)eventBus, FMLClientSetupEvent.class, event -> event.enqueueWork(LCPonder::register));
    }

    public void setCurrentTab(CreativeModeTab currentTab) {
        this.currentTab = currentTab;
    }

    public class ItemBuilder<T extends Item> {
        private Item.Properties properties;
        private final String id;
        private final ItemConstructor<T> constructor;

        public ItemBuilder<T> transformProperties(Function<Item.Properties, Item.Properties> propFunc) {
            this.properties = propFunc.apply(this.properties);
            return this;
        }

        public RegistryObject<Item> register() {
            return ITEMS.register(this.id, () -> this.constructor.construct(this.properties));
        }

        public ItemBuilder(String id, ItemConstructor<T> constructor) {
            this.properties = new Item.Properties().m_41491_(Registration.this.currentTab);
            this.id = id;
            this.constructor = constructor;
        }

        public void setProperties(Item.Properties properties) {
            this.properties = properties;
        }

        @FunctionalInterface
        public static interface ItemConstructor<T extends Item> {
            public T construct(Item.Properties var1);
        }
    }

    public class BlockBuilder<T extends Block> {
        private BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_);
        private final String id;
        private final BlockConstructor<T> constructor;
        boolean createSimpleItem = false;

        public BlockBuilder<T> baseMaterial(Material mat) {
            this.properties = BlockBehaviour.Properties.m_60939_((Material)mat);
            return this;
        }

        public BlockBuilder<T> destroyTime(float time) {
            this.properties.m_155954_(time);
            return this;
        }

        public BlockBuilder<T> noCollision() {
            this.properties.m_60910_();
            return this;
        }

        public BlockBuilder<T> simpleItem() {
            this.createSimpleItem = true;
            return this;
        }

        public RegistryObject<T> register() {
            RegistryObject ret = BLOCKS.register(this.id, () -> this.constructor.construct(this.properties));
            if (this.createSimpleItem) {
                ITEMS.register(this.id, () -> new BlockItem((Block)ret.get(), new Item.Properties().m_41491_(Registration.this.currentTab)));
            }
            return ret;
        }

        public BlockBuilder(String id, BlockConstructor<T> constructor) {
            this.id = id;
            this.constructor = constructor;
        }

        public void setProperties(BlockBehaviour.Properties properties) {
            this.properties = properties;
        }

        @FunctionalInterface
        public static interface BlockConstructor<T extends Block> {
            public T construct(BlockBehaviour.Properties var1);
        }
    }
}

