/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dmillerw.ping.client.PingRenderType;
import dmillerw.ping.client.util.GLUUtils;
import dmillerw.ping.client.util.PingRenderHelper;
import dmillerw.ping.client.util.VertexHelper;
import dmillerw.ping.data.PingType;
import dmillerw.ping.data.PingWrapper;
import dmillerw.ping.network.packet.ServerBroadcastPing;
import dmillerw.ping.util.Config;
import dmillerw.ping.util.PingSounds;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="ping", value={Dist.CLIENT})
public class PingHandler {
    public static final PingHandler INSTANCE = new PingHandler();
    public static final ResourceLocation TEXTURE = new ResourceLocation("ping", "textures/ping.png");
    private static final List<PingWrapper> ACTIVE_PINGS = new ArrayList<PingWrapper>();

    public void onPingPacket(ServerBroadcastPing packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (double)Mth.m_14116_((float)((float)mc.f_91074_.m_20275_((double)packet.ping.pos.m_123341_(), (double)packet.ping.pos.m_123342_(), (double)packet.ping.pos.m_123343_()))) <= (Double)Config.GENERAL.pingAcceptDistance.get()) {
            if (((Boolean)Config.GENERAL.sound.get()).booleanValue()) {
                mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(PingSounds.BLOOP, SoundSource.PLAYERS, 0.25f, 1.0f, (double)packet.ping.pos.m_123341_(), (double)packet.ping.pos.m_123342_(), (double)packet.ping.pos.m_123343_()));
            }
            packet.ping.timer = (Integer)Config.GENERAL.pingDuration.get();
            ACTIVE_PINGS.add(packet.ping);
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelLastEvent event) {
        if (ACTIVE_PINGS.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.m_167982_().f_112249_;
        Vec3 cameraPos = camera.m_90583_();
        Frustum clippingHelper = new Frustum(event.getPoseStack().m_85850_().m_85861_(), event.getProjectionMatrix());
        clippingHelper.m_113002_(cameraPos.m_7096_(), cameraPos.m_7098_(), cameraPos.m_7094_());
        for (PingWrapper ping : ACTIVE_PINGS) {
            double px = (double)ping.pos.m_123341_() + 0.5 - cameraPos.m_7096_();
            double py = (double)ping.pos.m_123342_() + 0.5 - cameraPos.m_7098_();
            double pz = (double)ping.pos.m_123343_() + 0.5 - cameraPos.m_7094_();
            if (clippingHelper.m_113029_(ping.getAABB())) {
                ping.isOffscreen = false;
                if (((Boolean)Config.VISUAL.blockOverlay.get()).booleanValue()) {
                    PingHandler.renderPingOverlay((double)ping.pos.m_123341_() - cameraPos.m_7096_(), (double)ping.pos.m_123342_() - cameraPos.m_7098_(), (double)ping.pos.m_123343_() - cameraPos.m_7094_(), event.getPoseStack(), ping);
                }
                PingHandler.renderPing(px, py, pz, event.getPoseStack(), camera, ping);
                continue;
            }
            ping.isOffscreen = true;
            PingHandler.translatePingCoordinates(px, py, pz, ping);
        }
    }

    @SubscribeEvent
    public static void renderPingOffscreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.m_91087_();
            for (PingWrapper ping : ACTIVE_PINGS) {
                if (!ping.isOffscreen || mc.f_91080_ != null || mc.f_91066_.f_92063_) continue;
                int width = mc.m_91268_().m_85443_();
                int height = mc.m_91268_().m_85444_();
                int x1 = -(width / 2) + 32;
                int y1 = -(height / 2) + 32;
                int x2 = width / 2 - 32;
                int y2 = height / 2 - 32;
                double pingX = ping.screenX;
                double pingY = ping.screenY;
                double angle = Math.atan2(pingY -= (double)height * 0.5, pingX -= (double)width * 0.5);
                double cos = Math.cos(angle += Math.toRadians(90.0));
                double sin = Math.sin(angle);
                double m = cos / sin;
                if (cos > 0.0) {
                    pingX = (double)y2 / m;
                    pingY = y2;
                } else {
                    pingX = (double)y1 / m;
                    pingY = y1;
                }
                if (pingX > (double)x2) {
                    pingX = x2;
                    pingY = (double)x2 * m;
                } else if (pingX < (double)x1) {
                    pingX = x1;
                    pingY = (double)x1 * m;
                }
                PoseStack poseStack = new PoseStack();
                poseStack.m_85836_();
                PoseStack.Pose matrixEntry = poseStack.m_85850_();
                poseStack.m_85837_((pingX += (double)width * 0.5) / 2.0, (pingY += (double)height * 0.5) / 2.0, 0.0);
                RenderSystem.m_157182_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder vertexBuilder = tesselator.m_85915_();
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                Matrix4f matrix4f = matrixEntry.m_85861_();
                vertexBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                float min = -8.0f;
                float max = 8.0f;
                int r = ping.color >> 16 & 0xFF;
                int g = ping.color >> 8 & 0xFF;
                int b = ping.color & 0xFF;
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, min, max, PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMaxV(), r, g, b, 255);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, max, max, PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMaxV(), r, g, b, 255);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, max, min, PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMinV(), r, g, b, 255);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, min, min, PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMinV(), r, g, b, 255);
                float alpha = ping.type == PingType.ALERT ? (mc.f_91073_ != null ? (float)(1.0 + 0.01 * Math.sin(mc.f_91073_.m_46468_())) : 0.85f) : 0.85f;
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, min, max, ping.type.getMinU(), ping.type.getMaxV(), 1.0f, 1.0f, 1.0f, alpha);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, max, max, ping.type.getMaxU(), ping.type.getMaxV(), 1.0f, 1.0f, 1.0f, alpha);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, max, min, ping.type.getMaxU(), ping.type.getMinV(), 1.0f, 1.0f, 1.0f, alpha);
                VertexHelper.renderPosTexColorNoZ((VertexConsumer)vertexBuilder, matrix4f, min, min, ping.type.getMinU(), ping.type.getMinV(), 1.0f, 1.0f, 1.0f, alpha);
                tesselator.m_85914_();
                poseStack.m_85849_();
                RenderSystem.m_157182_();
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Iterator<PingWrapper> iterator = ACTIVE_PINGS.iterator();
        while (iterator.hasNext()) {
            PingWrapper pingWrapper = iterator.next();
            if (pingWrapper.animationTimer > 0) {
                pingWrapper.animationTimer -= 5;
            }
            --pingWrapper.timer;
            if (pingWrapper.timer > 0) continue;
            iterator.remove();
        }
    }

    private static void renderPing(double px, double py, double pz, PoseStack poseStack, Camera camera, PingWrapper ping) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_85837_(px, py, pz);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-camera.m_90590_()));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        PoseStack.Pose matrixEntry = poseStack.m_85850_();
        Matrix4f matrix4f = matrixEntry.m_85861_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        RenderType pingType = PingRenderType.getPingIcon(TEXTURE);
        VertexConsumer vertexBuilder = buffer.m_6299_(pingType);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        float min = -0.25f - 0.25f * (float)ping.animationTimer / 20.0f;
        float max = 0.25f + 0.25f * (float)ping.animationTimer / 20.0f;
        int r = ping.color >> 16 & 0xFF;
        int g = ping.color >> 8 & 0xFF;
        int b = ping.color & 0xFF;
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, min, max, PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMaxV(), r, g, b, 255);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, max, max, PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMaxV(), r, g, b, 255);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, max, min, PingType.BACKGROUND.getMaxU(), PingType.BACKGROUND.getMinV(), r, g, b, 255);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, min, min, PingType.BACKGROUND.getMinU(), PingType.BACKGROUND.getMinV(), r, g, b, 255);
        float alpha = ping.type == PingType.ALERT ? (mc.f_91073_ != null ? (float)(1.0 + 0.01 * Math.sin(mc.f_91073_.m_46468_())) : 0.85f) : 0.85f;
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, min, max, ping.type.getMinU(), ping.type.getMaxV(), 1.0f, 1.0f, 1.0f, alpha);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, max, max, ping.type.getMaxU(), ping.type.getMaxV(), 1.0f, 1.0f, 1.0f, alpha);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, max, min, ping.type.getMaxU(), ping.type.getMinV(), 1.0f, 1.0f, 1.0f, alpha);
        VertexHelper.renderPosTexColorNoZ(vertexBuilder, matrix4f, min, min, ping.type.getMinU(), ping.type.getMinV(), 1.0f, 1.0f, 1.0f, alpha);
        buffer.m_109912_(pingType);
        poseStack.m_85849_();
    }

    private static void renderPingOverlay(double x, double y, double z, PoseStack poseStack, PingWrapper ping) {
        TextureAtlasSprite icon = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(new ItemStack((ItemLike)Blocks.f_50147_)).m_6160_();
        float padding = 0.0f + 0.2f * (float)ping.animationTimer / 20.0f;
        float box = 1.0f + padding + padding;
        poseStack.m_85836_();
        poseStack.m_85837_(x + 0.5, y + 0.5, z + 0.5);
        PingRenderHelper.drawBlockOverlay(box, box, box, poseStack, icon, ping.color, 175);
        poseStack.m_85837_(0.0, 0.0, 0.0);
        poseStack.m_85849_();
    }

    private static void translatePingCoordinates(double px, double py, double pz, PingWrapper ping) {
        FloatBuffer screenCoords = BufferUtils.createFloatBuffer((int)4);
        IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer projection = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)modelView);
        GL11.glGetFloatv((int)2983, (FloatBuffer)projection);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        if (GLUUtils.gluProject((float)px, (float)py, (float)pz, modelView, projection, viewport, screenCoords)) {
            ping.screenX = screenCoords.get(0);
            ping.screenY = screenCoords.get(1);
        }
    }
}

