/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.ButtonFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ButtonBakedModel
implements IDynamicBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            boolean isPowered = (Boolean)state.m_61143_((Property)ButtonFrameBlock.f_51045_);
            float thickness = isPowered ? 0.0625f : 0.125f;
            float yl = 0.0f;
            float yh = thickness;
            if (((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)).equals((Object)AttachFace.CEILING)) {
                yl = 1.0f - thickness;
                yh = 1.0f;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            block0 : switch ((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)) {
                case WALL: {
                    switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 1.0f - thickness, 1.0f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, thickness, 0.375f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(1.0f - thickness, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, thickness, texture, tintIndex));
                        }
                    }
                    break;
                }
                case FLOOR: 
                case CEILING: {
                    switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                        case EAST: 
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, texture, tintIndex));
                            break block0;
                        }
                        case NORTH: 
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, texture, tintIndex));
                        }
                    }
                }
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                block14 : switch ((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)) {
                    case WALL: {
                        switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 1.0f - thickness, 1.0f, overlayIndex));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, thickness, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(1.0f - thickness, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, thickness, overlayIndex));
                            }
                        }
                        break;
                    }
                    case FLOOR: 
                    case CEILING: {
                        switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                            case EAST: 
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, overlayIndex));
                                break block14;
                            }
                            case NORTH: 
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, overlayIndex));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

