/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.DaylightDetectorFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.DaylightDetectorFrameTileEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class DaylightDetectorBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(DaylightDetectorFrameTileEntity.MIMIC);
        Integer design = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.DESIGN);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, DaylightDetectorFrameTileEntity.TEXTURE);
                TextureAtlasSprite sensor_side = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/daylight_detector_side"));
                TextureAtlasSprite glass = TextureHelper.getGlassTextures().get((Integer)extraData.getData(DaylightDetectorFrameTileEntity.GLASS_COLOR));
                TextureAtlasSprite sensor = (Boolean)state.m_61143_((Property)DaylightDetectorFrameBlock.f_52378_) != false ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/daylight_detector_inverted_top")) : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/daylight_detector_top"));
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                if (design == 0) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, true, true));
                } else if (design == 1) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.375f, 0.0625f, 0.9375f, -1, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                } else if (design == 2) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.0625f, 0.9375f, -1, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                } else if (design == 3) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.25f, 0.0625f, 0.9375f, -1, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.25f, 0.375f, 0.0625f, 0.9375f, glass, -1));
                } else if (design == 4) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.0625f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0625f, 0.375f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.0625f, 0.375f, 0.0f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.3125f, 0.0625f, 0.9375f, -1, sensor_side, sensor_side, sensor_side, sensor_side, sensor, sensor_side, 0));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.375f, 0.3125f, 0.375f, 0.0625f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.625f, 0.6875f, 0.3125f, 0.375f, 0.0625f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.375f, 0.3125f, 0.375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.375f, 0.625f, 0.6875f, texture, tintIndex));
                }
                int overlayIndex = (Integer)extraData.getData(DaylightDetectorFrameTileEntity.OVERLAY);
                if (overlayIndex != 0) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.375f, 0.0f, 1.0f, overlayIndex, true, true, true, true, true, true, true));
                }
                return quads;
            }
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

