/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.DoorFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class DoorBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null && extraData.getData(FrameBlockTile.DESIGN) != null && extraData.getData(FrameBlockTile.DESIGN_TEXTURE) != null) {
            boolean zStripe;
            boolean sVisible;
            boolean nVisible;
            boolean eVisible;
            boolean wVisible;
            boolean downVisible;
            boolean upVisible;
            boolean yStripe;
            boolean xStripe;
            int z;
            int y;
            int x;
            int zOffset;
            List<TextureAtlasSprite> glassBlockList = TextureHelper.getGlassTextures();
            TextureAtlasSprite glass = glassBlockList.get((Integer)extraData.getData(FrameBlockTile.GLASS_COLOR));
            TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Direction dir = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean open = (Boolean)state.m_61143_((Property)DoorFrameBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorFrameBlock.f_52728_);
            Direction west = Direction.WEST;
            Direction east = Direction.EAST;
            Direction north = Direction.NORTH;
            Direction south = Direction.SOUTH;
            DoorHingeSide left = DoorHingeSide.LEFT;
            DoorHingeSide right = DoorHingeSide.RIGHT;
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
            DoubleBlockHalf lower = DoubleBlockHalf.LOWER;
            DoubleBlockHalf upper = DoubleBlockHalf.UPPER;
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            TextureAtlasSprite innerTexture = design != 1 ? glass : texture;
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            boolean northSide = dir == north && !open || dir == east && open && hinge == right || dir == west && open && hinge == left;
            boolean westSide = dir == west && !open || dir == north && open && hinge == right || dir == south && open && hinge == left;
            boolean eastSide = dir == south && open && hinge == right || dir == east && !open || dir == north && open && hinge == left;
            boolean southSide = dir == east && open && hinge == left || dir == west && open && hinge == right || dir == south && !open;
            int xOffset = eastSide ? 0 : 13;
            int n = zOffset = southSide ? 0 : 13;
            if (design == 0 || design == 1) {
                if (northSide || southSide) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 3; ++z) {
                                xStripe = half == lower ? y < 4 : y > 11;
                                boolean bl = yStripe = x < 4 || x > 11;
                                boolean bl2 = half == lower ? y == 3 && !yStripe : (upVisible = y == 15);
                                downVisible = half == upper ? y == 12 && !yStripe : y == 0;
                                wVisible = x == 0 || x == 12 && !xStripe;
                                eVisible = x == 15 || x == 3 && !xStripe;
                                nVisible = z == 0;
                                boolean bl3 = sVisible = z == 2;
                                if (xStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((xStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!xStripe && !yStripe && z == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, innerTexture, tintIndex, true, true, false, false, false, false));
                                }
                                if (xStripe || yStripe || z != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, true, true, false, false, false, false, false));
                            }
                        }
                    }
                } else if (westSide || eastSide) {
                    for (x = 0; x < 3; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                zStripe = half == lower ? y < 4 : y > 11;
                                boolean bl = yStripe = z < 4 || z > 11;
                                boolean bl4 = half == lower ? y == 3 && !yStripe : (upVisible = y == 15);
                                downVisible = half == upper ? y == 12 && !yStripe : y == 0;
                                nVisible = z == 0 || z == 12 && !zStripe;
                                sVisible = z == 15 || z == 3 && !zStripe;
                                wVisible = x == 0;
                                boolean bl5 = eVisible = x == 2;
                                if (zStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((zStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!zStripe && !yStripe && x == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, innerTexture, tintIndex, false, false, true, true, false, false));
                                }
                                if (zStripe || yStripe || x != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, false, false, true, true, false, false, false));
                            }
                        }
                    }
                }
            }
            if (design == 2) {
                if (northSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                    if (overlayIndex > 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex, true, true, true, true, half == upper, half == lower, false));
                    }
                } else if (westSide) {
                    quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                    if (overlayIndex > 0) {
                        quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, true, true, true, true, half == upper, half == lower, false));
                    }
                } else if (eastSide) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                    if (overlayIndex > 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, true, true, true, true, half == upper, half == lower, false));
                    }
                } else {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, texture, tintIndex, true, true, true, true, half == upper, half == lower));
                    if (overlayIndex > 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex, true, true, true, true, half == upper, half == lower, false));
                    }
                }
            }
            if (design == 3) {
                if (northSide || southSide) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 3; ++z) {
                                xStripe = y < 4 || y > 11;
                                boolean bl = yStripe = x < 4 || x > 11;
                                boolean bl6 = half == lower ? y == 3 && !yStripe : (upVisible = y == 15 || y == 3 && !yStripe);
                                downVisible = half == upper ? y == 12 && !yStripe : y == 0 || y == 12 && !yStripe;
                                wVisible = x == 0 || x == 12 && !xStripe;
                                eVisible = x == 15 || x == 3 && !xStripe;
                                nVisible = z == 0;
                                boolean bl7 = sVisible = z == 2;
                                if (xStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((xStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!xStripe && !yStripe && z == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, innerTexture, tintIndex, true, true, false, false, false, false));
                                }
                                if (xStripe || yStripe || z != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, true, true, false, false, false, false, false));
                            }
                        }
                    }
                } else if (westSide || eastSide) {
                    for (x = 0; x < 3; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                zStripe = y < 4 || y > 11;
                                boolean bl = yStripe = z < 4 || z > 11;
                                boolean bl8 = half == lower ? y == 3 && !yStripe : (upVisible = y == 15 || y == 3 && !yStripe);
                                downVisible = half == upper ? y == 12 && !yStripe : y == 0 || y == 12 && !yStripe;
                                nVisible = z == 0 || z == 12 && !zStripe;
                                sVisible = z == 15 || z == 3 && !zStripe;
                                wVisible = x == 0;
                                boolean bl9 = eVisible = x == 2;
                                if (zStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((zStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!zStripe && !yStripe && x == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, innerTexture, tintIndex, false, false, true, true, false, false));
                                }
                                if (zStripe || yStripe || x != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, false, false, true, true, false, false, false));
                            }
                        }
                    }
                }
            }
            if (design == 4) {
                if (northSide || southSide) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 3; ++z) {
                                xStripe = y < 3 || y > 12 || y == 7 || y == 8;
                                boolean bl = yStripe = x < 3 || x > 12 || x == 7 || x == 8;
                                boolean bl10 = half == lower ? !(y != 2 && y != 8 || yStripe) : (upVisible = y == 15 || (y == 2 || y == 8) && !yStripe);
                                downVisible = half == upper ? !(y != 7 && y != 13 || yStripe) : y == 0 || (y == 7 || y == 13) && !yStripe;
                                wVisible = x == 0 || (x == 7 || x == 13) && !xStripe;
                                eVisible = x == 15 || (x == 2 || x == 8) && !xStripe;
                                nVisible = z == 0;
                                boolean bl11 = sVisible = z == 2;
                                if (xStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((xStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!xStripe && !yStripe && z == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x, y, z + zOffset, innerTexture, tintIndex, true, true, false, false, false, false));
                                }
                                if (xStripe || yStripe || z != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, true, true, false, false, false, false, false));
                            }
                        }
                    }
                }
                if (westSide || eastSide) {
                    for (x = 0; x < 3; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                zStripe = y < 3 || y > 12 || y == 7 || y == 8;
                                boolean bl = yStripe = z < 3 || z > 12 || z == 7 || z == 8;
                                boolean bl12 = half == lower ? !(y != 2 && y != 8 || yStripe) : (upVisible = y == 15 || (y == 2 || y == 8) && !yStripe);
                                downVisible = half == upper ? !(y != 7 && y != 13 || yStripe) : y == 0 || (y == 7 || y == 13) && !yStripe;
                                nVisible = z == 0 || (z == 7 || z == 13) && !zStripe;
                                sVisible = z == 15 || (z == 2 || z == 8) && !zStripe;
                                wVisible = x == 0;
                                boolean bl13 = eVisible = x == 2;
                                if (zStripe || yStripe) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, texture, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible));
                                }
                                if ((zStripe || yStripe) && overlayIndex > 0) {
                                    quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible && y == 15, downVisible, false));
                                }
                                if (!zStripe && !yStripe && x == 1) {
                                    quads.addAll(ModelHelper.createVoxel(x + xOffset, y, z, innerTexture, tintIndex, false, false, true, true, false, false));
                                }
                                if (zStripe || yStripe || x != 1 || overlayIndex <= 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, false, false, true, true, false, false, false));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

