/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionLadderBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            int overlayIndex;
            TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
            ArrayList<TextureAtlasSprite> designTextureList = new ArrayList<TextureAtlasSprite>();
            designTextureList.add(texture);
            designTextureList.addAll(TextureHelper.getMetalTextures());
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int rotation = (Integer)extraData.getData(FrameBlockTile.ROTATION);
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            int desTex = (Integer)extraData.getData(FrameBlockTile.DESIGN_TEXTURE);
            TextureAtlasSprite designTexture = (TextureAtlasSprite)designTextureList.get(desTex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 5) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                    case SOUTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                    case NORTH: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                    case EAST: {
                        return new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 0 || design == 1 || design == 2) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 0 || design == 1) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.125f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.375f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.875f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.125f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.375f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.125f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.375f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.875f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 1) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.0625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.25f, 0.3125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5f, 0.5625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.75f, 0.8125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0f, 0.0625f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.25f, 0.3125f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5f, 0.5625f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.75f, 0.8125f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.0625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.25f, 0.3125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5f, 0.5625f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.75f, 0.8125f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 2) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.0625f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.3125f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.5625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.9375f, 0.8125f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0625f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 3) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                    }
                }
            }
            if (design == 4) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 0.875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.125f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, -1));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0625f, 0.1875f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.4375f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.5625f, 0.6875f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 0.9375f, 0.8125f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, -1));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.0625f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.3125f, 0.4375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.5625f, 0.6875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 0.1875f, 0.8125f, 0.9375f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.125f, 0.25f, designTexture, -1));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.75f, 0.875f, designTexture, -1));
                    }
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                switch ((Direction)state.m_61143_((Property)LadderBlock.f_54337_)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

