/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.LayeredBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionLayeredBlockBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (state != null) {
            if (((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() && mimic != null) {
                ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
            return this.getMimicQuadsEmpty(state, side, extraData);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int layers = (Integer)state.m_61143_((Property)LayeredBlock.LAYERS);
            float layerHeight = (float)layers / 8.0f;
            boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE) != false;
            boolean renderEast = side == Direction.EAST && (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE) != false;
            boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE) != false;
            boolean renderWest = side == Direction.WEST && (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE) != false;
            boolean renderUp = side == Direction.UP && (Boolean)extraData.getData(FrameBlockTile.UP_VISIBLE) != false;
            boolean renderDown = side == Direction.DOWN && (Boolean)extraData.getData(FrameBlockTile.DOWN_VISIBLE) != false;
            int rotation = (Integer)extraData.getData(FrameBlockTile.ROTATION);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 1.0f - layerHeight, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                    break;
                }
                case DOWN: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, layerHeight, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                    break;
                }
                case WEST: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, layerHeight, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                    break;
                }
                case SOUTH: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - layerHeight, 1.0f, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                    break;
                }
                case NORTH: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, layerHeight, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                    break;
                }
                case EAST: {
                    quads.addAll(ModelHelper.createSixFaceCuboid(1.0f - layerHeight, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, rotation));
                }
            }
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            if ((Integer)extraData.getData(FrameBlockTile.OVERLAY) != 0) {
                switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 1.0f - layerHeight, 1.0f, 0.0f, 1.0f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, layerHeight, 0.0f, 1.0f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, layerHeight, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - layerHeight, 1.0f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, layerHeight, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(1.0f - layerHeight, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown, true));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuadsEmpty(@Nullable BlockState state, @Nullable Direction side, @Nonnull IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        if (state != null) {
            int layers = (Integer)state.m_61143_((Property)LayeredBlock.LAYERS);
            boolean renderNorth = side == Direction.NORTH;
            boolean renderEast = side == Direction.EAST;
            boolean renderSouth = side == Direction.SOUTH;
            boolean renderWest = side == Direction.WEST;
            boolean renderUp = side == Direction.UP;
            boolean renderDown = side == Direction.DOWN;
            TextureAtlasSprite textureUp = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
            TextureAtlasSprite textureDown = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
            TextureAtlasSprite textureNorth = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureSouth = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureEast = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite textureWest = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/spruce_trapdoor"));
            TextureAtlasSprite slime = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/slime_block"));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, 0.0f, 1.0f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, 0.0625f, 0.9375f, slime, -1));
                    }
                    break;
                }
                case DOWN: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, ((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, 0.0f, 1.0f, -1, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, 0));
                        quads.addAll(ModelHelper.createCuboid(0.06666667f, 0.9375f, (float)i / 8.0f, ((float)i + 0.5f) / 8.0f, 0.0625f, 0.9375f, slime, -1));
                    }
                    break;
                }
                case WEST: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                        quads.addAll(ModelHelper.createCuboid((float)i / 8.0f, ((float)i + 0.5f) / 8.0f, 0.06666667f, 0.9375f, 0.06666667f, 0.9375f, slime, -1));
                    }
                    break;
                }
                case SOUTH: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                        quads.addAll(ModelHelper.createCuboid(0.06666667f, 0.9375f, 0.06666667f, 0.9375f, 1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, slime, -1));
                    }
                    break;
                }
                case NORTH: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, ((float)i + 0.5f) / 8.0f, (float)(i + 1) / 8.0f, -1, textureNorth, textureSouth, textureUp, textureDown, textureEast, textureWest, 0));
                        quads.addAll(ModelHelper.createCuboid(0.06666667f, 0.9375f, 0.06666667f, 0.9375f, (float)i / 8.0f, ((float)i + 0.5f) / 8.0f, slime, -1));
                    }
                    break;
                }
                case EAST: {
                    for (int i = 0; i < layers; ++i) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(1.0f - (float)(i + 1) / 8.0f, 1.0f - ((float)i + 0.5f) / 8.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1, textureUp, textureDown, textureEast, textureWest, textureNorth, textureSouth, 0));
                        quads.addAll(ModelHelper.createCuboid(1.0f - ((float)i + 0.5f) / 8.0f, 1.0f - (float)i / 8.0f, 0.06666667f, 0.9375f, 0.06666667f, 0.9375f, slime, -1));
                    }
                    break;
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

