/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.TrapdoorFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionTrapdoorBakedModel
implements IDynamicBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getIllusionQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getIllusionQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            boolean yStripe;
            boolean eVisible;
            boolean wVisible;
            boolean sVisible;
            boolean nVisible;
            boolean downVisible;
            boolean upVisible;
            boolean zStripe;
            boolean xStripe;
            int z;
            int y;
            int x;
            int zOffset;
            List<TextureAtlasSprite> glassBlockList = TextureHelper.getGlassTextures();
            TextureAtlasSprite glass = glassBlockList.get((Integer)extraData.getData(FrameBlockTile.GLASS_COLOR));
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int rotation = (Integer)extraData.getData(FrameBlockTile.ROTATION);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Direction dir = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean open = (Boolean)state.m_61143_((Property)TrapdoorFrameBlock.f_57514_);
            Half half = (Half)state.m_61143_((Property)TrapDoorBlock.f_57515_);
            Half top = Half.TOP;
            Half bottom = Half.BOTTOM;
            Direction west = Direction.WEST;
            Direction east = Direction.EAST;
            Direction north = Direction.NORTH;
            Direction south = Direction.SOUTH;
            int design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
            int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
            int xOffset = dir == east ? 0 : 13;
            int yOffset = half == bottom ? 0 : 13;
            int n = zOffset = dir == south ? 0 : 13;
            if (design == 0) {
                if (dir == north && open) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.8125f, 1.0f, overlayIndex));
                    }
                } else if (dir == west && open) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                    }
                } else if (dir == east && open) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex));
                    }
                } else if (dir == south && open) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.1875f, overlayIndex));
                    }
                } else if (half == bottom) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.0f, 0.1875f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.1875f, 0.0f, 1.0f, overlayIndex));
                    }
                } else if (half == top) {
                    quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.8125f, 1.0f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    if (overlayIndex != 0) {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.8125f, 1.0f, 0.0f, 1.0f, overlayIndex, true, true, true, true, true, true, false));
                    }
                }
            }
            if (design == 1 || design == 2 || design == 3) {
                if (!open) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 3; ++y) {
                            for (z = 0; z < 16; ++z) {
                                xStripe = x < 3 || x >= 13;
                                zStripe = z < 3 || z >= 13;
                                upVisible = y == 2;
                                downVisible = y == 0;
                                nVisible = !xStripe && z == 13 || z == 0;
                                sVisible = !xStripe && z == 2 || z == 15;
                                wVisible = !zStripe && x == 13 || x == 0;
                                boolean bl = eVisible = !zStripe && x == 2 || x == 15;
                                if (xStripe || zStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)(y + yOffset) / 16.0f, (float)(y + yOffset + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!xStripe && !zStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y + yOffset, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible, y == 15, half == bottom));
                            }
                        }
                    }
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, (float)(yOffset + 1) / 16.0f, (float)(yOffset + 2) / 16.0f, 0.1875f, 0.8125f, glass, -1));
                } else if ((dir == north || dir == south) && open) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 3; ++z) {
                                xStripe = x < 3 || x >= 13;
                                yStripe = y < 3 || y >= 13;
                                nVisible = z == 0;
                                sVisible = z == 2;
                                wVisible = !yStripe && x == 13 || x == 0;
                                eVisible = !yStripe && x == 2 || x == 15;
                                upVisible = !xStripe && y == 2 || y == 15;
                                boolean bl = downVisible = !xStripe && y == 13 || y == 0;
                                if (xStripe || yStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)(z + zOffset) / 16.0f, (float)(z + zOffset + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!xStripe && !yStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, nVisible, sVisible, eVisible, wVisible, y == 15, downVisible, false));
                            }
                        }
                    }
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.8125f, 0.1875f, 0.8125f, (float)(zOffset + 1) / 16.0f, (float)(zOffset + 2) / 16.0f, glass, -1));
                } else if ((dir == west || dir == east) && open) {
                    for (x = 0; x < 3; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                zStripe = z < 3 || z >= 13;
                                yStripe = y < 3 || y >= 13;
                                wVisible = x == 0;
                                eVisible = x == 2;
                                nVisible = !yStripe && z == 13 || z == 0;
                                sVisible = !yStripe && z == 2 || z == 15;
                                upVisible = !zStripe && y == 2 || y == 15;
                                boolean bl = downVisible = !zStripe && y == 13 || y == 0;
                                if (yStripe || zStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)(x + xOffset) / 16.0f, (float)(x + xOffset + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!yStripe && !zStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, y == 15, downVisible, false));
                            }
                        }
                    }
                    quads.addAll(ModelHelper.createCuboid((float)(xOffset + 1) / 16.0f, (float)(xOffset + 2) / 16.0f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, glass, -1));
                }
                if (design == 2) {
                    if (dir == north && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.8125f, 1.0f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.8125f, 1.0f, overlayIndex));
                        }
                    } else if (dir == west && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.8125f, 1.0f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    } else if (dir == east && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.1875f, 0.8125f, 0.4375f, 0.5625f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.0f, 0.1875f, 0.4375f, 0.5625f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    } else if (dir == south && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.1875f, 0.8125f, 0.0f, 0.1875f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.4375f, 0.5625f, 0.0f, 0.1875f, overlayIndex));
                        }
                    } else if (half == bottom) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.4375f, 0.5625f, 0.0f, 0.1875f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.0f, 0.1875f, 0.4375f, 0.5625f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.0f, 0.1875f, 0.1875f, 0.8125f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.0f, 0.1875f, 0.4375f, 0.5625f, overlayIndex));
                        }
                    } else if (half == top) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.4375f, 0.5625f, 0.8125f, 1.0f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.8125f, 1.0f, 0.4375f, 0.5625f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.4375f, 0.5625f, 0.8125f, 1.0f, 0.1875f, 0.8125f, overlayIndex));
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.8125f, 1.0f, 0.4375f, 0.5625f, overlayIndex));
                        }
                    }
                }
                if (design == 3) {
                    if (dir == north && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.875f, 0.9375f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.875f, 0.9375f, overlayIndex));
                        }
                    } else if (dir == west && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 0.9375f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.875f, 0.9375f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    } else if (dir == east && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0625f, 0.125f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.0625f, 0.125f, 0.1875f, 0.8125f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    } else if (dir == south && open) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.0625f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.1875f, 0.8125f, 0.0625f, 0.125f, overlayIndex));
                        }
                    } else if (half == bottom) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.0625f, 0.125f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.0625f, 0.125f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    } else if (half == top) {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.1875f, 0.8125f, 0.875f, 0.9375f, 0.1875f, 0.8125f, mimic, model, extraData, rand, tintIndex, rotation));
                        if (overlayIndex != 0) {
                            quads.addAll(ModelHelper.createOverlay(0.1875f, 0.8125f, 0.875f, 0.9375f, 0.1875f, 0.8125f, overlayIndex));
                        }
                    }
                }
            }
            if (design == 4) {
                if (!open) {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 3; ++y) {
                            for (z = 0; z < 16; ++z) {
                                upVisible = y == 2;
                                downVisible = y == 0;
                                xStripe = x % 3 == 0;
                                zStripe = z % 3 == 0;
                                nVisible = zStripe && !xStripe || z == 0;
                                sVisible = zStripe && !xStripe || z == 15;
                                eVisible = xStripe && !zStripe || x == 15;
                                boolean bl = wVisible = xStripe && !zStripe || x == 0;
                                if (xStripe || zStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)(y + yOffset) / 16.0f, (float)(y + yOffset + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!xStripe && !zStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y + yOffset, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, upVisible, y == 15, half == bottom));
                            }
                        }
                    }
                } else if (dir == west || dir == east) {
                    for (x = 0; x < 3; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 16; ++z) {
                                wVisible = x == 0;
                                eVisible = x == 2;
                                yStripe = y % 3 == 0;
                                zStripe = z % 3 == 0;
                                nVisible = zStripe && !yStripe || z == 0;
                                sVisible = zStripe && !yStripe || z == 15;
                                upVisible = yStripe && !zStripe || y == 15;
                                boolean bl = downVisible = yStripe && !zStripe || y == 0;
                                if (yStripe || zStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)(x + xOffset) / 16.0f, (float)(x + xOffset + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!yStripe && !zStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x + xOffset, y, z, overlayIndex, nVisible, sVisible, eVisible, wVisible, y == 15, downVisible, false));
                            }
                        }
                    }
                } else {
                    for (x = 0; x < 16; ++x) {
                        for (y = 0; y < 16; ++y) {
                            for (z = 0; z < 3; ++z) {
                                nVisible = z == 0;
                                sVisible = z == 2;
                                yStripe = y % 3 == 0;
                                xStripe = x % 3 == 0;
                                wVisible = xStripe && !yStripe || x == 0;
                                eVisible = xStripe && !yStripe || x == 15;
                                upVisible = yStripe && !xStripe || y == 15;
                                boolean bl = downVisible = yStripe && !xStripe || y == 0;
                                if (yStripe || xStripe) {
                                    quads.addAll(ModelHelper.createSixFaceCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)(z + zOffset) / 16.0f, (float)(z + zOffset + 1) / 16.0f, mimic, model, extraData, rand, tintIndex, nVisible, sVisible, eVisible, wVisible, upVisible, downVisible, rotation));
                                }
                                if (!xStripe && !yStripe || overlayIndex == 0) continue;
                                quads.addAll(ModelHelper.createOverlayVoxel(x, y, z + zOffset, overlayIndex, nVisible, sVisible, eVisible, wVisible, y == 15, downVisible, false));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

