/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.WallFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class WallBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            if (state != null) {
                BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, IModelData extraData, BakedModel model) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null && state != null) {
            int overlayIndex;
            boolean renderWest;
            boolean lowMiddle;
            TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            WallSide north = (WallSide)state.m_61143_((Property)WallFrameBlock.f_57951_);
            WallSide east = (WallSide)state.m_61143_((Property)WallFrameBlock.f_57950_);
            WallSide south = (WallSide)state.m_61143_((Property)WallFrameBlock.f_57952_);
            WallSide west = (WallSide)state.m_61143_((Property)WallFrameBlock.f_57953_);
            boolean isThickPost = (Boolean)state.m_61143_((Property)WallFrameBlock.f_57949_);
            float height_north = 1.0f;
            float height_east = 1.0f;
            float height_south = 1.0f;
            float height_west = 1.0f;
            float height_post = 1.0f;
            if (north != WallSide.TALL) {
                height_north = 0.875f;
            }
            if (east != WallSide.TALL) {
                height_east = 0.875f;
            }
            if (south != WallSide.TALL) {
                height_south = 0.875f;
            }
            if (west != WallSide.TALL) {
                height_west = 0.875f;
            }
            boolean lowNorth = height_north == 0.875f;
            boolean lowEast = height_east == 0.875f;
            boolean lowSouth = height_south == 0.875f;
            boolean lowWest = height_west == 0.875f;
            boolean tallNorth = height_north == 1.0f;
            boolean tallEast = height_east == 1.0f;
            boolean tallSouth = height_south == 1.0f;
            boolean tallWest = height_west == 1.0f;
            boolean somethingOnTop = tallNorth || tallEast || tallSouth || tallWest;
            boolean bl = lowMiddle = lowNorth && lowEast && lowSouth && lowWest;
            if (lowMiddle) {
                height_post = 0.875f;
            }
            boolean renderNorth = north == WallSide.NONE;
            boolean renderEast = east == WallSide.NONE;
            boolean renderSouth = south == WallSide.NONE;
            boolean bl2 = renderWest = west == WallSide.NONE;
            if (!isThickPost) {
                quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_post, 0.3125f, 0.6875f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, !somethingOnTop, true));
            } else {
                quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 1.0f, 0.25f, 0.75f, texture, tintIndex, true, true, true, true, true, true));
            }
            if (design == 0) {
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_north, 0.0f, 0.3125f, texture, tintIndex, true, false, true, true, lowNorth, true));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, height_east, 0.3125f, 0.6875f, texture, tintIndex, true, true, true, false, lowEast, true));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 1.0f, texture, tintIndex, false, true, true, true, lowSouth, true));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, texture, tintIndex, true, true, false, true, lowWest, true));
                }
            }
            if (design == 1) {
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.25f, 0.0f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_north, 0.0f, 0.3125f, texture, tintIndex));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, 0.25f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.625f, height_east, 0.3125f, 0.6875f, texture, tintIndex));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.25f, 0.6875f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_south, 0.6875f, 1.0f, texture, tintIndex));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, 0.25f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.625f, height_west, 0.3125f, 0.6875f, texture, tintIndex));
                }
            }
            if (design == 2) {
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.1875f, 0.4375f, 0.0f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_north, 0.0f, 0.3125f, texture, tintIndex));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.1875f, 0.4375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.625f, height_east, 0.3125f, 0.6875f, texture, tintIndex));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.1875f, 0.4375f, 0.6875f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_south, 0.6875f, 1.0f, texture, tintIndex));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.1875f, 0.4375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.625f, height_west, 0.3125f, 0.6875f, texture, tintIndex));
                }
            }
            if (design == 3) {
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_north, 0.0f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.1875f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.0f, 0.0625f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.5625f, 0.1875f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.4375f, 0.5f, 0.125f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.4375f, 0.0625f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.375f, 0.0f, 0.25f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_north, 0.25f, 0.3125f, texture, tintIndex));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, height_east, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.8125f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.8125f, 0.5f, 0.5625f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.4375f, 0.5f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.9375f, 0.375f, 0.4375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.75f, 0.0f, height_east, 0.3125f, 0.6875f, texture, tintIndex));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_south, 0.75f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.9375f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.75f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.5625f, 0.75f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.4375f, 0.5f, 0.75f, 0.875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.4375f, 0.75f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.375f, 0.75f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 0.75f, texture, tintIndex));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, height_west, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.25f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.25f, 0.5f, 0.5625f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.4375f, 0.5f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.25f, 0.375f, 0.4375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.375f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, texture, tintIndex));
                }
            }
            if (design == 4) {
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_north, 0.0f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, 0.75f, 0.0625f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.625f, 0.1875f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.125f, 0.5f, 0.0625f, 0.3125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.125f, 0.0f, 0.3125f, texture, tintIndex));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.75f, height_east, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.9375f, 0.625f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.8125f, 0.5f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.9375f, 0.125f, 0.5f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, 0.125f, 0.3125f, 0.6875f, texture, tintIndex));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_south, 0.6875f, 1.0f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, 0.75f, 0.6875f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.625f, 0.6875f, 0.8125f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.125f, 0.5f, 0.6875f, 0.9375f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.125f, 0.6875f, 1.0f, texture, tintIndex));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.75f, height_west, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.3125f, 0.625f, 0.75f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.3125f, 0.5f, 0.625f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.3125f, 0.125f, 0.5f, 0.3125f, 0.6875f, texture, tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, 0.125f, 0.3125f, 0.6875f, texture, tintIndex));
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                if (!isThickPost) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, height_post, 0.3125f, 0.6875f, overlayIndex, renderNorth, renderSouth, renderEast, renderWest, !somethingOnTop, true, true));
                } else {
                    quads.addAll(ModelHelper.createOverlay(0.25f, 0.75f, 0.0f, 1.0f, 0.25f, 0.75f, overlayIndex, true, true, true, true, true, true, true));
                }
                if (north == WallSide.LOW || north == WallSide.TALL) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, height_north, 0.0f, 0.3125f, overlayIndex, true, false, true, true, lowNorth, true, true));
                }
                if (east == WallSide.LOW || east == WallSide.TALL) {
                    quads.addAll(ModelHelper.createOverlay(0.6875f, 1.0f, 0.0f, height_east, 0.3125f, 0.6875f, overlayIndex, true, true, true, false, lowEast, true, true));
                }
                if (south == WallSide.LOW || south == WallSide.TALL) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 1.0f, overlayIndex, false, true, true, true, lowSouth, true, true));
                }
                if (west == WallSide.LOW || west == WallSide.TALL) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, overlayIndex, true, true, false, true, lowWest, true, true));
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

