/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.item.BaseFrameItem;
import mod.pianomanu.blockcarpentry.item.BaseIllusionItem;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameBlockEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockModificationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChestFrameBlock
extends FrameBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape INNER_CUBE = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape BOTTOM_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    private static final VoxelShape BOTTOM_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0);
    private static final VoxelShape BOTTOM_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape BOTTOM_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0);
    private static final VoxelShape TOP_NORTH = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape TOP_EAST = Block.m_49796_((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP_SOUTH = Block.m_49796_((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_WEST = Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0);
    private static final VoxelShape NW_PILLAR = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
    private static final VoxelShape SW_PILLAR = Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
    private static final VoxelShape NE_PILLAR = Block.m_49796_((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    private static final VoxelShape SE_PILLAR = Block.m_49796_((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape CHEST = Shapes.m_83124_((VoxelShape)INNER_CUBE, (VoxelShape[])new VoxelShape[]{BOTTOM_EAST, BOTTOM_SOUTH, BOTTOM_WEST, BOTTOM_NORTH, TOP_EAST, TOP_SOUTH, TOP_WEST, TOP_NORTH, NW_PILLAR, SW_PILLAR, NE_PILLAR, SE_PILLAR});

    public ChestFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        if (fluidstate.m_76152_() == Fluids.f_76193_) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76170_()));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChestFrameBlockEntity((BlockEntityType)Registration.CHEST_FRAME_TILE.get(), pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!level.f_46443_) {
                return this.frameUseServer(state, level, pos, player, itemStack, hitresult);
            }
            return this.frameUseClient(state, level, pos, player, itemStack, hitresult);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public InteractionResult frameUseServer(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack, BlockHitResult hitresult) {
        if (this.removeBlock(level, pos, state, itemStack, player)) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() && (BlockAppearanceHelper.setAll(itemStack, state, level, pos, player) || BlockModificationHelper.setAll(itemStack, (ChestFrameBlockEntity)Objects.requireNonNull(level.m_7702_(pos)), player))) {
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_41720_() instanceof BlockItem && this.changeMimic(state, level, pos, player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof ChestFrameBlockEntity && ((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
            return this.chestBehavior(state, level, pos, player, itemStack);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult chestBehavior(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        MenuProvider menuprovider = this.m_7246_(state, level, pos);
        if (menuprovider != null) {
            player.m_5893_(menuprovider);
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public InteractionResult frameUseClient(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack, BlockHitResult hitresult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChestFrameBlockEntity && ((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() && !(itemStack.m_41720_() instanceof BaseFrameItem) && !(itemStack.m_41720_() instanceof BaseIllusionItem)) {
            MenuProvider menuprovider = this.m_7246_(state, level, pos);
            if (menuprovider != null) {
                player.m_5893_(menuprovider);
                player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.frameUseClient(state, level, pos, player, itemStack, hitresult);
    }

    @Override
    public boolean removeBlock(Level level, BlockPos pos, BlockState state, ItemStack itemStack, Player player) {
        if (itemStack.m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
            if (!player.m_7500_()) {
                this.dropContainedBlock(level, pos);
            }
            state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, state, 2);
            return true;
        }
        return false;
    }

    @Override
    public void dropContainedBlock(Level level, BlockPos pos) {
        ChestFrameBlockEntity frameBlockEntity;
        BlockState blockState;
        BlockEntity tileentity;
        if (!level.f_46443_ && (tileentity = level.m_7702_(pos)) instanceof ChestFrameBlockEntity && (blockState = (frameBlockEntity = (ChestFrameBlockEntity)tileentity).getMimic()) != null) {
            level.m_46796_(1010, pos, 0);
            frameBlockEntity.clear();
            float f = 0.7f;
            double d0 = (double)(level.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(level.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(level.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((ItemLike)blockState.m_60734_());
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
            frameBlockEntity.clear();
        }
    }

    @Override
    public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity tileentity = levelIn.m_7702_(pos);
        if (tileentity instanceof ChestFrameBlockEntity) {
            ChestFrameBlockEntity frameBlockEntity = (ChestFrameBlockEntity)tileentity;
            frameBlockEntity.clear();
            frameBlockEntity.setMimic(handBlock);
            levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = levelIn.m_7702_(pos)) instanceof ChestFrameBlockEntity) {
            this.dropContainedBlock(levelIn, pos);
            Containers.m_19010_((Level)levelIn, (BlockPos)pos, ((ChestFrameBlockEntity)te).m_7086_());
        }
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelIn));
        }
        return super.m_7417_(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return CHEST;
    }

    @Override
    public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof ChestFrameBlockEntity;
    }

    @Override
    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return super.getFriction(state, level, pos, entity);
    }

    @Override
    public boolean executeModifications(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        return BlockAppearanceHelper.setAll(itemStack, state, level, pos, player) || this.getTile((BlockGetter)level, pos) != null && BlockModificationHelper.setAll(itemStack, this.getTile((BlockGetter)level, pos), player, true, false);
    }
}

