/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.IFrameTile;
import mod.pianomanu.blockcarpentry.util.VoxelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class FrameBlockTile
extends BlockEntity
implements IForgeBlockEntity,
IFrameTile {
    public static final List<IFrameTile.TagPacket<?>> TAG_PACKETS = FrameBlockTile.initTagPackets();
    private VoxelShape shape = Shapes.m_83144_();
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    public static final ModelProperty<Integer> OVERLAY = new ModelProperty();
    public static final ModelProperty<Integer> ROTATION = new ModelProperty();
    public static final ModelProperty<Boolean> KEEP_UV = new ModelProperty();
    public static final ModelProperty<Boolean> REMAIN_RECTANGLE = new ModelProperty();
    public static final ModelProperty<Boolean> NORTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> EAST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> SOUTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> WEST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> UP_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> DOWN_VISIBLE = new ModelProperty();
    public static final ModelProperty<List<Direction>> DIRECTIONS = new ModelProperty();
    public static final ModelProperty<Vec3> NWU_prop = new ModelProperty();
    public static final ModelProperty<Vec3> NEU_prop = new ModelProperty();
    public static final ModelProperty<Vec3> NWD_prop = new ModelProperty();
    public static final ModelProperty<Vec3> NED_prop = new ModelProperty();
    public static final ModelProperty<Vec3> SWU_prop = new ModelProperty();
    public static final ModelProperty<Vec3> SEU_prop = new ModelProperty();
    public static final ModelProperty<Vec3> SWD_prop = new ModelProperty();
    public static final ModelProperty<Vec3> SED_prop = new ModelProperty();
    public static final ModelProperty<List<Integer>> ROTATIONS = new ModelProperty();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    public BlockState mimic;
    public Integer texture = 0;
    public Integer design = 0;
    public Integer designTexture = 0;
    public Integer glassColor = 0;
    public Integer overlay = 0;
    public Integer rotation = 0;
    public Boolean keepUV = true;
    public Boolean faceRemainRectangle = true;
    public Float friction = Float.valueOf(((FrameBlock)Registration.FRAMEBLOCK.get()).m_49958_());
    public Float explosionResistance = Float.valueOf(((FrameBlock)Registration.FRAMEBLOCK.get()).m_7325_());
    public Boolean canSustainPlant = false;
    public Integer enchantPowerBonus = 0;
    public Boolean canEntityDestroy = true;
    public Boolean northVisible = true;
    public Boolean eastVisible = true;
    public Boolean southVisible = true;
    public Boolean westVisible = true;
    public Boolean upVisible = true;
    public Boolean downVisible = true;
    public List<Integer> rotations = Arrays.asList(0, 0, 0, 0, 0, 0);
    public Vec3 NWU = new Vec3(0.0, 0.0, 0.0);
    public Vec3 NEU = new Vec3(0.0, 0.0, 0.0);
    public Vec3 NWD = new Vec3(0.0, 0.0, 0.0);
    public Vec3 NED = new Vec3(0.0, 0.0, 0.0);
    public Vec3 SWU = new Vec3(0.0, 0.0, 0.0);
    public Vec3 SEU = new Vec3(0.0, 0.0, 0.0);
    public Vec3 SWD = new Vec3(0.0, 0.0, 0.0);
    public Vec3 SED = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldNWU = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldNEU = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldNWD = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldNED = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldSWU = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldSEU = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldSWD = new Vec3(0.0, 0.0, 0.0);
    private Vec3 oldSED = new Vec3(0.0, 0.0, 0.0);
    public List<Direction> directions = new ArrayList<Direction>();
    public List<Vec3[]> corners = new ArrayList<Vec3[]>();

    private static List<IFrameTile.TagPacket<?>> initTagPackets() {
        ArrayList packets = new ArrayList();
        packets.add(new IFrameTile.TagPacket<Vec3>("NWD", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("NWU", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("NED", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("NEU", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("SWD", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("SWU", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("SED", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket<Vec3>("SEU", Vec3.class, Vec3.f_82478_));
        packets.add(new IFrameTile.TagPacket("directions", List.class, Collections.emptyList()));
        return packets;
    }

    public FrameBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.FRAMEBLOCK_TILE.get(), pos, state);
        this.updateVecList();
    }

    public FrameBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void updateVecList() {
        this.corners = new ArrayList<Vec3[]>();
        this.corners.add(new Vec3[]{this.NWD, this.NED, this.NWU, this.SWD});
        this.corners.add(new Vec3[]{this.NWU, this.NEU, this.NWD, this.SWU});
        this.corners.add(new Vec3[]{this.NED, this.NWD, this.NEU, this.SED});
        this.corners.add(new Vec3[]{this.NEU, this.NWU, this.NED, this.SEU});
        this.corners.add(new Vec3[]{this.SWD, this.SED, this.SWU, this.NWD});
        this.corners.add(new Vec3[]{this.SWU, this.SEU, this.SWD, this.NWU});
        this.corners.add(new Vec3[]{this.SED, this.SWD, this.SEU, this.NED});
        this.corners.add(new Vec3[]{this.SEU, this.SWU, this.SED, this.NEU});
    }

    public <V> V set(V newValue) {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        return newValue;
    }

    @Override
    public BlockState getMimic() {
        return this.mimic;
    }

    @Override
    public Integer getDesign() {
        return this.design;
    }

    @Override
    public Integer getDesignTexture() {
        return this.designTexture;
    }

    @Override
    public void setMimic(BlockState mimic) {
        this.mimic = this.set(mimic);
    }

    @Override
    public Integer getTexture() {
        return this.texture;
    }

    @Override
    public void setDesign(Integer design) {
        this.design = this.set(design);
    }

    @Override
    public Integer getGlassColor() {
        return this.glassColor;
    }

    @Override
    public void setDesignTexture(Integer designTexture) {
        this.designTexture = this.set(designTexture);
    }

    @Override
    public Integer getRotation() {
        return this.rotation;
    }

    @Override
    public void setTexture(Integer texture) {
        this.texture = this.set(texture);
    }

    public void setNWU(Vec3 NWU) {
        if (this.inRange(NWU.f_82479_, 16) && this.inRange(NWU.f_82480_, -16) && this.inRange(NWU.f_82481_, 16)) {
            this.NWU = this.set(NWU);
        }
    }

    public void setNEU(Vec3 NEU) {
        if (this.inRange(NEU.f_82479_, -16) && this.inRange(NEU.f_82480_, -16) && this.inRange(NEU.f_82481_, 16)) {
            this.NEU = this.set(NEU);
        }
    }

    public void setNWD(Vec3 NWD) {
        if (this.inRange(NWD.f_82479_, 16) && this.inRange(NWD.f_82480_, 16) && this.inRange(NWD.f_82481_, 16)) {
            this.NWD = this.set(NWD);
        }
    }

    public void setNED(Vec3 NED) {
        if (this.inRange(NED.f_82479_, -16) && this.inRange(NED.f_82480_, 16) && this.inRange(NED.f_82481_, 16)) {
            this.NED = this.set(NED);
        }
    }

    public void setSWU(Vec3 SWU) {
        if (this.inRange(SWU.f_82479_, 16) && this.inRange(SWU.f_82480_, -16) && this.inRange(SWU.f_82481_, -16)) {
            this.SWU = this.set(SWU);
        }
    }

    public void setSEU(Vec3 SEU) {
        if (this.inRange(SEU.f_82479_, -16) && this.inRange(SEU.f_82480_, -16) && this.inRange(SEU.f_82481_, -16)) {
            this.SEU = this.set(SEU);
        }
    }

    public void setSWD(Vec3 SWD) {
        if (this.inRange(SWD.f_82479_, 16) && this.inRange(SWD.f_82480_, 16) && this.inRange(SWD.f_82481_, -16)) {
            this.SWD = this.set(SWD);
        }
    }

    public void setSED(Vec3 SED) {
        if (this.inRange(SED.f_82479_, -16) && this.inRange(SED.f_82480_, 16) && this.inRange(SED.f_82481_, -16)) {
            this.SED = this.set(SED);
        }
    }

    private boolean inRange(double val, int limit) {
        int min = Math.min(0, limit);
        int max = Math.max(0, limit);
        return val >= (double)min && val <= (double)max;
    }

    @Override
    public void setGlassColor(Integer colorNumber) {
        this.glassColor = this.set(colorNumber);
    }

    @Override
    public Integer getOverlay() {
        return this.overlay;
    }

    @Override
    public void setRotation(Integer rotation) {
        this.rotation = this.set(rotation);
    }

    @Override
    public void setOverlay(Integer overlay) {
        this.overlay = this.set(overlay);
    }

    @Override
    public Float getFriction() {
        return this.friction;
    }

    @Override
    public void setFriction(Float friction) {
        this.friction = this.set(friction);
    }

    @Override
    public Float getExplosionResistance() {
        return this.explosionResistance;
    }

    @Override
    public void setExplosionResistance(Float explosionResistance) {
        this.explosionResistance = this.set(explosionResistance);
    }

    @Override
    public Boolean getCanSustainPlant() {
        return this.canSustainPlant;
    }

    @Override
    public void setCanSustainPlant(Boolean canSustainPlant) {
        this.canSustainPlant = this.set(canSustainPlant);
    }

    @Override
    public Integer getEnchantPowerBonus() {
        return this.enchantPowerBonus;
    }

    @Override
    public void setEnchantPowerBonus(Integer enchantPowerBonus) {
        this.enchantPowerBonus = this.set(enchantPowerBonus);
    }

    @Override
    public Boolean getCanEntityDestroy() {
        return this.canEntityDestroy;
    }

    @Override
    public void setCanEntityDestroy(Boolean canEntityDestroy) {
        this.canEntityDestroy = this.set(canEntityDestroy);
    }

    public void addDirection(Direction direction) {
        this.directions.add(this.set(direction));
        this.trySimplifyDirections();
    }

    private void trySimplifyDirections() {
        int i = 0;
        Direction prev = null;
        ArrayList<Direction> newDirections = new ArrayList<Direction>();
        for (Direction d : this.directions) {
            newDirections.add(d);
            if (d != prev) {
                if (d.m_122424_() == prev) {
                    this.removeLastNEntries(newDirections, 2);
                    prev = (Direction)newDirections.get(newDirections.size() - 1);
                } else {
                    prev = d;
                }
                i = 0;
                continue;
            }
            if (++i != 3) continue;
            this.removeLastNEntries(newDirections, 4);
            i = 0;
        }
        this.directions = this.set(newDirections);
    }

    private void removeLastNEntries(List<Direction> directions, int iters) {
        int size = directions.size();
        for (int i = 1; i <= iters; ++i) {
            directions.remove(size - iters);
        }
    }

    public Integer getRotation(Direction direction) {
        return this.rotations.get(direction.ordinal());
    }

    public void addRotation(Direction direction) {
        if (this.rotations.size() != 6) {
            this.rotations = new ArrayList<Integer>();
            this.rotations.addAll(Arrays.asList(0, 0, 0, 0, 0, 0));
        }
        if (this.rotations.get(direction.ordinal()) >= 3) {
            this.rotations.set(direction.ordinal(), this.set(0));
        } else {
            this.rotations.set(direction.ordinal(), this.set(this.rotations.get(direction.ordinal()) + 1));
        }
    }

    public Boolean getKeepUV() {
        return this.keepUV;
    }

    public void setKeepUV(Boolean keepUV) {
        this.keepUV = this.set(keepUV);
    }

    public Boolean getFaceRemainRectangle() {
        return this.faceRemainRectangle;
    }

    public void setFaceRemainRectangle(Boolean faceRemainRectangle) {
        this.faceRemainRectangle = this.set(faceRemainRectangle);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.updateShape();
        this.onDataPacket(pkt, FrameBlockTile.class, this.f_58857_, this.f_58858_, this.m_58900_());
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).withInitial(GLASS_COLOR, (Object)this.glassColor).withInitial(OVERLAY, (Object)this.overlay).withInitial(ROTATION, (Object)this.rotation).withInitial(KEEP_UV, (Object)this.keepUV).withInitial(REMAIN_RECTANGLE, (Object)this.faceRemainRectangle).withInitial(NORTH_VISIBLE, (Object)this.northVisible).withInitial(EAST_VISIBLE, (Object)this.eastVisible).withInitial(SOUTH_VISIBLE, (Object)this.southVisible).withInitial(WEST_VISIBLE, (Object)this.westVisible).withInitial(UP_VISIBLE, (Object)this.upVisible).withInitial(DOWN_VISIBLE, (Object)this.downVisible).withInitial(NWU_prop, (Object)this.NWU).withInitial(NEU_prop, (Object)this.NEU).withInitial(NWD_prop, (Object)this.NWD).withInitial(NED_prop, (Object)this.NED).withInitial(SWU_prop, (Object)this.SWU).withInitial(SEU_prop, (Object)this.SEU).withInitial(SWD_prop, (Object)this.SWD).withInitial(SED_prop, (Object)this.SED).withInitial(DIRECTIONS, this.directions).withInitial(ROTATIONS, this.rotations).build();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.updateShape();
        return this.getUpdateTag(tag, FrameBlockTile.class);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.updateShape();
        IFrameTile.super.load(tag, FrameBlockTile.class);
        this.updateVecList();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        IFrameTile.super.saveAdditional(tag, FrameBlockTile.class);
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public void updateShape() {
        if (this.shapeChanged()) {
            this.shape = this.set(VoxelUtils.getShape(this));
        }
    }

    public boolean shapeUnmodified() {
        return this.NWD.equals((Object)Vec3.f_82478_) && this.NWU.equals((Object)Vec3.f_82478_) && this.NED.equals((Object)Vec3.f_82478_) && this.NEU.equals((Object)Vec3.f_82478_) && this.SWD.equals((Object)Vec3.f_82478_) && this.SWU.equals((Object)Vec3.f_82478_) && this.SED.equals((Object)Vec3.f_82478_) && this.SEU.equals((Object)Vec3.f_82478_);
    }

    public boolean shapeChanged() {
        if (this.NWD.equals((Object)this.oldNWD) && this.NWU.equals((Object)this.oldNWU) && this.NED.equals((Object)this.oldNED) && this.NEU.equals((Object)this.oldNEU) && this.SWD.equals((Object)this.oldSWD) && this.SWU.equals((Object)this.oldSWU) && this.SED.equals((Object)this.oldSED) && this.SEU.equals((Object)this.oldSEU)) {
            return false;
        }
        this.oldNWD = this.NWD;
        this.oldNWU = this.NWU;
        this.oldNED = this.NED;
        this.oldNEU = this.NEU;
        this.oldSWD = this.SWD;
        this.oldSWU = this.SWU;
        this.oldSED = this.SED;
        this.oldSEU = this.SEU;
        return true;
    }
}

