/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.IFrameTile;
import mod.pianomanu.blockcarpentry.util.FrameInteractionItems;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BlockModificationHelper {
    private static final float FRICTION_MAX_BOUNDARY = ((Double)BCModConfig.FRICTION_MAX_BOUNDARY.get()).floatValue();
    private static final float FRICTION_MIN_BOUNDARY = ((Double)BCModConfig.FRICTION_MIN_BOUNDARY.get()).floatValue();
    private static final float FRICTION_MODIFIER = ((Double)BCModConfig.FRICTION_MODIFIER.get()).floatValue();
    private static final float EXPLOSION_RESISTANCE_MAX = ((Double)BCModConfig.EXPLOSION_RESISTANCE_MAX.get()).floatValue();
    private static final float EXPLOSION_RESISTANCE_MODIFIER = ((Double)BCModConfig.EXPLOSION_RESISTANCE_MODIFIER.get()).floatValue();

    public static <V extends IFrameTile> boolean setAll(ItemStack itemStack, V blockEntity, Player player) {
        return BlockModificationHelper.setAll(itemStack, blockEntity, player, true, true);
    }

    public static <V extends IFrameTile> boolean setAll(ItemStack itemStack, V blockEntity, Player player, boolean applyFriction, boolean applySustainability) {
        return BlockModificationHelper.setAll(itemStack, blockEntity, player, applyFriction, applySustainability, true);
    }

    public static <V extends IFrameTile> boolean setAll(ItemStack itemStack, V blockEntity, Player player, boolean applyFriction, boolean applySustainability, boolean applyEnchantingPower) {
        if (IFrameTile.class.isAssignableFrom(blockEntity.getClass())) {
            boolean set = false;
            if (applyFriction) {
                set = BlockModificationHelper.setFriction(itemStack, blockEntity, player);
            }
            set |= BlockModificationHelper.setExplosionResistance(itemStack, blockEntity, player);
            if (applySustainability) {
                set |= BlockModificationHelper.setSustainability(itemStack, blockEntity, player);
            }
            if (applyEnchantingPower) {
                set |= BlockModificationHelper.setEnchantingPower(itemStack, blockEntity, player);
            }
            return set |= BlockModificationHelper.setCanEntityDestroy(itemStack, blockEntity, player);
        }
        return false;
    }

    public static <V extends IFrameTile> boolean setFriction(ItemStack itemStack, V frameBlockTile, Player player) {
        if (((Boolean)BCModConfig.FRICTION_ENABLED.get()).booleanValue()) {
            if (FrameInteractionItems.isFrictionModifierNegative(itemStack.m_41720_())) {
                return BlockModificationHelper.setFriction(itemStack, frameBlockTile, player, false);
            }
            if (FrameInteractionItems.isFrictionModifierPositive(itemStack.m_41720_())) {
                return BlockModificationHelper.setFriction(itemStack, frameBlockTile, player, true);
            }
        }
        return false;
    }

    private static <V extends IFrameTile> boolean setFriction(ItemStack itemStack, V fte, Player player, boolean increaseFriction) {
        if (fte.getFriction().floatValue() > FRICTION_MIN_BOUNDARY && fte.getFriction().floatValue() < FRICTION_MAX_BOUNDARY) {
            itemStack.m_41764_(itemStack.m_41613_() - 1);
        }
        fte.setFriction(Float.valueOf(BlockModificationHelper.newFrictionValue(fte.getFriction().floatValue(), increaseFriction)));
        player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.friction", new Object[]{Float.valueOf((float)Math.round(fte.getFriction().floatValue() * 1000.0f) / 1000.0f)}), true);
        return true;
    }

    private static float newFrictionValue(float currValue, boolean increaseFriction) {
        if (increaseFriction) {
            return Math.min(currValue * FRICTION_MODIFIER, FRICTION_MAX_BOUNDARY);
        }
        return Math.max(currValue / FRICTION_MODIFIER, FRICTION_MIN_BOUNDARY);
    }

    public static <V extends IFrameTile> boolean setExplosionResistance(ItemStack itemStack, V fte, Player player) {
        if (((Boolean)BCModConfig.EXPLOSION_RESISTANCE_ENABLED.get()).booleanValue()) {
            if (FrameInteractionItems.isExplosionResistanceModifierSingle(itemStack.m_41720_())) {
                if (fte.getExplosionResistance().floatValue() < EXPLOSION_RESISTANCE_MAX) {
                    itemStack.m_41764_(itemStack.m_41613_() - 1);
                }
                float min = Math.min(fte.getExplosionResistance().floatValue() * EXPLOSION_RESISTANCE_MODIFIER, EXPLOSION_RESISTANCE_MAX);
                fte.setExplosionResistance(Float.valueOf(min));
                player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.strength", new Object[]{Float.valueOf((float)Math.round(fte.getExplosionResistance().floatValue() * 1000.0f) / 1000.0f)}), true);
                return true;
            }
            if (FrameInteractionItems.isExplosionResistanceModifierUltra(itemStack.m_41720_())) {
                if (fte.getExplosionResistance().floatValue() < EXPLOSION_RESISTANCE_MAX) {
                    itemStack.m_41764_(itemStack.m_41613_() - 1);
                }
                fte.setExplosionResistance(Float.valueOf(EXPLOSION_RESISTANCE_MAX));
                player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.strength_max", new Object[]{Float.valueOf((float)Math.round(fte.getExplosionResistance().floatValue() * 1000.0f) / 1000.0f)}), true);
                return true;
            }
        }
        return false;
    }

    public static <V extends IFrameTile> boolean setSustainability(ItemStack itemStack, V fte, Player player) {
        if (((Boolean)BCModConfig.SUSTAINABILITY_ENABLED.get()).booleanValue() && FrameInteractionItems.isSustainabilityModifier(itemStack.m_41720_())) {
            if (!fte.getCanSustainPlant().booleanValue()) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            fte.setCanSustainPlant(true);
            player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.sustainability"), true);
            return true;
        }
        return false;
    }

    public static <V extends IFrameTile> boolean setEnchantingPower(ItemStack itemStack, V fte, Player player) {
        if (((Boolean)BCModConfig.ENCHANT_POWER_ENABLED.get()).booleanValue() && FrameInteractionItems.isEnchantingPowerModifier(itemStack.m_41720_())) {
            if (fte.getEnchantPowerBonus() != 1) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            fte.setEnchantPowerBonus(1);
            player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.enchanting_power"), true);
            return true;
        }
        return false;
    }

    public static <V extends IFrameTile> boolean setCanEntityDestroy(ItemStack itemStack, V fte, Player player) {
        if (((Boolean)BCModConfig.CAN_ENTITY_DESTROY_ENABLED.get()).booleanValue() && FrameInteractionItems.isEntityDestroyModifier(itemStack.m_41720_())) {
            if (fte.getCanEntityDestroy().booleanValue()) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.can_entity_destroy"), true);
            } else {
                player.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.can_entity_destroy_already"), true);
            }
            fte.setCanEntityDestroy(false);
            return true;
        }
        return false;
    }
}

