/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CornerUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void changeBoxSize(BlockState state, Level level, BlockPos pos, Player player, Vec3 location, Direction clicked_face, boolean shrink) {
        Vec3 corner = CornerUtils.getNearestCorner(location);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof FrameBlockTile) {
            FrameBlockTile fte = (FrameBlockTile)entity;
            Vec3[] cornerPlusAdjacents = CornerUtils.getCorrespondingCornerList(fte, corner, CornerUtils.getVec(pos));
            Vec3 old_corner = cornerPlusAdjacents[0];
            if (CornerUtils.checkCanChange(cornerPlusAdjacents, clicked_face, shrink)) {
                CornerUtils.setCorrespondingCorner(fte, corner, CornerUtils.getVec(pos), CornerUtils.modify(old_corner, clicked_face, shrink));
                fte.updateVecList();
                CornerUtils.writeNBT(fte);
                fte.requestModelDataUpdate();
                level.m_151523_((BlockEntity)fte);
            }
        }
    }

    private static Vec3 getNearestCorner(Vec3 vec) {
        return new Vec3((double)Math.round(vec.f_82479_), (double)Math.round(vec.f_82480_), (double)Math.round(vec.f_82481_));
    }

    private static Vec3[] getCorrespondingCornerList(FrameBlockTile tile, Vec3 corner, Vec3 blockpos) {
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_) {
            return tile.corners.get(0);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_) {
            return tile.corners.get(1);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_) {
            return tile.corners.get(2);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_) {
            return tile.corners.get(3);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            return tile.corners.get(4);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            return tile.corners.get(5);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            return tile.corners.get(6);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            return tile.corners.get(7);
        }
        return new Vec3[]{CornerUtils.getNearestCorner(corner)};
    }

    private static void setCorrespondingCorner(FrameBlockTile tile, Vec3 corner, Vec3 blockpos, Vec3 new_corner) {
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_) {
            tile.setNWD(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_) {
            tile.setNWU(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_) {
            tile.setNED(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_) {
            tile.setNEU(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            tile.setSWD(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            tile.setSWU(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            tile.setSED(new_corner);
        }
        if (corner.f_82479_ == blockpos.f_82479_ + 1.0 && corner.f_82480_ == blockpos.f_82480_ + 1.0 && corner.f_82481_ == blockpos.f_82481_ + 1.0) {
            tile.setSEU(new_corner);
        }
    }

    private static Vec3 getVec(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    private static Vec3 modify(Vec3 vec, Direction direction, boolean shrink) {
        double change = shrink ? -1.0 : 1.0;
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(vec.f_82479_, vec.f_82480_ - change, vec.f_82481_);
            case Direction.UP -> new Vec3(vec.f_82479_, vec.f_82480_ + change, vec.f_82481_);
            case Direction.NORTH -> new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_ - change);
            case Direction.WEST -> new Vec3(vec.f_82479_ - change, vec.f_82480_, vec.f_82481_);
            case Direction.SOUTH -> new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_ + change);
            case Direction.EAST -> new Vec3(vec.f_82479_ + change, vec.f_82480_, vec.f_82481_);
        };
    }

    private static boolean checkCanChange(Vec3[] cornerVec, Direction direction, boolean shrink) {
        int min = shrink ? 0 : 1;
        int max = shrink ? 15 : 16;
        try {
            Vec3 opposing = CornerUtils.getOpposingCorner(cornerVec, direction);
            return CornerUtils.checkVectorOverlap(cornerVec[0], opposing, min, max, direction);
        }
        catch (Exception e) {
            LOGGER.error("Unable to check changeability in FrameBlockTile with corners " + Arrays.toString(cornerVec));
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkVectorOverlap(Vec3 vec1, Vec3 vec2, int min, int max, Direction direction) {
        double v1;
        double dif = Math.abs(v1) + Math.abs(switch (direction) {
            case Direction.WEST, Direction.EAST -> {
                v1 = vec1.f_82479_;
                yield vec2.f_82479_;
            }
            case Direction.DOWN, Direction.UP -> {
                v1 = vec1.f_82480_;
                yield vec2.f_82480_;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                v1 = vec1.f_82481_;
                yield vec2.f_82481_;
            }
            default -> {
                v1 = 0.0;
                yield 0.0;
            }
        });
        return dif >= (double)min && dif <= (double)max;
    }

    private static Vec3 getOpposingCorner(Vec3[] corners, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.WEST, Direction.EAST -> corners[1];
            case Direction.DOWN, Direction.UP -> corners[2];
            case Direction.NORTH, Direction.SOUTH -> corners[3];
        };
    }

    private static void writeNBT(FrameBlockTile fte) {
        CompoundTag tag = fte.m_5995_();
        for (int i = 0; i < fte.corners.size(); ++i) {
            fte.write(tag, FrameBlockTile.TAG_PACKETS.get((int)i).TAG_ELEMENT, fte.corners.get(i)[0]);
        }
        fte.getUpdateTag(tag, FrameBlockTile.class);
    }

    public static Vec3[] rotateVec3s(Vec3 NWU, Vec3 NEU, Vec3 SWU, Vec3 SEU, Vec3 NWD, Vec3 NED, Vec3 SWD, Vec3 SED, Direction direction) {
        Vec3[] vec3Array;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                Vec3[] vec3Array2 = new Vec3[8];
                vec3Array2[0] = NEU;
                vec3Array2[1] = SEU;
                vec3Array2[2] = NWU;
                vec3Array2[3] = SWU;
                vec3Array2[4] = NED;
                vec3Array2[5] = SED;
                vec3Array2[6] = NWD;
                vec3Array = vec3Array2;
                vec3Array2[7] = SWD;
                break;
            }
            case DOWN: {
                Vec3[] vec3Array3 = new Vec3[8];
                vec3Array3[0] = SWU;
                vec3Array3[1] = NWU;
                vec3Array3[2] = SEU;
                vec3Array3[3] = NEU;
                vec3Array3[4] = SWD;
                vec3Array3[5] = NWD;
                vec3Array3[6] = SED;
                vec3Array = vec3Array3;
                vec3Array3[7] = NED;
                break;
            }
            case EAST: {
                Vec3[] vec3Array4 = new Vec3[8];
                vec3Array4[0] = SWU;
                vec3Array4[1] = SEU;
                vec3Array4[2] = SWD;
                vec3Array4[3] = SED;
                vec3Array4[4] = NWU;
                vec3Array4[5] = NEU;
                vec3Array4[6] = NWD;
                vec3Array = vec3Array4;
                vec3Array4[7] = NED;
                break;
            }
            case WEST: {
                Vec3[] vec3Array5 = new Vec3[8];
                vec3Array5[0] = NWD;
                vec3Array5[1] = NED;
                vec3Array5[2] = NWU;
                vec3Array5[3] = NEU;
                vec3Array5[4] = SWD;
                vec3Array5[5] = SED;
                vec3Array5[6] = SWU;
                vec3Array = vec3Array5;
                vec3Array5[7] = SEU;
                break;
            }
            case SOUTH: {
                Vec3[] vec3Array6 = new Vec3[8];
                vec3Array6[0] = NWD;
                vec3Array6[1] = NWU;
                vec3Array6[2] = SWD;
                vec3Array6[3] = SWU;
                vec3Array6[4] = NED;
                vec3Array6[5] = NEU;
                vec3Array6[6] = SED;
                vec3Array = vec3Array6;
                vec3Array6[7] = SEU;
                break;
            }
            case NORTH: {
                Vec3[] vec3Array7 = new Vec3[8];
                vec3Array7[0] = NEU;
                vec3Array7[1] = NED;
                vec3Array7[2] = SEU;
                vec3Array7[3] = SED;
                vec3Array7[4] = NWU;
                vec3Array7[5] = NWD;
                vec3Array7[6] = SWU;
                vec3Array = vec3Array7;
                vec3Array7[7] = SWD;
            }
        }
        return vec3Array;
    }

    public static Direction[] getRotatedDirection(Direction up, Direction down, Direction north, Direction east, Direction south, Direction west, Direction direction) {
        Direction[] directionArray;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                Direction[] directionArray2 = new Direction[6];
                directionArray2[0] = up;
                directionArray2[1] = down;
                directionArray2[2] = east;
                directionArray2[3] = south;
                directionArray2[4] = west;
                directionArray = directionArray2;
                directionArray2[5] = north;
                break;
            }
            case DOWN: {
                Direction[] directionArray3 = new Direction[6];
                directionArray3[0] = up;
                directionArray3[1] = down;
                directionArray3[2] = west;
                directionArray3[3] = north;
                directionArray3[4] = east;
                directionArray = directionArray3;
                directionArray3[5] = south;
                break;
            }
            case NORTH: {
                Direction[] directionArray4 = new Direction[6];
                directionArray4[0] = west;
                directionArray4[1] = east;
                directionArray4[2] = north;
                directionArray4[3] = up;
                directionArray4[4] = south;
                directionArray = directionArray4;
                directionArray4[5] = down;
                break;
            }
            case EAST: {
                Direction[] directionArray5 = new Direction[6];
                directionArray5[0] = south;
                directionArray5[1] = north;
                directionArray5[2] = up;
                directionArray5[3] = east;
                directionArray5[4] = down;
                directionArray = directionArray5;
                directionArray5[5] = west;
                break;
            }
            case SOUTH: {
                Direction[] directionArray6 = new Direction[6];
                directionArray6[0] = east;
                directionArray6[1] = west;
                directionArray6[2] = north;
                directionArray6[3] = down;
                directionArray6[4] = south;
                directionArray = directionArray6;
                directionArray6[5] = up;
                break;
            }
            case WEST: {
                Direction[] directionArray7 = new Direction[6];
                directionArray7[0] = north;
                directionArray7[1] = south;
                directionArray7[2] = down;
                directionArray7[3] = east;
                directionArray7[4] = up;
                directionArray = directionArray7;
                directionArray7[5] = west;
            }
        }
        return directionArray;
    }

    public static boolean[] getRotatedVisibility(boolean up, boolean down, boolean north, boolean east, boolean south, boolean west, Direction direction) {
        boolean[] blArray;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                boolean[] blArray2 = new boolean[6];
                blArray2[0] = up;
                blArray2[1] = down;
                blArray2[2] = east;
                blArray2[3] = south;
                blArray2[4] = west;
                blArray = blArray2;
                blArray2[5] = north;
                break;
            }
            case DOWN: {
                boolean[] blArray3 = new boolean[6];
                blArray3[0] = up;
                blArray3[1] = down;
                blArray3[2] = west;
                blArray3[3] = north;
                blArray3[4] = east;
                blArray = blArray3;
                blArray3[5] = south;
                break;
            }
            case NORTH: {
                boolean[] blArray4 = new boolean[6];
                blArray4[0] = west;
                blArray4[1] = east;
                blArray4[2] = north;
                blArray4[3] = up;
                blArray4[4] = south;
                blArray = blArray4;
                blArray4[5] = down;
                break;
            }
            case EAST: {
                boolean[] blArray5 = new boolean[6];
                blArray5[0] = south;
                blArray5[1] = north;
                blArray5[2] = up;
                blArray5[3] = east;
                blArray5[4] = down;
                blArray = blArray5;
                blArray5[5] = west;
                break;
            }
            case SOUTH: {
                boolean[] blArray6 = new boolean[6];
                blArray6[0] = east;
                blArray6[1] = west;
                blArray6[2] = north;
                blArray6[3] = down;
                blArray6[4] = south;
                blArray = blArray6;
                blArray6[5] = up;
                break;
            }
            case WEST: {
                boolean[] blArray7 = new boolean[6];
                blArray7[0] = north;
                blArray7[1] = south;
                blArray7[2] = down;
                blArray7[3] = east;
                blArray7[4] = up;
                blArray = blArray7;
                blArray7[5] = west;
            }
        }
        return blArray;
    }

    public static List<Direction> legacyRotation(int rotation) {
        ArrayList<Direction> rotations = new ArrayList<Direction>();
        if (rotation < 4) {
            for (int i = 0; i < rotation; ++i) {
                rotations.add(Direction.UP);
            }
        } else if (rotation < 8) {
            rotations.add(Direction.WEST);
            for (int i = 4; i < rotation; ++i) {
                rotations.add(Direction.NORTH);
            }
        } else {
            rotations.add(Direction.NORTH);
            rotations.add(Direction.NORTH);
            rotations.add(Direction.WEST);
            for (int i = 8; i < rotation; ++i) {
                rotations.add(Direction.SOUTH);
            }
        }
        return rotations;
    }

    public static boolean isCuboid(Vec3 NWU, Vec3 NEU, Vec3 SWU, Vec3 SEU, Vec3 NWD, Vec3 NED, Vec3 SWD, Vec3 SED) {
        boolean xlEqual = NWU.f_82479_ == SWU.f_82479_ && SWU.f_82479_ == NWD.f_82479_ && NWD.f_82479_ == SWD.f_82479_;
        boolean xhEqual = NEU.f_82479_ == SEU.f_82479_ && SEU.f_82479_ == NED.f_82479_ && NED.f_82479_ == SED.f_82479_;
        boolean ylEqual = NWD.f_82480_ == NED.f_82480_ && NED.f_82480_ == SWD.f_82480_ && SWD.f_82480_ == SED.f_82480_;
        boolean yhEqual = NWU.f_82480_ == NEU.f_82480_ && NEU.f_82480_ == SWU.f_82480_ && SWU.f_82480_ == SEU.f_82480_;
        boolean zlEqual = NWU.f_82481_ == NEU.f_82481_ && NEU.f_82481_ == NWD.f_82481_ && NWD.f_82481_ == NED.f_82481_;
        boolean zhEqual = SWU.f_82481_ == SEU.f_82481_ && SEU.f_82481_ == SWD.f_82481_ && SWD.f_82481_ == SED.f_82481_;
        return xlEqual && xhEqual && ylEqual && yhEqual && zlEqual && zhEqual;
    }
}

