/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.pianomanu.blockcarpentry.bakedmodels.ModelInformation;
import mod.pianomanu.blockcarpentry.bakedmodels.QuadUtils;
import mod.pianomanu.blockcarpentry.util.CornerUtils;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public class ModelHelper {
    public static Float[] checkWithinBounds(Float xl, Float xh, Float yl, Float yh, Float zl, Float zh) {
        Float f;
        if (xh.floatValue() - xl.floatValue() > 1.0f || yh.floatValue() - yl.floatValue() > 1.0f || zh.floatValue() - zl.floatValue() > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.blockcarpentry.block_error"), true);
            }
            return null;
        }
        if (xl.floatValue() < 0.0f) {
            f = xl;
            xl = Float.valueOf(xl.floatValue() + 1.0f);
            f = xh;
            xh = Float.valueOf(xh.floatValue() + 1.0f);
        }
        if (xh.floatValue() > 1.0f) {
            f = xh;
            xh = Float.valueOf(xh.floatValue() - 1.0f);
            f = xl;
            xl = Float.valueOf(xl.floatValue() - 1.0f);
        }
        if (yl.floatValue() < 0.0f) {
            f = yl;
            yl = Float.valueOf(yl.floatValue() + 1.0f);
            f = yh;
            yh = Float.valueOf(yh.floatValue() + 1.0f);
        }
        if (yh.floatValue() > 1.0f) {
            f = yh;
            yh = Float.valueOf(yh.floatValue() - 1.0f);
            f = yl;
            yl = Float.valueOf(yl.floatValue() - 1.0f);
        }
        if (zl.floatValue() < 0.0f) {
            f = zl;
            zl = Float.valueOf(zl.floatValue() + 1.0f);
            f = zh;
            zh = Float.valueOf(zh.floatValue() + 1.0f);
        }
        if (zh.floatValue() > 1.0f) {
            f = zh;
            zh = Float.valueOf(zh.floatValue() - 1.0f);
            f = zl;
            zl = Float.valueOf(zl.floatValue() - 1.0f);
        }
        return new Float[]{xl, xh, yl, yh, zl, zh};
    }

    private static Vec3[] convertFloatsToVec(float xl, float xh, float yl, float yh, float zl, float zh) {
        Vec3 NWU = ModelHelper.v(xl, yh, zl);
        Vec3 SWU = ModelHelper.v(xl, yh, zh);
        Vec3 NWD = ModelHelper.v(xl, yl, zl);
        Vec3 SWD = ModelHelper.v(xl, yl, zh);
        Vec3 NEU = ModelHelper.v(xh, yh, zl);
        Vec3 SEU = ModelHelper.v(xh, yh, zh);
        Vec3 NED = ModelHelper.v(xh, yl, zl);
        Vec3 SED = ModelHelper.v(xh, yl, zh);
        return new Vec3[]{NWU, SWU, NWD, SWD, NEU, SEU, NED, SED};
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex) {
        return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, texture, tintIndex, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], texture, tintIndex, north, south, east, west, up, down);
    }

    public static List<BakedQuad> createCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, boolean keepDefaultUV016) {
        return ModelHelper.createCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, texture, tintIndex, north, south, east, west, up, down, keepDefaultUV016, 0, true);
    }

    public static List<BakedQuad> createCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, boolean keepDefaultUV016, int overlayIndex, boolean doNotMoveOverlay) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf((float)NWD.f_82479_), Float.valueOf((float)SEU.f_82479_), Float.valueOf((float)NWD.f_82480_), Float.valueOf((float)SEU.f_82480_), Float.valueOf((float)NWD.f_82481_), Float.valueOf((float)SEU.f_82481_));
        if (floats == null) {
            return ModelHelper.createCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, TextureHelper.getMissingTexture());
        }
        Float xl = floats[0];
        Float xh = floats[1];
        Float yl = floats[2];
        Float yh = floats[3];
        Float zl = floats[4];
        Float zh = floats[5];
        if (keepDefaultUV016) {
            if (up) {
                quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, texture, tintIndex));
            }
            if (down) {
                quads.add(QuadUtils.createQuad(NED, SED, SWD, NWD, texture, tintIndex));
            }
            if (west) {
                quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, tintIndex));
            }
            if (east) {
                quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, tintIndex));
            }
            if (north) {
                quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, tintIndex));
            }
            if (south) {
                quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, tintIndex));
            }
        } else {
            if (up) {
                quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, texture, xl.floatValue() * 16.0f, xh.floatValue() * 16.0f, zl.floatValue() * 16.0f, zh.floatValue() * 16.0f, tintIndex));
            }
            if (down) {
                quads.add(QuadUtils.createQuad(NED, SED, SWD, NWD, texture, xh.floatValue() * 16.0f, xl.floatValue() * 16.0f, 16.0f - zl.floatValue() * 16.0f, 16.0f - zh.floatValue() * 16.0f, tintIndex));
            }
            if (west) {
                quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, zl.floatValue() * 16.0f, zh.floatValue() * 16.0f, 16.0f - yh.floatValue() * 16.0f, 16.0f - yl.floatValue() * 16.0f, tintIndex));
            }
            if (east) {
                quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 16.0f - zh.floatValue() * 16.0f, 16.0f - zl.floatValue() * 16.0f, 16.0f - yh.floatValue() * 16.0f, 16.0f - yl.floatValue() * 16.0f, tintIndex));
            }
            if (north) {
                quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 16.0f - xh.floatValue() * 16.0f, 16.0f - xl.floatValue() * 16.0f, 16.0f - yh.floatValue() * 16.0f, 16.0f - yl.floatValue() * 16.0f, tintIndex));
            }
            if (south) {
                quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, xl.floatValue() * 16.0f, xh.floatValue() * 16.0f, 16.0f - yh.floatValue() * 16.0f, 16.0f - yl.floatValue() * 16.0f, tintIndex));
            }
        }
        if (overlayIndex != 0) {
            quads.addAll(ModelHelper.createOverlay(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, overlayIndex));
        }
        return quads;
    }

    public static List<BakedQuad> createCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite texture) {
        return ModelHelper.createCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, texture, -1, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        return ModelHelper.createCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, texture, tintIndex, north, south, east, west, up, down, false);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, int rotation) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, mimic, model, extraData, rand, tintIndex, true, true, true, true, true, true, rotation);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, List<Direction> directions, List<Integer> rotations) {
        return ModelHelper.createSixFaceCuboid(xl, xh, yl, yh, zl, zh, mimic, model, extraData, rand, tintIndex, true, true, true, true, true, true, directions, rotations);
    }

    public static List<BakedQuad> createSixFaceCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, List<Direction> directions, List<Integer> rotations, boolean keepUV, boolean invert) {
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf((float)NWD.f_82479_), Float.valueOf((float)SEU.f_82479_), Float.valueOf((float)NWD.f_82480_), Float.valueOf((float)SEU.f_82480_), Float.valueOf((float)NWD.f_82481_), Float.valueOf((float)SEU.f_82481_));
        if (floats == null) {
            return ModelHelper.createCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, TextureHelper.getMissingTexture());
        }
        TextureAtlasSprite textureNorth = TextureHelper.getTexture(model, extraData, rand, Direction.NORTH);
        TextureAtlasSprite textureEast = TextureHelper.getTexture(model, extraData, rand, Direction.EAST);
        TextureAtlasSprite textureSouth = TextureHelper.getTexture(model, extraData, rand, Direction.SOUTH);
        TextureAtlasSprite textureWest = TextureHelper.getTexture(model, extraData, rand, Direction.WEST);
        TextureAtlasSprite textureUp = TextureHelper.getTexture(model, extraData, rand, Direction.UP);
        TextureAtlasSprite textureDown = TextureHelper.getTexture(model, extraData, rand, Direction.DOWN);
        return ModelHelper.createSixFaceCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, tintIndex, true, true, true, true, true, true, directions, rotations, keepUV, invert);
    }

    public static List<BakedQuad> createSixFaceCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, List<Direction> directions, List<Integer> rotations, boolean keepUV, boolean invert) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Direction newUp = Direction.UP;
        Direction newDown = Direction.DOWN;
        Direction newNorth = Direction.NORTH;
        Direction newEast = Direction.EAST;
        Direction newSouth = Direction.SOUTH;
        Direction newWest = Direction.WEST;
        int upRotation = rotations.size() == 6 ? rotations.get(1) : 0;
        int downRotation = rotations.size() == 6 ? rotations.get(0) : 0;
        int westRotation = rotations.size() == 6 ? rotations.get(4) : 0;
        int eastRotation = rotations.size() == 6 ? rotations.get(5) : 0;
        int northRotation = rotations.size() == 6 ? rotations.get(2) : 0;
        int southRotation = rotations.size() == 6 ? rotations.get(3) : 0;
        for (Direction d : directions) {
            Vec3[] rotatedVecs = CornerUtils.rotateVec3s(NWU, NEU, SWU, SEU, NWD, NED, SWD, SED, d);
            Direction[] rotatedDirs = CornerUtils.getRotatedDirection(newUp, newDown, newNorth, newEast, newSouth, newWest, d);
            boolean[] rotatedVisibility = CornerUtils.getRotatedVisibility(up, down, north, east, south, west, d);
            NWU = rotatedVecs[0];
            NEU = rotatedVecs[1];
            SWU = rotatedVecs[2];
            SEU = rotatedVecs[3];
            NWD = rotatedVecs[4];
            NED = rotatedVecs[5];
            SWD = rotatedVecs[6];
            SED = rotatedVecs[7];
            newUp = rotatedDirs[0];
            newDown = rotatedDirs[1];
            newNorth = rotatedDirs[2];
            newEast = rotatedDirs[3];
            newSouth = rotatedDirs[4];
            newWest = rotatedDirs[5];
            up = rotatedVisibility[0];
            down = rotatedVisibility[1];
            north = rotatedVisibility[2];
            east = rotatedVisibility[3];
            south = rotatedVisibility[4];
            west = rotatedVisibility[5];
        }
        if (keepUV) {
            if (up) {
                quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, textureUp, tintIndex, upRotation));
            }
            if (down) {
                quads.add(QuadUtils.createQuad(SWD, NWD, NED, SED, textureDown, tintIndex, downRotation));
            }
            if (west) {
                quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, textureWest, tintIndex, westRotation));
            }
            if (east) {
                quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, textureEast, tintIndex, eastRotation));
            }
            if (north) {
                quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, textureNorth, tintIndex, northRotation));
            }
            if (south) {
                quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, textureSouth, tintIndex, southRotation));
            }
        } else {
            float[] uvs;
            if (up) {
                uvs = QuadUtils.rotateUVcomplex(NWU, SWU, SEU, NEU, newUp, upRotation);
                quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, textureUp, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
            if (down) {
                uvs = QuadUtils.rotateUVcomplex(SWD, NWD, NED, SED, newDown, downRotation);
                quads.add(QuadUtils.createQuad(SWD, NWD, NED, SED, textureDown, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
            if (west) {
                uvs = QuadUtils.rotateUVcomplex(NWU, NWD, SWD, SWU, newWest, westRotation);
                quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, textureWest, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
            if (east) {
                uvs = QuadUtils.rotateUVcomplex(SEU, SED, NED, NEU, newEast, eastRotation);
                quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, textureEast, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
            if (north) {
                uvs = QuadUtils.rotateUVcomplex(NEU, NED, NWD, NWU, newNorth, northRotation);
                quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, textureNorth, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
            if (south) {
                uvs = QuadUtils.rotateUVcomplex(SWU, SWD, SED, SEU, newSouth, southRotation);
                quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, textureSouth, uvs[0], uvs[1], uvs[2], uvs[3], uvs[4], uvs[5], uvs[6], uvs[7], tintIndex, invert, 0));
            }
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, List<Direction> directions, List<Integer> rotations) {
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf(xl), Float.valueOf(xh), Float.valueOf(yl), Float.valueOf(yh), Float.valueOf(zl), Float.valueOf(zh));
        if (floats == null) {
            return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, TextureHelper.getMissingTexture(), -1);
        }
        xl = floats[0].floatValue();
        xh = floats[1].floatValue();
        yl = floats[2].floatValue();
        yh = floats[3].floatValue();
        zl = floats[4].floatValue();
        zh = floats[5].floatValue();
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createSixFaceCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], mimic, model, extraData, rand, tintIndex, north, south, east, west, up, down, directions, rotations, false, false);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int rotation) {
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf(xl), Float.valueOf(xh), Float.valueOf(yl), Float.valueOf(yh), Float.valueOf(zl), Float.valueOf(zh));
        if (floats == null) {
            return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, TextureHelper.getMissingTexture(), -1);
        }
        xl = floats[0].floatValue();
        xh = floats[1].floatValue();
        yl = floats[2].floatValue();
        yh = floats[3].floatValue();
        zl = floats[4].floatValue();
        zh = floats[5].floatValue();
        TextureAtlasSprite textureNorth = TextureHelper.getTexture(model, extraData, rand, Direction.NORTH);
        TextureAtlasSprite textureEast = TextureHelper.getTexture(model, extraData, rand, Direction.EAST);
        TextureAtlasSprite textureSouth = TextureHelper.getTexture(model, extraData, rand, Direction.SOUTH);
        TextureAtlasSprite textureWest = TextureHelper.getTexture(model, extraData, rand, Direction.WEST);
        TextureAtlasSprite textureUp = TextureHelper.getTexture(model, extraData, rand, Direction.UP);
        TextureAtlasSprite textureDown = TextureHelper.getTexture(model, extraData, rand, Direction.DOWN);
        List<Direction> directions = CornerUtils.legacyRotation(rotation);
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createSixFaceCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, tintIndex, north, south, east, west, up, down, directions, Collections.emptyList(), false, false);
    }

    public static List<BakedQuad> createSixFaceVoxel(float x, float y, float z, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int rotation) {
        return ModelHelper.createSixFaceCuboid(x / 16.0f, (x + 1.0f) / 16.0f, y / 16.0f, (y + 1.0f) / 16.0f, z / 16.0f, (z + 1.0f) / 16.0f, mimic, model, extraData, rand, tintIndex, north, south, east, west, up, down, rotation);
    }

    public static List<BakedQuad> createSixFaceVoxel(float x, float y, float z, BlockState mimic, BakedModel model, IModelData extraData, Random rand, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, List<Direction> direction, List<Integer> rotations) {
        return ModelHelper.createSixFaceCuboid(x / 16.0f, (x + 1.0f) / 16.0f, y / 16.0f, (y + 1.0f) / 16.0f, z / 16.0f, (z + 1.0f) / 16.0f, mimic, model, extraData, rand, tintIndex, north, south, east, west, up, down, direction, rotations);
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, int tintIndex, TextureAtlasSprite textureNorth, TextureAtlasSprite textureSouth, TextureAtlasSprite textureEast, TextureAtlasSprite textureWest, TextureAtlasSprite textureUp, TextureAtlasSprite textureDown, int rotation) {
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf(xl), Float.valueOf(xh), Float.valueOf(yl), Float.valueOf(yh), Float.valueOf(zl), Float.valueOf(zh));
        if (floats == null) {
            return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, TextureHelper.getMissingTexture(), -1);
        }
        xl = floats[0].floatValue();
        xh = floats[1].floatValue();
        yl = floats[2].floatValue();
        yh = floats[3].floatValue();
        zl = floats[4].floatValue();
        zh = floats[5].floatValue();
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createSixFaceCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], textureNorth, textureSouth, textureEast, textureWest, textureUp, textureDown, tintIndex, true, true, true, true, true, true, CornerUtils.legacyRotation(rotation), Collections.emptyList(), true, false);
    }

    public static List<BakedQuad> createSixFaceCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, ModelInformation m, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, boolean moveOverlay, boolean keepUV) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        TextureAtlasSprite textureUp = m.upTexture;
        TextureAtlasSprite textureDown = m.downTexture;
        TextureAtlasSprite textureNorth = m.northTexture;
        TextureAtlasSprite textureEast = m.eastTexture;
        TextureAtlasSprite textureSouth = m.southTexture;
        TextureAtlasSprite textureWest = m.westTexture;
        if (up && textureUp != null) {
            quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, textureUp, Direction.UP, m.tintIndex, 0, keepUV, false));
        }
        if (down && textureDown != null) {
            quads.add(QuadUtils.createQuad(NED, SED, SWD, NWD, textureDown, Direction.DOWN, m.tintIndex, 0, keepUV, false));
        }
        if (west && textureWest != null) {
            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, textureWest, Direction.WEST, m.tintIndex, 0, keepUV, false, false));
        }
        if (east && textureEast != null) {
            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, textureEast, Direction.EAST, m.tintIndex, 0, keepUV, false, false));
        }
        if (north && textureNorth != null) {
            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, textureNorth, Direction.NORTH, m.tintIndex, 0, keepUV, false, false));
        }
        if (south && textureSouth != null) {
            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, textureSouth, Direction.SOUTH, m.tintIndex, 0, keepUV, false, false));
        }
        return quads;
    }

    public static List<BakedQuad> createSixFaceCuboid(float xl, float xh, float yl, float yh, float zl, float zh, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, ModelInformation m, Boolean moveOverlay, int rotation) {
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf(xl), Float.valueOf(xh), Float.valueOf(yl), Float.valueOf(yh), Float.valueOf(zl), Float.valueOf(zh));
        if (floats == null) {
            return ModelHelper.createCuboid(xl, xh, yl, yh, zl, zh, TextureHelper.getMissingTexture(), -1);
        }
        Vec3[] vecs = ModelHelper.convertFloatsToVec(floats[0].floatValue(), floats[1].floatValue(), floats[2].floatValue(), floats[3].floatValue(), floats[4].floatValue(), floats[5].floatValue());
        return ModelHelper.createSixFaceCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], m, north, south, east, west, up, down, moveOverlay, true);
    }

    public static List<BakedQuad> createCuboid(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], texture, tintIndex, true, true, true, true, true, true, ulow, uhigh, vlow, vhigh);
    }

    public static List<BakedQuad> createCuboid(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, int[] ulow, int[] uhigh, int[] vlow, int[] vhigh) {
        if (ulow.length != 6 || uhigh.length != 6 || vlow.length != 6 || vhigh.length != 6) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (up) {
            quads.add(QuadUtils.createQuad(NWU, NEU, SEU, SWU, texture, ulow[0], (float)uhigh[0], (float)vlow[0], vhigh[0], tintIndex));
        }
        if (down) {
            quads.add(QuadUtils.createQuad(NED, NWD, SWD, SED, texture, ulow[1], (float)uhigh[1], (float)vlow[1], vhigh[1], tintIndex));
        }
        if (north) {
            quads.add(QuadUtils.createQuad(NWU, NWD, NED, NEU, texture, ulow[2], (float)uhigh[2], (float)vlow[2], vhigh[2], tintIndex));
        }
        if (east) {
            quads.add(QuadUtils.createQuad(NEU, NED, SED, SEU, texture, ulow[3], (float)uhigh[3], (float)vlow[3], vhigh[3], tintIndex));
        }
        if (south) {
            quads.add(QuadUtils.createQuad(SEU, SED, SWD, SWU, texture, ulow[4], (float)uhigh[4], (float)vlow[4], vhigh[4], tintIndex));
        }
        if (west) {
            quads.add(QuadUtils.createQuad(SWU, SWD, NWD, NWU, texture, ulow[5], (float)uhigh[5], (float)vlow[5], vhigh[5], tintIndex));
        }
        return quads;
    }

    public static List<BakedQuad> createVoxel(int x, int y, int z, TextureAtlasSprite texture, int tintIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down) {
        return ModelHelper.createCuboid((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, texture, tintIndex, north, south, east, west, up, down);
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    public static List<BakedQuad> createOverlayVoxel(int x, int y, int z, int overlayIndex) {
        return ModelHelper.createOverlay((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, overlayIndex);
    }

    public static List<BakedQuad> createOverlayVoxel(int x, int y, int z, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        return ModelHelper.createOverlay((float)x / 16.0f, (float)(x + 1) / 16.0f, (float)y / 16.0f, (float)(y + 1) / 16.0f, (float)z / 16.0f, (float)(z + 1) / 16.0f, overlayIndex, north, south, east, west, up, down, doNotMoveOverlay);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex) {
        return ModelHelper.createOverlay(xl, xh, yl, yh, zl, zh, overlayIndex, true, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createOverlay(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, int overlayIndex) {
        return ModelHelper.createOverlay(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, overlayIndex, true, true, true, true, true, true, true);
    }

    public static List<BakedQuad> createOverlay(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        ModelInformation m = TextureHelper.getOverlayModelInformation(overlayIndex);
        return ModelHelper.createSixFaceCuboid(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED, m, north, south, east, west, up, down, doNotMoveOverlay == false, false);
    }

    public static List<BakedQuad> createOverlay(float xl, float xh, float yl, float yh, float zl, float zh, int overlayIndex, boolean north, boolean south, boolean east, boolean west, boolean up, boolean down, Boolean doNotMoveOverlay) {
        ModelInformation m = TextureHelper.getOverlayModelInformation(overlayIndex);
        Vec3[] vecs = ModelHelper.convertFloatsToVec(xl, xh, yl, yh, zl, zh);
        return ModelHelper.createSixFaceCuboid(vecs[0], vecs[1], vecs[2], vecs[3], vecs[4], vecs[5], vecs[6], vecs[7], m, north, south, east, west, up, down, doNotMoveOverlay == false, false);
    }

    private static float meanUV(double uv1, double uv2) {
        return (float)(uv1 + uv2) * 16.0f / 2.0f;
    }
}

