/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.pianomanu.blockcarpentry.bakedmodels.ModelInformation;
import mod.pianomanu.blockcarpentry.bakedmodels.QuadUtils;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.CornerUtils;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public class SimpleBox {
    private Vec3 NWU;
    private Vec3 NWD;
    private Vec3 NEU;
    private Vec3 NED;
    private Vec3 SWU;
    private Vec3 SWD;
    private Vec3 SEU;
    private Vec3 SED;
    private final IModelData extraData;
    private final BakedModel model;
    private final Random rand;
    private final TextureAtlasSprite sprite;
    private final boolean renderUp;
    private final boolean renderDown;
    private final boolean renderNorth;
    private final boolean renderEast;
    private final boolean renderSouth;
    private final boolean renderWest;
    private Direction newUp = Direction.UP;
    private Direction newDown = Direction.DOWN;
    private Direction newNorth = Direction.NORTH;
    private Direction newEast = Direction.EAST;
    private Direction newSouth = Direction.SOUTH;
    private Direction newWest = Direction.WEST;
    boolean invertUp = false;
    boolean invertDown = false;
    boolean invertWest = false;
    boolean invertEast = false;
    boolean invertNorth = false;
    boolean invertSouth = false;
    private final List<Direction> directions;
    private final List<Integer> rotations;
    private final int tintIndex;
    private final boolean keepDefaultUV;
    private int overlayIndex;
    private ModelInformation modelInformation;
    private boolean doNotMoveOverlay;

    public static SimpleBox create(IModelData extraData, BakedModel model, Random rand) {
        Vec3 NWU = new Vec3(0.0, 1.0, 0.0);
        Vec3 NWD = new Vec3(0.0, 0.0, 0.0);
        Vec3 NEU = new Vec3(1.0, 1.0, 0.0);
        Vec3 NED = new Vec3(1.0, 0.0, 0.0);
        Vec3 SWU = new Vec3(0.0, 1.0, 1.0);
        Vec3 SWD = new Vec3(0.0, 0.0, 1.0);
        Vec3 SEU = new Vec3(1.0, 1.0, 1.0);
        Vec3 SED = new Vec3(1.0, 0.0, 1.0);
        return SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand);
    }

    public static SimpleBox create(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand) {
        TextureAtlasSprite sprite = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
        return SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, sprite, -1);
    }

    public static SimpleBox create(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand, TextureAtlasSprite sprite, int tintIndex) {
        return SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, sprite, Collections.emptyList(), Collections.emptyList(), tintIndex, true);
    }

    public static SimpleBox create(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand, TextureAtlasSprite sprite, List<Direction> directions, List<Integer> rotations, int tintIndex, boolean keepDefaultUV) {
        return SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, sprite, true, true, true, true, true, true, directions, rotations, tintIndex, keepDefaultUV);
    }

    public static SimpleBox create(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand, TextureAtlasSprite sprite, boolean renderUp, boolean renderDown, boolean renderNorth, boolean renderEast, boolean renderSouth, boolean renderWest, List<Direction> directions, List<Integer> rotations, int tintIndex, boolean keepDefaultUV) {
        return SimpleBox.create(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, sprite, renderUp, renderDown, renderNorth, renderEast, renderSouth, renderWest, directions, rotations, tintIndex, keepDefaultUV, 0, false);
    }

    public static SimpleBox create(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand, TextureAtlasSprite sprite, boolean renderUp, boolean renderDown, boolean renderNorth, boolean renderEast, boolean renderSouth, boolean renderWest, List<Direction> directions, List<Integer> rotations, int tintIndex, boolean keepDefaultUV, int overlayIndex, boolean doNotMoveOverlay) {
        return new SimpleBox(NWU, NWD, NEU, NED, SWU, SWD, SEU, SED, extraData, model, rand, sprite, renderUp, renderDown, renderNorth, renderEast, renderSouth, renderWest, directions, rotations, tintIndex, keepDefaultUV, overlayIndex, doNotMoveOverlay);
    }

    private SimpleBox(Vec3 NWU, Vec3 NWD, Vec3 NEU, Vec3 NED, Vec3 SWU, Vec3 SWD, Vec3 SEU, Vec3 SED, IModelData extraData, BakedModel model, Random rand, TextureAtlasSprite sprite, boolean renderUp, boolean renderDown, boolean renderNorth, boolean renderEast, boolean renderSouth, boolean renderWest, List<Direction> directions, List<Integer> rotations, int tintIndex, boolean keepDefaultUV, int overlayIndex, boolean doNotMoveOverlay) {
        this.NWU = NWU;
        this.NWD = NWD;
        this.NEU = NEU;
        this.NED = NED;
        this.SWU = SWU;
        this.SWD = SWD;
        this.SEU = SEU;
        this.SED = SED;
        this.extraData = extraData;
        this.model = model;
        this.rand = rand;
        this.sprite = sprite;
        this.renderUp = renderUp;
        this.renderDown = renderDown;
        this.renderNorth = renderNorth;
        this.renderEast = renderEast;
        this.renderSouth = renderSouth;
        this.renderWest = renderWest;
        this.directions = directions;
        this.rotations = rotations;
        this.tintIndex = tintIndex;
        this.keepDefaultUV = keepDefaultUV;
        this.doNotMoveOverlay = doNotMoveOverlay;
        this.updateOverlay();
    }

    private void updateOverlay() {
        this.overlayIndex = (Integer)this.extraData.getData(FrameBlockTile.OVERLAY);
        this.modelInformation = TextureHelper.getOverlayModelInformation(this.overlayIndex);
    }

    public List<BakedQuad> getQuads() {
        boolean useSimpleQuadCalc;
        this.updateOverlay();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Float[] floats = ModelHelper.checkWithinBounds(Float.valueOf((float)this.NWD.f_82479_), Float.valueOf((float)this.SEU.f_82479_), Float.valueOf((float)this.NWD.f_82480_), Float.valueOf((float)this.SEU.f_82480_), Float.valueOf((float)this.NWD.f_82481_), Float.valueOf((float)this.SEU.f_82481_));
        if (floats == null) {
            return this.createQuadsEmpty();
        }
        this.rotate();
        int upRotation = this.rotations.size() == 6 ? this.rotations.get(1) : 0;
        int downRotation = this.rotations.size() == 6 ? this.rotations.get(0) : 0;
        int westRotation = this.rotations.size() == 6 ? this.rotations.get(4) : 0;
        int eastRotation = this.rotations.size() == 6 ? this.rotations.get(5) : 0;
        int northRotation = this.rotations.size() == 6 ? this.rotations.get(2) : 0;
        int southRotation = this.rotations.size() == 6 ? this.rotations.get(3) : 0;
        boolean bl = useSimpleQuadCalc = CornerUtils.isCuboid(this.NWU, this.NEU, this.SWU, this.SEU, this.NWD, this.NED, this.SWD, this.SED) || (Boolean)BCModConfig.USE_COMPLEX_QUAD_CALCULATIONS.get() == false || Boolean.TRUE.equals(this.extraData.getData(FrameBlockTile.REMAIN_RECTANGLE));
        if (this.renderUp) {
            this.createQuadFace(quads, this.NWU, this.SWU, this.SEU, this.NEU, Direction.UP, this.newUp, upRotation, this.invertUp, useSimpleQuadCalc);
        }
        if (this.renderDown) {
            this.createQuadFace(quads, this.NED, this.SED, this.SWD, this.NWD, Direction.DOWN, this.newDown, downRotation, this.invertDown, useSimpleQuadCalc);
        }
        if (this.renderWest) {
            this.createQuadFace(quads, this.NWU, this.NWD, this.SWD, this.SWU, Direction.WEST, this.newWest, westRotation, this.invertWest, useSimpleQuadCalc);
        }
        if (this.renderEast) {
            this.createQuadFace(quads, this.SEU, this.SED, this.NED, this.NEU, Direction.EAST, this.newEast, eastRotation, this.invertEast, useSimpleQuadCalc);
        }
        if (this.renderNorth) {
            this.createQuadFace(quads, this.NEU, this.NED, this.NWD, this.NWU, Direction.NORTH, this.newNorth, northRotation, this.invertNorth, useSimpleQuadCalc);
        }
        if (this.renderSouth) {
            this.createQuadFace(quads, this.SWU, this.SWD, this.SED, this.SEU, Direction.SOUTH, this.newSouth, southRotation, this.invertSouth, useSimpleQuadCalc);
        }
        return quads;
    }

    private void rotate() {
        for (Direction d : this.directions) {
            Vec3[] rotatedVecs = CornerUtils.rotateVec3s(this.NWU, this.NEU, this.SWU, this.SEU, this.NWD, this.NED, this.SWD, this.SED, d);
            Direction[] rotatedDirs = CornerUtils.getRotatedDirection(this.newUp, this.newDown, this.newNorth, this.newEast, this.newSouth, this.newWest, d);
            this.NWU = rotatedVecs[0];
            this.NEU = rotatedVecs[1];
            this.SWU = rotatedVecs[2];
            this.SEU = rotatedVecs[3];
            this.NWD = rotatedVecs[4];
            this.NED = rotatedVecs[5];
            this.SWD = rotatedVecs[6];
            this.SED = rotatedVecs[7];
            this.newUp = rotatedDirs[0];
            this.newDown = rotatedDirs[1];
            this.newNorth = rotatedDirs[2];
            this.newEast = rotatedDirs[3];
            this.newSouth = rotatedDirs[4];
            this.newWest = rotatedDirs[5];
        }
    }

    private List<BakedQuad> createQuadsEmpty() {
        return ModelHelper.createCuboid(this.NWU, this.SWU, this.NWD, this.SWD, this.NEU, this.SEU, this.NED, this.SED, TextureHelper.getMissingTexture());
    }

    private void createQuadFace(List<BakedQuad> quads, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Direction originalDirection, Direction newDirection, int rotation, boolean invert, boolean useSimpleQuadCalculation) {
        if (useSimpleQuadCalculation) {
            quads.add(QuadUtils.createQuad(v1, v2, v3, v4, this.sprite, newDirection, this.tintIndex, rotation, this.keepDefaultUV, invert));
            if (this.overlayIndex > 0 && this.overlayTexture(originalDirection) != null) {
                quads.add(QuadUtils.createQuad(v1, v2, v3, v4, this.overlayTexture(originalDirection), originalDirection, this.modelInformation.tintIndex, 0, this.doNotMoveOverlay, false));
            }
        } else {
            quads.addAll(QuadUtils.createQuadComplex(v1, v2, v3, v4, this.sprite, newDirection, this.tintIndex, rotation, this.keepDefaultUV, invert));
            if (this.overlayIndex > 0 && this.overlayTexture(originalDirection) != null) {
                quads.addAll(QuadUtils.createQuadComplex(v1, v2, v3, v4, this.overlayTexture(originalDirection), originalDirection, this.modelInformation.tintIndex, 0, this.doNotMoveOverlay, false));
            }
        }
    }

    private TextureAtlasSprite overlayTexture(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> this.modelInformation.upTexture;
            case Direction.DOWN -> this.modelInformation.downTexture;
            case Direction.NORTH -> this.modelInformation.northTexture;
            case Direction.EAST -> this.modelInformation.eastTexture;
            case Direction.SOUTH -> this.modelInformation.southTexture;
            case Direction.WEST -> this.modelInformation.westTexture;
        };
    }
}

