/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public abstract boolean doesResourceExist(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void trackToBeGeneratedResource(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void saveResource(ResourceType var1, byte[] var2, String var3, String var4, String var5, String var6);

    public abstract <T> void saveResource(ResourceType var1, ResourceAggregator<?, T> var2, T var3, String var4, String var5, String var6, String var7);

    public void saveJsonResource(ResourceType resourceType, JsonObject json, String namespace, String directory, String fileName) {
        byte[] bytes = GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8);
        this.saveResource(resourceType, bytes, namespace, directory, fileName, fileName.endsWith(".json") ? "" : ".json");
    }

    public abstract Optional<InputStream> getExistingResource(ResourceType var1, String var2, String var3, String var4, String var5);

    @ApiStatus.Internal
    public static ResourceCache wrap(ExistingFileHelper existingFileHelper, HashCache hashCache, Path outputDirectory) {
        return new HashCacheWrapper(existingFileHelper, hashCache, outputDirectory);
    }

    @ApiStatus.Internal
    public static class HashCacheWrapper
    extends ResourceCache {
        private final Map<Path, HashCode> presentFiles = new HashMap<Path, HashCode>();
        private final Map<Path, HashCode> writtenFiles = new HashMap<Path, HashCode>();
        private final Map<Path, Pair<ResourceAggregator<Object, Object>, Object>> aggregatedResources = new HashMap<Path, Pair<ResourceAggregator<Object, Object>, Object>>();
        private final Set<Path> toBeGenerated = new HashSet<Path>();
        private final ExistingFileHelper existingFileHelper;
        private final Path outputDirectory;
        private final HashCache cache;
        private boolean allowWrites = true;

        private HashCacheWrapper(ExistingFileHelper existingFileHelper, HashCache cache, Path outputFolder) {
            if (outputFolder == null) {
                throw new IllegalArgumentException("Output directory must not be null!");
            }
            this.outputDirectory = outputFolder;
            this.existingFileHelper = existingFileHelper;
            this.cache = cache;
            for (Map.Entry entry : this.cache.f_123930_.entrySet()) {
                this.presentFiles.put(this.outputDirectory.relativize((Path)entry.getKey()), ((String)entry.getValue()).isEmpty() ? HashCode.fromInt((int)0) : HashCode.fromString((String)((String)entry.getValue())));
            }
        }

        private boolean existsInGeneratedFiles(Path path) {
            return this.toBeGenerated.contains(path) || this.aggregatedResources.containsKey(path) || this.cache.f_123931_.containsKey(this.outputDirectory.resolve(path));
        }

        private boolean existsInLoadedResources(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            ResourceLocation location = new ResourceLocation(namespace, directory + "/" + fileName + extension);
            return this.existingFileHelper.exists(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES);
        }

        private Path constructPath(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            return Paths.get(resourceType.getDirectoryName(), namespace, directory, fileName + extension);
        }

        @Override
        public boolean doesResourceExist(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            return this.existsInGeneratedFiles(path) || this.existsInLoadedResources(resourceType, namespace, directory, fileName, extension);
        }

        @Override
        public void trackToBeGeneratedResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            this.toBeGenerated.add(this.constructPath(resourceType, namespace, directory, fileName, extension));
            ResourceLocation location = new ResourceLocation(namespace, directory + "/" + fileName + extension);
            this.existingFileHelper.trackGenerated(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES, extension, directory);
        }

        @Override
        public Optional<InputStream> getExistingResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            try {
                Resource resource = this.existingFileHelper.getResource(new ResourceLocation(namespace, directory + "/" + fileName + extension), resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES);
                return Optional.of(resource.m_6679_());
            }
            catch (FileNotFoundException | NoSuchElementException e) {
                return Optional.empty();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void saveResource(ResourceType resourceType, byte[] data, String namespace, String directory, String fileName, String extension) {
            if (!this.allowWrites) {
                throw new RuntimeException("Resources cannot be saved during this stage!");
            }
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            Path fullPath = this.outputDirectory.resolve(path);
            if (this.writtenFiles.containsKey(path) || this.aggregatedResources.containsKey(path) || this.cache.f_123931_.containsKey(fullPath)) {
                throw new RuntimeException("Duplicate file '" + path + "'!");
            }
            HashCode hashCode = Hashing.sha1().hashBytes(data);
            if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                this.writtenFiles.put(path, hashCode);
                this.toBeGenerated.remove(path);
                this.cache.m_123940_(fullPath, hashCode.toString());
                return;
            }
            fullPath.toFile().getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writtenFiles.put(path, hashCode);
            this.toBeGenerated.remove(path);
            this.cache.m_123940_(fullPath, hashCode.toString());
        }

        @Override
        public <T> void saveResource(ResourceType resourceType, ResourceAggregator<?, T> aggregator, T data, String namespace, String directory, String fileName, String extension) {
            if (!this.allowWrites) {
                throw new RuntimeException("Resources cannot be saved during this stage!");
            }
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            Path fullPath = this.outputDirectory.resolve(path);
            if (this.writtenFiles.containsKey(path) || this.cache.f_123931_.containsKey(fullPath)) {
                throw new RuntimeException("Duplicate file '" + path + "'!");
            }
            Pair<ResourceAggregator<Object, Object>, Object> oldEntry = this.aggregatedResources.get(path);
            if (oldEntry != null && oldEntry.left() != aggregator) {
                throw new RuntimeException("Incompatible aggregators for file '" + path + "': '" + oldEntry.left().getClass() + "' and '" + aggregator.getClass() + "'!");
            }
            Object oldData = oldEntry == null ? aggregator.initialData() : oldEntry.right();
            try {
                oldData = aggregator.combine(oldData, data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to combine data for file '" + path + "'!", e);
            }
            this.aggregatedResources.put(path, Pair.of(aggregator, oldData));
        }

        public void allowWrites(boolean allow) {
            this.allowWrites = allow;
        }

        public void finish() {
            this.aggregatedResources.forEach((path, pair) -> {
                byte[] bytes;
                ResourceAggregator aggregator = (ResourceAggregator)pair.left();
                Object data = pair.right();
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    aggregator.write(stream, data);
                    bytes = stream.toByteArray();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Path fullPath = this.outputDirectory.resolve((Path)path);
                HashCode hashCode = Hashing.sha1().hashBytes(bytes);
                if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                    this.writtenFiles.put((Path)path, hashCode);
                    this.toBeGenerated.remove(path);
                    this.cache.m_123940_(fullPath, hashCode.toString());
                    return;
                }
                fullPath.toFile().getParentFile().mkdirs();
                try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.writtenFiles.put((Path)path, hashCode);
                this.toBeGenerated.remove(path);
                this.cache.m_123940_(fullPath, hashCode.toString());
            });
            if (!this.toBeGenerated.isEmpty()) {
                throw new RuntimeException("Some tracked files did not get written: " + this.toBeGenerated.stream().map(Path::toString).map(s -> "'" + s + "'").collect(Collectors.joining(",")));
            }
        }
    }
}

