/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class TagGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ResourceAggregator<TagBuilder<?>, TagBuilder<?>> AGGREGATOR = new ResourceAggregator<TagBuilder<?>, TagBuilder<?>>(){

        @Override
        public TagBuilder<?> initialData() {
            return null;
        }

        @Override
        public TagBuilder<?> combine(TagBuilder<?> data, TagBuilder<?> newData) {
            if (data != null) {
                data.addAll(newData);
                return data;
            }
            return newData;
        }

        @Override
        public void write(OutputStream stream, TagBuilder<?> tag) throws IOException {
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(tag.replace));
            JsonArray entries = new JsonArray();
            tag.entries.forEach(entry -> entry.m_6383_(entries));
            if (!entries.isEmpty() || tag.remove.isEmpty()) {
                json.add("values", (JsonElement)entries);
            }
            JsonArray removedEntries = new JsonArray();
            tag.remove.forEach(entry -> entry.m_6383_(removedEntries));
            if (!removedEntries.isEmpty()) {
                json.add("remove", (JsonElement)removedEntries);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
    };
    private final Map<Registries.Registry<?>, Map<ResourceLocation, TagBuilder<?>>> tags = new HashMap();

    public TagGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<Registries.Registry<?>, Map<ResourceLocation, TagBuilder<?>>> registryEntry : this.tags.entrySet()) {
            String directoryName = TagGenerator.getTagDirectoryName(registryEntry.getKey());
            for (TagBuilder<?> tag : registryEntry.getValue().values()) {
                for (Tag.Entry entry : tag.entries) {
                    if (!(entry instanceof Tag.TagEntry)) continue;
                    ResourceLocation reference = ((Tag.TagEntry)entry).getId();
                    if (registryEntry.getValue().containsKey(reference) || this.cache.doesResourceExist(ResourceType.DATA, reference.m_135827_(), directoryName, reference.m_135815_(), ".json")) continue;
                    throw new RuntimeException("Could not find tag reference '" + reference + "' in '" + tag.identifier + "'!");
                }
                ResourceLocation identifier = tag.identifier;
                this.cache.saveResource(ResourceType.DATA, AGGREGATOR, tag, identifier.m_135827_(), directoryName, identifier.m_135815_(), ".json");
            }
        }
    }

    private static String getTagDirectoryName(Registries.Registry<?> registry) {
        return TagManager.m_203918_((ResourceKey)(registry.hasForgeRegistry() ? registry.getForgeRegistry().getRegistryKey() : registry.getVanillaRegistry().m_123023_()));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, ResourceLocation identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.m_135827_(), TagGenerator.getTagDirectoryName(registry), identifier.m_135815_(), ".json");
        return this.tags.computeIfAbsent(registry, o -> new HashMap()).computeIfAbsent(identifier, identifier1 -> new TagBuilder(registry, (ResourceLocation)identifier1));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, TagKey<T> tagKey) {
        return this.tag(registry, tagKey.f_203868_());
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String namespace, String identifier) {
        return this.tag(registry, new ResourceLocation(namespace, identifier));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String identifier) {
        return this.tag(registry, this.modid, identifier);
    }

    protected TagBuilder<Block> blockTag(ResourceLocation identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Block> blockTag(TagKey<Block> tagKey) {
        return this.tag(Registries.BLOCKS, tagKey);
    }

    protected TagBuilder<Block> blockTag(String namespace, String identifier) {
        return this.tag(Registries.BLOCKS, namespace, identifier);
    }

    protected TagBuilder<Block> blockTag(String identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Item> itemTag(ResourceLocation identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<Item> itemTag(TagKey<Item> tagKey) {
        return this.tag(Registries.ITEMS, tagKey);
    }

    protected TagBuilder<Item> itemTag(String namespace, String identifier) {
        return this.tag(Registries.ITEMS, namespace, identifier);
    }

    protected TagBuilder<Item> itemTag(String identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(ResourceLocation identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(TagKey<EntityType<?>> tagKey) {
        return this.tag(Registries.ENTITY_TYPES, tagKey);
    }

    protected TagBuilder<EntityType<?>> entityTag(String namespace, String identifier) {
        return this.tag(Registries.ENTITY_TYPES, namespace, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(String identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<Block> blockMineableWithAxe() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144280_);
    }

    protected TagBuilder<Block> blockMineableWithHoe() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144281_);
    }

    protected TagBuilder<Block> blockMineableWithPickaxe() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144282_);
    }

    protected TagBuilder<Block> blockMineableWithShovel() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144283_);
    }

    protected TagBuilder<Block> blockNeedsStoneTool() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144286_);
    }

    protected TagBuilder<Block> blockNeedsIronTool() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144285_);
    }

    protected TagBuilder<Block> blockNeedsDiamondTool() {
        return this.blockTag((TagKey<Block>)BlockTags.f_144284_);
    }

    @Override
    public String getName() {
        return this.modName + " Tag Generator";
    }

    protected static class TagBuilder<T> {
        private final Registries.Registry<T> registry;
        protected final ResourceLocation identifier;
        private final Set<Tag.Entry> entries = new HashSet<Tag.Entry>();
        private final Set<Tag.Entry> remove = new HashSet<Tag.Entry>();
        private boolean replace;

        protected TagBuilder(Registries.Registry<T> registry, ResourceLocation identifier) {
            this.registry = registry;
            this.identifier = identifier;
        }

        public TagBuilder<T> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public TagBuilder<T> replace() {
            return this.replace(true);
        }

        public TagBuilder<T> add(T entry) {
            this.entries.add((Tag.Entry)new Tag.ElementEntry(this.registry.getIdentifier(entry)));
            return this;
        }

        public TagBuilder<T> add(ResourceLocation entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.entries.add((Tag.Entry)new Tag.ElementEntry(entry));
            return this;
        }

        public TagBuilder<T> add(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.add(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> add(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.add(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> addOptional(T entry) {
            this.entries.add((Tag.Entry)new Tag.OptionalElementEntry(this.registry.getIdentifier(entry)));
            return this;
        }

        public TagBuilder<T> addOptional(ResourceLocation entry) {
            this.entries.add((Tag.Entry)new Tag.OptionalElementEntry(entry));
            return this;
        }

        public TagBuilder<T> addOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptional(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.addOptional(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> addOptional(CustomTagEntry entry) {
            this.entries.add(CustomTagEntry.createVanillaEntry(entry));
            return this;
        }

        public TagBuilder<T> addReference(ResourceLocation tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.entries.add((Tag.Entry)new Tag.TagEntry(tag));
            return this;
        }

        public TagBuilder<T> addReference(TagKey<T> tag) {
            return this.addReference(tag.f_203868_());
        }

        public TagBuilder<T> addReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.entries.add((Tag.Entry)new Tag.TagEntry(new ResourceLocation(namespace, identifier)));
            return this;
        }

        public TagBuilder<T> addReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.entries.add((Tag.Entry)new Tag.TagEntry(new ResourceLocation(tag)));
            return this;
        }

        public TagBuilder<T> addOptionalReference(ResourceLocation tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.entries.add((Tag.Entry)new Tag.OptionalTagEntry(tag));
            return this;
        }

        public TagBuilder<T> addOptionalReference(TagKey<T> tag) {
            return this.addOptionalReference(tag.f_203868_());
        }

        public TagBuilder<T> addOptionalReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptionalReference(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptionalReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.addOptionalReference(new ResourceLocation(tag));
            return this;
        }

        public TagBuilder<T> remove(T entry) {
            this.remove.add((Tag.Entry)new Tag.ElementEntry(this.registry.getIdentifier(entry)));
            return this;
        }

        public TagBuilder<T> remove(ResourceLocation entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.remove.add((Tag.Entry)new Tag.ElementEntry(entry));
            return this;
        }

        public TagBuilder<T> remove(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.remove(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> remove(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.remove(new ResourceLocation(entry));
            return this;
        }

        public TagBuilder<T> removeOptional(T entry) {
            return this.removeOptional(this.registry.getIdentifier(entry));
        }

        public TagBuilder<T> removeOptional(ResourceLocation entry) {
            this.remove.add((Tag.Entry)new Tag.OptionalElementEntry(entry));
            return this;
        }

        public TagBuilder<T> removeOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.removeOptional(new ResourceLocation(namespace, identifier));
            return this;
        }

        public TagBuilder<T> removeOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.removeOptional(new ResourceLocation(entry));
            return this;
        }

        private void addAll(TagBuilder<T> other) {
            this.entries.addAll(other.entries);
            this.remove.addAll(other.remove);
        }
    }
}

