/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.supermartijn642.core.ClientUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        fontRenderer.m_92889_(poseStack, text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        fontRenderer.m_92889_(poseStack, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        fontRenderer.m_92763_(poseStack, text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        fontRenderer.m_92763_(poseStack, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        fontRenderer.m_92889_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        fontRenderer.m_92889_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int color) {
        fontRenderer.m_92763_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, Component text, float x, float y) {
        fontRenderer.m_92763_(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Component text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        fontRenderer.m_92883_(poseStack, text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        fontRenderer.m_92883_(poseStack, text, x, y, 0x404040);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        fontRenderer.m_92750_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        fontRenderer.m_92750_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, 0x404040);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        fontRenderer.m_92883_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        fontRenderer.m_92883_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredString(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y, int color) {
        fontRenderer.m_92750_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font fontRenderer, String text, float x, float y) {
        fontRenderer.m_92750_(poseStack, text, x - (float)fontRenderer.m_92895_(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(PoseStack poseStack, float x, float y, float width, float height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        ScreenUtils.bindTexture(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(poseStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(poseStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(PoseStack poseStack, float x, float y, float width, float height, float yOffset) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        ScreenUtils.bindTexture(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(poseStack, x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(poseStack, x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(poseStack, x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height) {
        ScreenUtils.drawTexture(poseStack, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(PoseStack poseStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, x, y + height, 0.0f).m_7421_(tx, ty + theight).m_5752_();
        buffer.m_85982_(matrix, x + width, y + height, 0.0f).m_7421_(tx + twidth, ty + theight).m_5752_();
        buffer.m_85982_(matrix, x + width, y, 0.0f).m_7421_(tx + twidth, ty).m_5752_();
        buffer.m_85982_(matrix, x, y, 0.0f).m_7421_(tx, ty).m_5752_();
        tessellator.m_85914_();
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(poseStack, x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(PoseStack poseStack, float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(matrix, x, y + height, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x + width, y + height, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x + width, y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x, y, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltipInternal(poseStack, fontRenderer, text.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, Collections.singletonList(text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Font fontRenderer, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, (Component)new TextComponent(text), x, y);
    }

    public static void drawTooltip(PoseStack poseStack, List<Component> text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, Component text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(PoseStack poseStack, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    private static void drawTooltipInternal(PoseStack poseStack, Font fontRenderer, List<ClientTooltipComponent> components, int x, int y) {
        ClientTooltipComponent component;
        int index;
        int windowHeight;
        if (components.isEmpty()) {
            return;
        }
        int windowWidth = ClientUtils.getMinecraft().m_91268_().m_85445_();
        RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)ItemStack.f_41583_, (PoseStack)poseStack, (int)x, (int)y, (int)windowWidth, (int)(windowHeight = ClientUtils.getMinecraft().m_91268_().m_85446_()), components, (Font)fontRenderer, (Font)ClientUtils.getFontRenderer());
        if (preEvent.isCanceled()) {
            return;
        }
        int tooltipWidth = 0;
        int tooltipHeight = components.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component2 : components) {
            int componentWidth = component2.m_142069_(preEvent.getFont());
            if (componentWidth > tooltipWidth) {
                tooltipWidth = componentWidth;
            }
            tooltipHeight += component2.m_142103_();
        }
        int tooltipX = preEvent.getX() + 12;
        int tooltipY = preEvent.getY() - 12;
        if (tooltipX + tooltipWidth > windowWidth) {
            tooltipX -= 28 + tooltipWidth;
        }
        if (tooltipY + tooltipHeight + 6 > windowHeight) {
            tooltipY = windowHeight - tooltipHeight - 6;
        }
        if (y - tooltipHeight - 8 < 0) {
            tooltipY = y + 8;
        }
        poseStack.m_85836_();
        ItemRenderer itemRenderer = ClientUtils.getItemRenderer();
        float oldBlitOffset = itemRenderer.f_115093_;
        itemRenderer.f_115093_ = 400.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)ItemStack.f_41583_, (PoseStack)poseStack, (int)tooltipX, (int)tooltipY, (Font)preEvent.getFont(), components);
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY - 3), (int)400, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundStart());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)400, (int)colorEvent.getBackgroundEnd(), (int)colorEvent.getBackgroundEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)400, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)400, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)400, (int)colorEvent.getBackgroundStart(), (int)colorEvent.getBackgroundEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)400, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX + tooltipWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)400, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderEnd());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY - 3 + 1), (int)400, (int)colorEvent.getBorderStart(), (int)colorEvent.getBorderStart());
        GuiComponent.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)400, (int)colorEvent.getBorderEnd(), (int)colorEvent.getBorderEnd());
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int offsetY = tooltipY;
        for (index = 0; index < components.size(); ++index) {
            component = components.get(index);
            component.m_142440_(preEvent.getFont(), tooltipX, offsetY, matrix4f, bufferSource);
            offsetY += component.m_142103_() + (index == 0 ? 2 : 0);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        offsetY = tooltipY;
        for (index = 0; index < components.size(); ++index) {
            component = components.get(index);
            component.m_183452_(preEvent.getFont(), tooltipX, offsetY, poseStack, itemRenderer, 400);
            offsetY += component.m_142103_() + (index == 0 ? 2 : 0);
        }
        itemRenderer.f_115093_ = oldBlitOffset;
    }
}

