/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.gui.ContainerFluiDrawer;

public class BlockFluidDrawer
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape center = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape base = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape column1 = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0);
    public static final VoxelShape column2 = Block.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0);
    public static final VoxelShape column3 = Block.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0);
    public static final VoxelShape column4 = Block.m_49796_((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape top = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockFluidDrawer(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_.m_61104_(new Property[]{FACING}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83124_((VoxelShape)center, (VoxelShape[])new VoxelShape[]{base, column1, column2, column3, column4, top});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() == Direction.UP || hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            final BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (heldStack.m_41619_() && player.m_6144_()) {
                if (((Boolean)CommonConfig.GENERAL.enableUI.get()).booleanValue() && !world.m_5776_()) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return new TranslatableComponent("gui.fluiddrawerslegacy.tittle");
                        }

                        @javax.annotation.Nullable
                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player playerEntity) {
                            return new ContainerFluiDrawer(ModContents.containerType, windowId, playerInv, tile);
                        }
                    }, extraData -> extraData.m_130064_(pos));
                    return InteractionResult.SUCCESS;
                }
            } else if (heldStack.m_41720_() instanceof ItemUpgrade) {
                if (tile.upgrades().canAddUpgrade(heldStack)) {
                    if (tile.upgrades().addUpgrade(heldStack)) {
                        if (!player.m_7500_()) {
                            heldStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!world.m_5776_()) {
                        player.m_5661_((Component)new TranslatableComponent("message.storagedrawers.max_upgrades"), true);
                    }
                } else if (!world.m_5776_()) {
                    player.m_5661_((Component)new TranslatableComponent("message.storagedrawers.cannot_add_upgrade"), true);
                }
            } else if (offhandStack == ItemStack.f_41583_) {
                Item item = heldStack.m_41720_();
                if (item instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)item;
                    if (bucketItem.getFluid() == Fluids.f_76191_ && tile.getTankFLuid().getAmount() >= 1000) {
                        tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(handler -> {
                            FluidStack fluidStack = handler.drain(new FluidStack(tile.getTankFLuid().getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                            Fluid fluid = fluidStack.getFluid();
                            if (heldStack.m_41613_() > 1) {
                                if (!player.m_36356_(new ItemStack((ItemLike)fluid.m_6859_()))) {
                                    Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)new ItemStack((ItemLike)fluid.m_6859_()));
                                }
                                if (!player.m_7500_()) {
                                    heldStack.m_41774_(1);
                                }
                            } else if (!player.m_7500_()) {
                                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)new ItemStack((ItemLike)fluid.m_6859_())));
                            }
                        });
                    } else {
                        if (tile.hasNoFluid()) {
                            if (bucketItem.getFluid() == Fluids.f_76191_) {
                                return InteractionResult.FAIL;
                            }
                            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(handler -> {
                                int amount = handler.fill(new FluidStack(bucketItem.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE);
                                if (amount == 1000) {
                                    handler.fill(new FluidStack(bucketItem.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                                    if (!player.m_7500_()) {
                                        player.m_21008_(hand, heldStack.getContainerItem());
                                    }
                                }
                            });
                            return InteractionResult.SUCCESS;
                        }
                        if (tile.getTankFLuid().getAmount() + 1000 <= tile.getTankEffectiveCapacity() && tile.getTankFLuid().getFluid() == bucketItem.getFluid()) {
                            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(handler -> handler.fill(new FluidStack(bucketItem.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE));
                            if (!player.m_7500_()) {
                                player.m_21008_(hand, heldStack.getContainerItem());
                            }
                            return InteractionResult.SUCCESS;
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tile.getTank())) {
                    return InteractionResult.SUCCESS;
                }
                if (heldStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    heldStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                        if (tile.hasNoFluid()) {
                            if (tile.getTankEffectiveCapacity() > handler.getTankCapacity(0)) {
                                tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(TEhandler -> TEhandler.fill(handler.drain(handler.getTankCapacity(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                            } else {
                                tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(TEhandler -> TEhandler.fill(handler.drain(tile.getTankEffectiveCapacity(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                            }
                        } else if (tile.getTankFLuid().getFluid() == handler.drain(1, IFluidHandler.FluidAction.SIMULATE).getFluid()) {
                            if (tile.getTankEffectiveCapacity() < handler.getTankCapacity(0) + tile.getTankFLuid().getAmount()) {
                                tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(TEhandler -> TEhandler.fill(handler.drain(handler.getTankCapacity(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                            } else {
                                tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(TEhandler -> TEhandler.fill(handler.drain(tile.getTankEffectiveCapacity() - tile.getTankFLuid().getAmount(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                            }
                        }
                    });
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = ModContents.itemBlock.m_5456_().m_7968_();
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            FluidStack[] fluidStackDown = new FluidStack[1];
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(handler -> {
                fluidStackDown[0] = handler.getFluidInTank(0);
                CompoundTag nbt = new CompoundTag();
                handler.getFluidInTank(0).writeToNBT(nbt);
                stack.m_41700_("tank", (Tag)((BlockEntityFluidDrawer.betterFluidHandler)((Object)handler)).serializeNBT());
            });
            stack.m_41700_("Upgrades", tile.m_5995_().m_128423_("Upgrades"));
            EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
            if (((IDrawerAttributesModifiable)tile.getDrawerAttributes()).isItemLocked(LockAttribute.LOCK_EMPTY)) {
                attrs.add(LockAttribute.LOCK_EMPTY);
            }
            if (((IDrawerAttributesModifiable)tile.getDrawerAttributes()).isItemLocked(LockAttribute.LOCK_POPULATED)) {
                attrs.add(LockAttribute.LOCK_POPULATED);
            }
            if (!attrs.isEmpty()) {
                stack.m_41784_().m_128344_("Lock", (byte)LockAttribute.getBitfield(attrs));
            }
            if (((IDrawerAttributesModifiable)tile.getDrawerAttributes()).isConcealed()) {
                stack.m_41784_().m_128379_("Shr", true);
            }
            if (((IDrawerAttributesModifiable)tile.getDrawerAttributes()).isShowingQuantity()) {
                stack.m_41784_().m_128379_("Qua", true);
            }
        }
        return stack;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer && stack.m_41782_()) {
            IDrawerAttributes _attrs;
            CompoundTag tag;
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            if (stack.m_41783_().m_128441_("Upgrades")) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Upgrades", stack.m_41783_().m_128423_("Upgrades"));
                tile.upgrades().read(nbt);
            }
            if ((tag = stack.m_41784_()).m_128441_("Lock")) {
                EnumSet attrs = LockAttribute.getEnumSet((int)tag.m_128445_("Lock"));
                if (attrs != null) {
                    ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains(LockAttribute.LOCK_EMPTY));
                    ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains(LockAttribute.LOCK_POPULATED));
                }
            } else {
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setItemLocked(LockAttribute.LOCK_EMPTY, false);
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setItemLocked(LockAttribute.LOCK_POPULATED, false);
            }
            if (stack.m_41783_().m_128441_("Shr")) {
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setIsConcealed(tag.m_128471_("Shr"));
            } else {
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setIsConcealed(false);
            }
            if (stack.m_41783_().m_128441_("Qua")) {
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setIsShowingQuantity(tag.m_128471_("Qua"));
            } else {
                ((IDrawerAttributesModifiable)tile.getDrawerAttributes()).setIsShowingQuantity(false);
            }
            if (entity != null && entity.m_21206_().m_41720_() == ModItems.DRAWER_KEY.get() && (_attrs = (IDrawerAttributes)tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY).orElse((Object)new EmptyDrawerAttributes())) instanceof IDrawerAttributesModifiable) {
                IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
                attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
            }
            if (stack.m_41784_().m_128441_("tank")) {
                tile.setCutStartAnimation(true);
                BlockEntityFluidDrawer.betterFluidHandler tank = (BlockEntityFluidDrawer.betterFluidHandler)tile.getTank();
                tank.deserializeNBT((CompoundTag)stack.m_41784_().m_128423_("tank"));
            }
        }
        super.m_6402_(level, pos, state, entity, stack);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        super.m_6786_(level, pos, state);
        level.m_5594_(null, pos, Fluids.f_76193_.getAttributes().getEmptySound(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!this.m_7899_(state) || !(blockAccess.m_7702_(pos) instanceof BlockEntityFluidDrawer)) {
            return 0;
        }
        BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)blockAccess.m_7702_(pos);
        return tile != null && tile.isRedstone() ? tile.getRedstoneLevel() : 0;
    }

    public int m_6376_(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return side == Direction.UP ? this.m_6378_(state, worldIn, pos, side) : 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityFluidDrawer(pos, state);
    }
}

