/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block.blockentity;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.network.MessageHandler;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xueluoanping.fluiddrawerslegacy.ModConstants;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.config.General;

public class BlockEntityFluidDrawer
extends ChamTileEntity
implements IDrawerGroup {
    private BasicDrawerAttributes drawerAttributes = new DrawerAttributes();
    private GroupData groupData = new GroupData(1);
    private UpgradeData upgradeData = new DrawerUpgradeData();
    private final LazyOptional<?> capabilityGroup = LazyOptional.of(this::getGroup);
    private int lastFluidAmount = 0;
    private int cacheFluidAmount = 0;
    private double lastAnimationTime = 0.0;
    private boolean cutStartAnimation = false;

    public BlockEntityFluidDrawer(BlockPos pos, BlockState state) {
        super(ModContents.tankTileEntityType, pos, state);
        this.groupData.setCapabilityProvider((ICapabilityProvider)this);
        this.injectPortableData((TileDataShim)this.groupData);
        this.upgradeData.setDrawerAttributes((IDrawerAttributesModifiable)this.drawerAttributes);
        this.injectPortableData((TileDataShim)this.upgradeData);
    }

    private static int getCapacityStandard() {
        return (Integer)General.volume.get();
    }

    public IDrawerGroup getGroup() {
        return this.groupData;
    }

    protected void onAttributeChanged() {
        this.requestModelDataUpdate();
        this.groupData.syncAttributes();
    }

    public boolean hasNoFluid() {
        return this.upgrades().write(new CompoundTag()).toString().contains("storagedrawers:void_upgrade") || this.groupData.tank.getFluidInTank(0).getAmount() == 0;
    }

    public FluidStack getTankFLuid() {
        return this.groupData.tank.getFluidInTank(0);
    }

    public void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getDrawerCount() {
        return 0;
    }

    @NotNull
    public IDrawer getDrawer(int i) {
        return new StandardDrawerData((StandardDrawerGroup)this.getGroup(), 0);
    }

    @NotNull
    public int[] getAccessibleDrawerSlots() {
        return new int[0];
    }

    public void setCutStartAnimation(boolean cutStartAnimation) {
        this.cutStartAnimation = cutStartAnimation;
    }

    public int getAndUpdateLastFluidAmount(double animationTime) {
        int expectFluidAmount = this.groupData.tank.getFluidAmount();
        if (expectFluidAmount != this.lastFluidAmount) {
            int fluidAmountChange = expectFluidAmount - this.lastFluidAmount;
            boolean isFluidUpdate = expectFluidAmount != this.cacheFluidAmount;
            boolean hasEnoughFluidAmount = Math.abs(fluidAmountChange) > 200;
            boolean isTooQuickAnimation = isFluidUpdate && animationTime - this.lastAnimationTime < 3.0;
            boolean shouldAnimation = hasEnoughFluidAmount && !isTooQuickAnimation && !this.cutStartAnimation;
            this.lastFluidAmount = shouldAnimation ? (int)((float)this.lastFluidAmount + (float)fluidAmountChange * 0.125f) : expectFluidAmount;
            if (isFluidUpdate) {
                this.lastAnimationTime = animationTime;
            }
            this.cutStartAnimation = false;
        }
        this.cacheFluidAmount = expectFluidAmount;
        return this.lastFluidAmount;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        IDrawerGroup group = this.getGroup();
        if (capability == ModConstants.DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        LazyOptional cap = this.getGroup().getCapability(capability, facing);
        return cap.isPresent() ? cap : super.getCapability(capability, facing);
    }

    public CompoundTag writePortable(CompoundTag tag) {
        tag = super.writePortable(tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.m_128344_("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.m_128379_("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.m_128379_("Qua", true);
        }
        return tag;
    }

    public void readPortable(CompoundTag nbt) {
        super.readPortable(nbt);
        if (nbt.m_128441_("Lock")) {
            EnumSet attrs = LockAttribute.getEnumSet((int)nbt.m_128445_("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains(LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains(LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (nbt.m_128441_("Shr")) {
            this.drawerAttributes.setIsConcealed(nbt.m_128471_("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (nbt.m_128441_("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(nbt.m_128471_("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
    }

    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    protected void syncClientCount(int slot, int count) {
        if (this.m_58904_() == null || !this.m_58904_().f_46443_) {
            PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 500.0, this.m_58904_().m_46472_());
            MessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> point), (Object)new CountUpdateMessage(this.m_58899_(), slot, count));
        }
    }

    public IFluidHandler getTank() {
        return this.groupData.tank;
    }

    public int getTankEffectiveCapacity() {
        if (this.upgrades().hasVendingUpgrade() || this.upgrades().hasUnlimitedUpgrade()) {
            return Integer.MAX_VALUE;
        }
        if (this.upgrades().hasOneStackUpgrade()) {
            return BlockEntityFluidDrawer.getCapacityStandard() / 32;
        }
        return BlockEntityFluidDrawer.getCapacityStandard() * this.upgrades().getStorageMultiplier();
    }

    public static int calcultaeTankCapacitybyStack(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("Upgrades")) {
            return BlockEntityFluidDrawer.getCapacityStandard();
        }
        int i = 1;
        UpgradeData tmpData = new UpgradeData(7);
        tmpData.setDrawerAttributes(new IDrawerAttributesModifiable(){});
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Upgrades", stack.m_41784_().m_128423_("Upgrades"));
        tmpData.deserializeNBT(tag);
        i = tmpData.getStorageMultiplier();
        if (tmpData.hasVendingUpgrade() || tmpData.hasUnlimitedUpgrade()) {
            return Integer.MAX_VALUE;
        }
        if (tmpData.hasOneStackUpgrade()) {
            return BlockEntityFluidDrawer.getCapacityStandard() / 32;
        }
        return BlockEntityFluidDrawer.getCapacityStandard() * i;
    }

    @Nonnull
    public int getRedstoneLevel() {
        return (int)((float)this.getTankFLuid().getAmount() / (float)this.getTankEffectiveCapacity() * 15.0f);
    }

    public boolean isRedstone() {
        return this.upgrades().getRedstoneType() != null;
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        protected void onAttributeChanged() {
            BlockEntityFluidDrawer.this.onAttributeChanged();
            if (BlockEntityFluidDrawer.this.m_58904_() != null && !BlockEntityFluidDrawer.this.m_58904_().f_46443_) {
                BlockEntityFluidDrawer.this.m_6596_();
                BlockEntityFluidDrawer.this.markBlockForUpdate();
            }
        }

        public boolean isUnlimitedVending() {
            return BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade();
        }

        public boolean setItemLocked(LockAttribute attr, boolean isLocked) {
            boolean result = super.setItemLocked(attr, isLocked);
            return result;
        }
    }

    public class GroupData
    extends StandardDrawerGroup {
        private final LazyOptional<?> attributesHandler;
        public final betterFluidHandler tank;
        private final LazyOptional<betterFluidHandler> tankHandler;
        public StandardDrawerGroup.DrawerData drawerData;

        public GroupData(int slotCount) {
            super(slotCount);
            this.attributesHandler = LazyOptional.of(BlockEntityFluidDrawer.this::getDrawerAttributes);
            this.tank = this.createFuildHandler();
            this.tankHandler = LazyOptional.of(() -> this.tank);
        }

        private betterFluidHandler createFuildHandler() {
            return new betterFluidHandler((int)((Integer)General.volume.get())){};
        }

        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            this.drawerData = new StandardDrawerData(this, slot);
            return this.drawerData;
        }

        public boolean isGroupValid() {
            return !BlockEntityFluidDrawer.this.m_58901_();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == ModConstants.DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.attributesHandler.cast();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                if (facing == null) {
                    // empty if block
                }
                return this.tankHandler.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag write(CompoundTag tag) {
            tag.m_128365_("tank", (Tag)this.tank.serializeNBT());
            return super.write(tag);
        }

        public void read(CompoundTag nbt) {
            BlockEntityFluidDrawer.this.upgrades().read(nbt);
            if (nbt.m_128441_("tank")) {
                this.tank.deserializeNBT((CompoundTag)nbt.m_128423_("tank"));
            }
            super.read(nbt);
        }

        public boolean idVoidUpgrade() {
            return BlockEntityFluidDrawer.this.getDrawerAttributes().isVoid();
        }
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.m_41720_() == ModItems.FILL_LEVEL_UPGRADE.get()) {
                return false;
            }
            if (upgrade.m_41720_() == ModItems.ONE_STACK_UPGRADE.get()) {
                if (BlockEntityFluidDrawer.this.upgrades().hasOneStackUpgrade()) {
                    return false;
                }
                if (BlockEntityFluidDrawer.this.getTank().getFluidInTank(0).getAmount() >= BlockEntityFluidDrawer.getCapacityStandard() / 32) {
                    return false;
                }
            }
            return true;
        }

        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.m_41720_() instanceof ItemUpgradeStorage) {
                int storageLevel = ((ItemUpgradeStorage)upgrade.m_41720_()).level.getLevel();
                int storageMult = CommonConfig.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = BlockEntityFluidDrawer.this.upgrades().getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                int amount = BlockEntityFluidDrawer.this.getTank().getFluidInTank(0).getAmount();
                int capacity = BlockEntityFluidDrawer.this.getTank().getTankCapacity(0);
                int standardCapacity = BlockEntityFluidDrawer.getCapacityStandard();
                int afterCapacity = standardCapacity * (effectiveStorageMult - storageMult);
                if (afterCapacity < amount) {
                    return false;
                }
            }
            return true;
        }

        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (BlockEntityFluidDrawer.this.m_58904_() != null && !BlockEntityFluidDrawer.this.m_58904_().f_46443_) {
                BlockEntityFluidDrawer.this.m_6596_();
                BlockEntityFluidDrawer.this.markBlockForUpdate();
            }
        }
    }

    public class betterFluidHandler
    extends FluidTank {
        private FluidStack cacheFluid;

        public FluidStack getCacheFluid() {
            return this.cacheFluid.copy();
        }

        private void setCacheFluid(FluidStack cacheFluid) {
            FluidStack cacheFluidCopy = cacheFluid.copy();
            if (!cacheFluidCopy.isEmpty()) {
                cacheFluidCopy.setAmount(1);
            }
            this.cacheFluid = cacheFluidCopy;
        }

        public betterFluidHandler(int capacity) {
            super(capacity);
            this.cacheFluid = FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack getFluid() {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade() && this.fluid.getFluid() != Fluids.f_76191_) {
                return new FluidStack(super.getFluid().getFluid(), Integer.MAX_VALUE);
            }
            return super.getFluid();
        }

        public CompoundTag serializeNBT() {
            if (this.getCapacity() != BlockEntityFluidDrawer.this.getTankEffectiveCapacity()) {
                this.setCapacity(BlockEntityFluidDrawer.this.getTankEffectiveCapacity());
            }
            CompoundTag nbt = new CompoundTag();
            if (this.getCacheFluid().getRawFluid() != Fluids.f_76191_ && this.fluid.getFluid() != Fluids.f_76191_ && this.getCacheFluid().getRawFluid() != this.fluid.getFluid()) {
                this.setCacheFluid(this.getFluid());
            }
            if (this.getCacheFluid().getRawFluid() == Fluids.f_76191_ && this.getFluid().getAmount() > 0) {
                this.setCacheFluid(this.getFluid());
            }
            nbt.m_128365_("cache", (Tag)this.cacheFluid.writeToNBT(new CompoundTag()));
            return this.writeToNBT(nbt);
        }

        public void deserializeNBT(CompoundTag tank) {
            if (this.getCapacity() != BlockEntityFluidDrawer.this.getTankEffectiveCapacity()) {
                this.setCapacity(BlockEntityFluidDrawer.this.getTankEffectiveCapacity());
            }
            if (tank.m_128441_("cache")) {
                FluidStack cacheTempStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tank.m_128469_("cache"));
                this.setCacheFluid(cacheTempStack);
            }
            this.readFromNBT(tank);
        }

        protected void onContentsChanged() {
            BlockEntityFluidDrawer.this.inventoryChanged();
            super.onContentsChanged();
        }

        public boolean isFull() {
            return this.getFluidAmount() == this.getCapacity();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return 0;
            }
            if (BlockEntityFluidDrawer.this.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY)) {
                if (this.getCacheFluid().getRawFluid() != Fluids.f_76191_ && !this.getCacheFluid().isFluidEqual(resource)) {
                    return 0;
                }
                if (this.getCacheFluid().getRawFluid() == Fluids.f_76191_) {
                    if (resource.getAmount() > 0) {
                        if (action.execute()) {
                            this.setCacheFluid(resource);
                        }
                        return super.fill(resource, action);
                    }
                    return 0;
                }
            }
            if (this.getCapacity() - this.fluid.getAmount() - resource.getAmount() < 0 && BlockEntityFluidDrawer.this.upgrades().write(new CompoundTag()).toString().contains("storagedrawers:void_upgrade")) {
                if (resource.isEmpty() || !this.isFluidValid(resource)) {
                    return 0;
                }
                if (action.simulate()) {
                    return resource.getAmount();
                }
                if (this.fluid.isEmpty()) {
                    this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.getAmount()));
                    this.onContentsChanged();
                    return this.fluid.getAmount();
                }
                if (!this.fluid.isFluidEqual(resource)) {
                    return 0;
                }
                this.fluid.setAmount(this.capacity);
                this.onContentsChanged();
                return resource.getAmount();
            }
            return super.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return resource.getFluid() == this.fluid.getFluid() ? new FluidStack(this.fluid.getFluid(), resource.getAmount()) : FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return new FluidStack(this.fluid.getFluid(), maxDrain);
            }
            return super.drain(maxDrain, action);
        }
    }

    public class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        public betterFluidHandler getTank() {
            return BlockEntityFluidDrawer.this.groupData.tank;
        }

        protected int getStackCapacity() {
            return 0;
        }

        public int getMaxCapacity() {
            return BlockEntityFluidDrawer.this.getTankEffectiveCapacity();
        }

        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent((IDrawer)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (BlockEntityFluidDrawer.this.m_58904_() != null && !BlockEntityFluidDrawer.this.m_58904_().m_5776_()) {
                BlockEntityFluidDrawer.this.m_6596_();
                BlockEntityFluidDrawer.this.markBlockForUpdate();
            }
        }

        protected void onAmountChanged() {
            if (BlockEntityFluidDrawer.this.m_58904_() != null && !BlockEntityFluidDrawer.this.m_58904_().m_5776_()) {
                BlockEntityFluidDrawer.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityFluidDrawer.this.m_6596_();
            }
        }

        public boolean isLock() {
            return BlockEntityFluidDrawer.this.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
        }

        public boolean isVoid() {
            return BlockEntityFluidDrawer.this.upgrades().serializeNBT().toString().contains("void");
        }

        public BlockPos getDrawerPos() {
            return BlockEntityFluidDrawer.this.m_58899_();
        }
    }
}

