/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;

public class FluidDrawerItemStackTileEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public FluidDrawerItemStackTileEntityRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.blockEntityRenderDispatcher = renderDispatcher;
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel ibakedmodel = itemRenderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        matrixStackIn.m_85836_();
        matrixStackIn = this.rotateMatrix(matrixStackIn, transformType);
        this.renderFluid(stack, matrixStackIn, bufferIn, combinedLightIn, 0.0);
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.NONE, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlay, ibakedmodel.handlePerspective(ItemTransforms.TransformType.NONE, matrixStackIn));
        matrixStackIn.m_85849_();
    }

    private PoseStack rotateMatrix(PoseStack matrixStackIn, ItemTransforms.TransformType transformType) {
        if (transformType == ItemTransforms.TransformType.GUI) {
            matrixStackIn.m_85837_(0.9375, 0.21875, 0.0);
            matrixStackIn.m_85845_(new Quaternion(30.0f, 225.0f, 0.0f, true));
            matrixStackIn.m_85841_(0.625f, 0.625f, 0.625f);
        }
        if (transformType == ItemTransforms.TransformType.GROUND) {
            matrixStackIn.m_85837_(0.375, 0.375, 0.375);
            matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
        }
        if (transformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            matrixStackIn.m_85845_(new Quaternion(75.0f, 45.0f, 0.0f, true));
            matrixStackIn.m_85837_(0.51625, 0.46875, -0.1875);
            matrixStackIn.m_85841_(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            matrixStackIn.m_85845_(new Quaternion(75.0f, 45.0f, 0.0f, true));
            matrixStackIn.m_85837_(0.51625, 0.46875, -0.1875);
            matrixStackIn.m_85841_(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            matrixStackIn.m_85837_(0.40625, -0.1875, 0.0);
            matrixStackIn.m_85845_(new Quaternion(0.0f, 45.0f, 0.0f, true));
            matrixStackIn.m_85841_(0.675f, 0.675f, 0.675f);
        }
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            matrixStackIn.m_85837_(0.59375, -0.1875, 0.0);
            matrixStackIn.m_85845_(new Quaternion(0.0f, 225.0f, 0.0f, true));
            matrixStackIn.m_85841_(0.675f, 0.675f, 0.675f);
        }
        return matrixStackIn;
    }

    private void renderFluid(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        if (!stack.m_41784_().m_128441_("tank")) {
            return;
        }
        FluidStack fluidStackDown = new FluidStack(Fluids.f_76191_, 0);
        fluidStackDown = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)stack.m_41784_().m_128423_("tank")));
        if (fluidStackDown.getAmount() == 0) {
            return;
        }
        if (stack.m_41784_().toString().contains("storagedrawers:creative_vending_upgrade")) {
            fluidStackDown.setAmount(Integer.MAX_VALUE);
        }
        Minecraft mc = Minecraft.m_91087_();
        TextureAtlasSprite still = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(fluidStackDown.getFluid().getAttributes().getStillTexture());
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int colorRGB = fluidStackDown.getFluid().getAttributes().getColor(fluidStackDown);
        int capacity = BlockEntityFluidDrawer.calcultaeTankCapacitybyStack(stack);
        int amount = fluidStackDown.getAmount();
        if (capacity < amount) {
            amount = capacity;
        }
        float height = (float)amount / (float)capacity * 0.875f;
        float vHeight = (still.m_118412_() - still.m_118411_()) * (1.0f - (float)amount / (float)capacity);
        GlStateManager.m_84094_();
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110466_());
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_() - vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118412_() - vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        GlStateManager.m_84091_();
    }

    private void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int RGBA, float alpha, int brightness) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA >> 0 & 0xFF) / 255.0f;
        renderer.m_85982_(stack.m_85850_().m_85861_(), x, y, z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(stack.m_85850_().m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

