/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.config.ClientConfig;
import xueluoanping.fluiddrawerslegacy.util.MathUtil;

public class TESRFluidDrawer
implements BlockEntityRenderer<BlockEntityFluidDrawer> {
    public static final Material BELL_RESOURCE_LOCATION = new Material(TextureAtlas.f_118259_, new ResourceLocation("entity/bell/bell_body"));
    private static final String BELL_BODY = "bell_body";
    private final ModelPart bellBody;
    private final Font font;

    public TESRFluidDrawer(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.m_173582_(ModelLayers.f_171269_);
        this.bellBody = modelpart.m_171324_(BELL_BODY);
        this.font = pContext.m_173586_();
    }

    public void render(BlockEntityFluidDrawer tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        MultiBufferSource.BufferSource txtBuffer;
        int textWidth;
        Font fontRenderer;
        FluidStack fluidStackDown;
        if (!tile.m_58898_()) {
            return;
        }
        if (tile.upgrades().hasIlluminationUpgrade()) {
            combinedLightIn = 0xF000F0;
        }
        matrixStackIn.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        long gameTime = mc.f_91073_.m_46467_();
        double animationTime = (double)gameTime + (double)partialTicks;
        this.renderFluid(tile, matrixStackIn, bufferIn, combinedLightIn, animationTime);
        matrixStackIn.m_85849_();
        BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = (BlockEntityFluidDrawer.betterFluidHandler)tile.getTank();
        matrixStackIn.m_85836_();
        if (!betterFluidHandler2.getCacheFluid().isEmpty() && tile.getDrawerAttributes().isConcealed()) {
            fluidStackDown = new FluidStack(betterFluidHandler2.getCacheFluid(), 1);
            fontRenderer = this.font;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.handleMatrixAngle(matrixStackIn, player, tile.m_58899_(), (Direction)tile.m_58900_().m_61143_((Property)BlockFluidDrawer.FACING));
            matrixStackIn.m_85841_(0.007f, 0.007f, 0.007f);
            MultiBufferSource.BufferSource txtBuffer2 = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            textWidth = fontRenderer.m_92895_(I18n.m_118938_((String)fluidStackDown.getTranslationKey(), (Object[])new Object[0]));
            fontRenderer.m_92811_(fluidStackDown.getDisplayName().getString(), (float)(-textWidth) / 2.0f, -9.0f, 0xFFFFFF, false, matrixStackIn.m_85850_().m_85861_(), (MultiBufferSource)txtBuffer2, false, 0, combinedLightIn);
            txtBuffer2.m_109911_();
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        if (tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY) && !betterFluidHandler2.getCacheFluid().isEmpty()) {
            fluidStackDown = new FluidStack(betterFluidHandler2.getCacheFluid(), 1000);
            fontRenderer = this.font;
            txtBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            String label = "(" + I18n.m_118938_((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ")";
            textWidth = fontRenderer.m_92895_(label);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.handleMatrixAngle(matrixStackIn, player, tile.m_58899_(), (Direction)tile.m_58900_().m_61143_((Property)BlockFluidDrawer.FACING));
            matrixStackIn.m_85841_(0.007f, 0.007f, 0.007f);
            fontRenderer.m_92811_(label, (float)(-textWidth) / 2.0f, 0.0f, 0xFFFFFF, false, matrixStackIn.m_85850_().m_85861_(), (MultiBufferSource)txtBuffer, false, 0, combinedLightIn);
            txtBuffer.m_109911_();
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        if (tile.getDrawerAttributes().isShowingQuantity() && !betterFluidHandler2.getCacheFluid().isEmpty()) {
            fluidStackDown = betterFluidHandler2.getFluid();
            fontRenderer = this.font;
            txtBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            int amount = fluidStackDown.getAmount();
            String label = String.valueOf(amount) + "mB";
            int textWidth2 = fontRenderer.m_92895_(label);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.handleMatrixAngle(matrixStackIn, player, tile.m_58899_(), (Direction)tile.m_58900_().m_61143_((Property)BlockFluidDrawer.FACING));
            matrixStackIn.m_85841_(0.007f, 0.007f, 0.007f);
            fontRenderer.m_92811_(label, (float)(-textWidth2) / 2.0f, -18.0f, 0xFFFFFF, false, matrixStackIn.m_85850_().m_85861_(), (MultiBufferSource)txtBuffer, false, 0, combinedLightIn);
            txtBuffer.m_109911_();
        }
        matrixStackIn.m_85849_();
        this.render(partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlay);
    }

    private void handleMatrixAngle(PoseStack matrixStackIn, LocalPlayer player, BlockPos pos, Direction d) {
        Vector3d vector3d = new Vector3d(player.m_20318_(1.0f).m_7096_() - (double)pos.m_123341_() - 0.5, player.m_20318_(0.0f).m_7098_() - (double)pos.m_123342_(), player.m_20318_(0.0f).m_7094_() - (double)pos.m_123343_() - 0.5);
        if (d == Direction.DOWN || d == Direction.UP) {
            if (vector3d.f_86214_ > 0.0 && Math.abs(vector3d.f_86214_) > Math.abs(vector3d.f_86216_)) {
                d = Direction.EAST;
            }
            if (vector3d.f_86214_ < 0.0 && Math.abs(vector3d.f_86214_) > Math.abs(vector3d.f_86216_)) {
                d = Direction.WEST;
            }
            if (vector3d.f_86214_ > 0.0 && Math.abs(vector3d.f_86214_) < Math.abs(vector3d.f_86216_)) {
                d = Direction.SOUTH;
            }
            if (vector3d.f_86214_ < 0.0 && Math.abs(vector3d.f_86214_) < Math.abs(vector3d.f_86216_)) {
                d = Direction.NORTH;
            }
        }
        if ((Integer)ClientConfig.distance.get() != -1 && MathUtil.calDistanceSelf(vector3d) > (float)((Integer)ClientConfig.distance.get()).intValue()) {
            d = Direction.DOWN;
        }
        switch (d) {
            case SOUTH: {
                matrixStackIn.m_85837_(0.5, 0.15, 1.0);
                matrixStackIn.m_85845_(new Quaternion(0.0f, 180.0f, 180.0f, true));
                break;
            }
            case NORTH: {
                matrixStackIn.m_85845_(new Quaternion(0.0f, 0.0f, 180.0f, true));
                matrixStackIn.m_85837_(-0.5, -0.15, 0.0);
                break;
            }
            case EAST: {
                matrixStackIn.m_85845_(new Quaternion(0.0f, 270.0f, 180.0f, true));
                matrixStackIn.m_85837_(-0.5, -0.15, -1.0);
                break;
            }
            case WEST: {
                matrixStackIn.m_85845_(new Quaternion(0.0f, 90.0f, 180.0f, true));
                matrixStackIn.m_85837_(0.5, -0.15, 0.0);
                break;
            }
            default: {
                matrixStackIn.m_85841_(0.01f, 0.01f, 0.01f);
            }
        }
    }

    public void render(float p_112234_, PoseStack poseStack, MultiBufferSource bufferSource, int p_112237_, int p_112238_) {
        poseStack.m_85841_(0.001f, 0.001f, 0.001f);
        VertexConsumer vertexconsumer = BELL_RESOURCE_LOCATION.m_119194_(bufferSource, RenderType::m_110446_);
        this.bellBody.m_104301_(poseStack, vertexconsumer, p_112237_, p_112238_);
    }

    private void renderFluid(BlockEntityFluidDrawer tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        FluidStack fluidStackDown = null;
        FluidStack[] fluidStack = new FluidStack[1];
        tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(handler -> {
            fluidStack[0] = handler.getFluidInTank(0);
        });
        if (fluidStack[0] == null || fluidStack[0].getFluid() == Fluids.f_76191_ && !tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY)) {
            return;
        }
        fluidStackDown = fluidStack[0];
        if (tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY)) {
            BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = (BlockEntityFluidDrawer.betterFluidHandler)tile.getTank();
            if (fluidStackDown.getAmount() <= 0) {
                if (!betterFluidHandler2.getCacheFluid().isEmpty()) {
                    fluidStackDown = new FluidStack(betterFluidHandler2.getCacheFluid(), 1000);
                } else {
                    return;
                }
            }
        }
        FluidAttributes attributes = fluidStackDown.getFluid().getAttributes();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        TextureAtlasSprite still = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(fluidStackDown.getFluid().getAttributes().getStillTexture());
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int colorRGB = fluidStackDown.getFluid().getAttributes().getColor(fluidStackDown);
        int capacity = tile.getTankEffectiveCapacity();
        int amount = tile.getAndUpdateLastFluidAmount(animationTime);
        if (capacity < amount) {
            amount = capacity;
        }
        float r = (float)amount / (float)capacity;
        if (tile.upgrades().hasVendingUpgrade()) {
            r = 1.0f;
        }
        float height = r * 0.875f;
        float vHeight = (still.m_118412_() - still.m_118411_()) * (1.0f - r);
        matrixStackIn.m_85836_();
        GlStateManager.m_84094_();
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110466_());
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_() - vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118412_() - vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.064f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.064f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.064f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.064f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f, 0.936f, still.m_118409_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f, 0.936f, still.m_118410_(), still.m_118411_() + vHeight, colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.936f, 0.064f + height, 0.936f, still.m_118410_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        this.addVertex(buffer, matrixStackIn, 0.064f, 0.064f + height, 0.936f, still.m_118409_(), still.m_118412_(), colorRGB, 1.0f, combinedLight);
        GlStateManager.m_84091_();
        matrixStackIn.m_85849_();
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation sprite) {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(sprite);
    }

    private void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int RGBA, float alpha, int brightness) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA >> 0 & 0xFF) / 255.0f;
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        renderer.m_85982_(stack.m_85850_().m_85861_(), x, y, z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_7120_(light1, light2).m_86008_(OverlayTexture.f_118083_).m_85977_(stack.m_85850_().m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

